/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractFilter;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.MappingFilterImpl;
import org.jacorb.notification.filter.etcl.ETCLFilter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable,
Configurable,
ManageableServant {
    private ApplicationContext applicationContext_;
    private ORB orb_;
    private POA poa_;
    private boolean isApplicationContextCreatedHere_;
    private List allFilters_ = new ArrayList();
    private java.lang.Object allFiltersLock_ = this.allFilters_;
    private FilterFactory thisRef_;
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;
    private Object reference_;
    private Map availableFilters_ = new HashMap();
    static /* synthetic */ Class class$org$jacorb$notification$ApplicationContext;

    private static Iterator getAttributeNamesWithPrefix(Configuration configuration, String prefix) {
        ArrayList<String> _attributesWithPrefix = new ArrayList<String>();
        String[] _allAttributes = configuration.getAttributeNames();
        for (int x = 0; x < _allAttributes.length; ++x) {
            if (!_allAttributes[x].startsWith(prefix)) continue;
            _attributesWithPrefix.add(_allAttributes[x]);
        }
        return _attributesWithPrefix.iterator();
    }

    public FilterFactoryImpl() throws InvalidName, AdapterInactive {
        this.orb_ = ORB.init(new String[0], null);
        this.poa_ = POAHelper.narrow(this.orb_.resolve_initial_references("RootPOA"));
        this.applicationContext_ = new ApplicationContext(this.orb_, this.poa_);
        this.applicationContext_.configure((Configuration)((org.jacorb.orb.ORB)this.orb_).getConfiguration());
        this.isApplicationContextCreatedHere_ = true;
        this.getFilterFactory();
        this.poa_.the_POAManager().activate();
        Thread t = new Thread(new Runnable(){

            public void run() {
                FilterFactoryImpl.this.orb_.run();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public FilterFactoryImpl(ApplicationContext applicationContext) {
        this.applicationContext_ = applicationContext;
        this.poa_ = applicationContext.getPoa();
        this.orb_ = applicationContext.getOrb();
        this.isApplicationContextCreatedHere_ = false;
    }

    private void loadFilterPlugins(Configuration conf) throws ConfigurationException {
        Iterator i = FilterFactoryImpl.getAttributeNamesWithPrefix(conf, "jacorb.notification.filter.plugin");
        while (i.hasNext()) {
            String key = null;
            String _clazzName = null;
            try {
                key = (String)i.next();
                String _grammar = key.substring("jacorb.notification.filter.plugin".length() + 1);
                this.logger_.info("Loading Filterplugin for Grammar: " + _grammar);
                _clazzName = conf.getAttribute(key);
                Class _clazz = ObjectUtil.classForName(_clazzName);
                Constructor _constructor = _clazz.getConstructor(class$org$jacorb$notification$ApplicationContext == null ? FilterFactoryImpl.class$("org.jacorb.notification.ApplicationContext") : class$org$jacorb$notification$ApplicationContext);
                this.availableFilters_.put(_grammar, _constructor);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Property " + key + ": class " + _clazzName + " is unknown");
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Property " + key + ": does the c'tor of class " + _clazzName + " accept param ApplicationContext ?");
            }
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.config_ = (org.jacorb.config.Configuration)conf;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
        this.loadFilterPlugins(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter create_filter(String grammar) throws InvalidGrammar {
        final AbstractFilter _servant = this.create_filter_servant(grammar);
        _servant.setORB(this.orb_);
        _servant.setPOA(this.poa_);
        _servant.preActivate();
        Filter _filter = FilterHelper.narrow(_servant.activate());
        java.lang.Object object = this.allFiltersLock_;
        synchronized (object) {
            this.allFilters_.add(_servant);
            _servant.setDisposeHook(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
                    synchronized (object) {
                        FilterFactoryImpl.this.allFilters_.remove(_servant);
                    }
                }
            });
        }
        return _filter;
    }

    private String getFilterGrammarNames() {
        Iterator i = this.availableFilters_.keySet().iterator();
        StringBuffer b = new StringBuffer();
        while (i.hasNext()) {
            b.append(", ");
            b.append(i.next());
        }
        return b.toString();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFilter create_filter_servant(String grammar) throws InvalidGrammar {
        void var2_2;
        AbstractFilter _filterServant;
        if ("EXTENDED_TCL".equals(grammar)) {
            _filterServant = new ETCLFilter(this.applicationContext_);
        } else if (this.availableFilters_.containsKey(grammar)) {
            try {
                Constructor _constructor = (Constructor)this.availableFilters_.get(grammar);
                _filterServant = (AbstractFilter)_constructor.newInstance(this.applicationContext_);
            }
            catch (Exception e) {
                this.logger_.fatalError("unable to create custom filter", (Throwable)e);
                throw new UNKNOWN();
            }
        } else {
            throw new InvalidGrammar("Constraint Language '" + grammar + "' is not supported. Try one of the following: " + "EXTENDED_TCL" + this.getFilterGrammarNames());
        }
        var2_2.configure((Configuration)this.config_);
        return var2_2;
    }

    public MappingFilter create_mapping_filter(String grammar, Any any) throws InvalidGrammar {
        AbstractFilter _filterImpl = this.create_filter_servant(grammar);
        MappingFilterImpl _mappingFilterServant = new MappingFilterImpl(this.applicationContext_, _filterImpl, any);
        _mappingFilterServant.configure((Configuration)this.config_);
        MappingFilter _filter = _mappingFilterServant._this(this.orb_);
        return _filter;
    }

    public void setPOA(POA poa) {
    }

    public void setORB(ORB orb) {
    }

    public void preActivate() {
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception e) {
            this.logger_.fatalError("cannot deactivate object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    private Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.reference_ == null) {
            this.reference_ = FilterFactoryHelper.narrow(this.getServant()._this_object(this.orb_));
        }
        return this.reference_;
    }

    public void dispose() {
        this.deactivate();
        Iterator i = this.getAllFilters().iterator();
        while (i.hasNext()) {
            Disposable d = (Disposable)i.next();
            i.remove();
            d.dispose();
        }
        if (this.isApplicationContextCreatedHere_) {
            this.orb_.shutdown(true);
            this.applicationContext_.dispose();
        }
    }

    public synchronized FilterFactory getFilterFactory() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
        }
        return this.thisRef_;
    }

    public POA _default_POA() {
        return this.poa_;
    }

    public List getAllFilters() {
        return this.allFilters_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

