/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.ServerStartupDaemon;
import org.jacorb.imr.ServerStartupDaemonHelper;
import org.jacorb.imr.ServerStartupDaemonPOA;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class ServerStartupDaemonImpl
extends ServerStartupDaemonPOA {
    private ORB orb = null;
    private static final String out_prefix = ">> ";
    private ThreadPool stdout_pool = null;
    private ThreadPool stderr_pool = null;
    private Logger logger;

    public ServerStartupDaemonImpl(ORB orb) {
        this.orb = orb;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)myConfiguration).getNamedLogger("jacorb.imr");
        try {
            Registration _registration = null;
            _registration = RegistrationHelper.narrow(this.orb.resolve_initial_references("ImplementationRepository"));
            if (_registration == null) {
                throw new ConfigurationException("ImR not found");
            }
            POA poa = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            ServerStartupDaemon ssd = ServerStartupDaemonHelper.narrow(poa.servant_to_reference(this));
            HostInfo _me = new HostInfo(InetAddress.getLocalHost().getHostName(), ssd, this.orb.object_to_string(ssd));
            _registration.register_host(_me);
        }
        catch (Exception e) {
            throw new ConfigurationException("Caught Exception", (Throwable)e);
        }
        this.stdout_pool = new ThreadPool(new OutputForwarderFactory(new InputStreamSelector(){

            public InputStream getInputStream(Process p) {
                return p.getInputStream();
            }
        }), 100, 10);
        this.stderr_pool = new ThreadPool(new OutputForwarderFactory(new InputStreamSelector(){

            public InputStream getInputStream(Process p) {
                return p.getErrorStream();
            }
        }), 100, 10);
    }

    public int get_system_load() {
        return 0;
    }

    public void start_server(String command) throws ServerStartupFailed {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting: " + command);
            }
            Process _server = Runtime.getRuntime().exec(command);
            this.stdout_pool.putJob(_server);
            this.stderr_pool.putJob(_server);
        }
        catch (Exception _e) {
            this.logger.debug("Caught Exception", (Throwable)_e);
            throw new ServerStartupFailed(_e.toString());
        }
    }

    public static void main(String[] args) {
        try {
            ORB orb = ORB.init(args, null);
            ServerStartupDaemonImpl _ssd = new ServerStartupDaemonImpl(orb);
            _ssd.configure((Configuration)((org.jacorb.orb.ORB)orb).getConfiguration());
            orb.run();
        }
        catch (Exception _e) {
            _e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private class OutputForwarderFactory
    implements ConsumerFactory {
        private InputStreamSelector selector = null;

        public OutputForwarderFactory(InputStreamSelector selector) {
            this.selector = selector;
        }

        public Consumer create() {
            return new OutputForwarder(this.selector);
        }
    }

    private static interface InputStreamSelector {
        public InputStream getInputStream(Process var1);
    }

    private class OutputForwarder
    implements Consumer {
        private InputStreamSelector selector = null;

        public OutputForwarder(InputStreamSelector selector) {
            this.selector = selector;
        }

        public void doWork(Object job) {
            Process p = (Process)job;
            BufferedReader _in = new BufferedReader(new InputStreamReader(this.selector.getInputStream(p)));
            String _line = null;
            try {
                while ((_line = _in.readLine()) != null) {
                    System.out.println(ServerStartupDaemonImpl.out_prefix + _line);
                }
                _in.close();
            }
            catch (Exception _e) {
                ServerStartupDaemonImpl.this.logger.debug("Caught Exception", (Throwable)_e);
            }
            ServerStartupDaemonImpl.this.logger.debug("A server process exited");
        }
    }
}

