/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.WriterTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;

class LogKitLoggerFactory
implements LoggerFactory {
    private static final String DEFAULT_LOG_PATTERN = "[%.20{category}] %.7{priority} : %{message}\\n%{throwable}";
    private static final String name = "logkit";
    private PatternFormatter logFormatter = null;
    private int defaultPriority = 0;
    private final Map namedLoggers = new HashMap();
    private boolean append = false;
    private Writer consoleWriter;
    private LogTarget consoleTarget;
    private LogTarget defaultTarget = null;
    private Configuration configuration = null;

    LogKitLoggerFactory() {
    }

    public void configure(org.apache.avalon.framework.configuration.Configuration configuration) throws ConfigurationException {
        this.configuration = (Configuration)configuration;
        this.defaultPriority = configuration.getAttributeAsInteger("jacorb.log.default.verbosity", 0);
        this.append = configuration.getAttribute("jacorb.logfile.append", "off").equals("on");
        this.logFormatter = new PatternFormatter(configuration.getAttribute("jacorb.log.default.log_pattern", DEFAULT_LOG_PATTERN));
        switch (this.defaultPriority) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ConfigurationException("'" + this.defaultPriority + "' is an illegal" + " value for the property jacorb.log.default.verbosity. Valid values are [0-4]");
            }
        }
        this.consoleWriter = new OutputStreamWriter(System.err);
        this.consoleTarget = new WriterTarget(this.consoleWriter, (Formatter)this.logFormatter);
    }

    public void setDefaultPriority(int priority) {
        this.defaultPriority = priority;
    }

    public final String getLoggingBackendName() {
        return name;
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String name) {
        return this.getNamedLogger(name, null);
    }

    public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String name) {
        return this.getNamedLogger(name, this.consoleTarget);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String name, String logFileName, long maxLogSize) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Log file name must not be null!");
        }
        FileOutputStream logStream = new FileOutputStream(logFileName, this.append);
        WriterTarget target = null;
        if (maxLogSize == 0L) {
            OutputStreamWriter logWriter = new OutputStreamWriter(logStream);
            target = new WriterTarget((Writer)logWriter, (Formatter)this.logFormatter);
        } else {
            target = new RotatingFileTarget(this.append, (Formatter)this.logFormatter, (RotateStrategy)new RotateStrategyBySize(maxLogSize * 1000L), (FileStrategy)new RevolvingFileStrategy(new File(logFileName), 10000));
        }
        return this.getNamedLogger(name, (LogTarget)target);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String name, LogTarget target) {
        Object o = this.namedLoggers.get(name);
        if (o != null) {
            return (org.apache.avalon.framework.logger.Logger)o;
        }
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(name);
        int priority = this.getPriorityForNamedLogger(name);
        logger.setPriority(LogKitLoggerFactory.intToPriority(priority));
        if (target != null) {
            logger.setLogTargets(new LogTarget[]{target});
        } else if (this.defaultTarget == null) {
            logger.setLogTargets(new LogTarget[]{this.consoleTarget});
        } else {
            logger.setLogTargets(new LogTarget[]{this.defaultTarget});
        }
        LogKitLogger result = new LogKitLogger(logger);
        this.namedLoggers.put(name, result);
        return result;
    }

    public int getPriorityForNamedLogger(String name) {
        String prefix = name;
        while (!prefix.equals("")) {
            Object priorityString = null;
            try {
                int priorityForLogger = this.configuration.getAttributeAsInteger(prefix + ".log.verbosity");
                if (priorityForLogger > 4) {
                    priorityForLogger = 4;
                } else if (priorityForLogger < 0) {
                    priorityForLogger = 0;
                }
                return priorityForLogger;
            }
            catch (ConfigurationException ce) {
                if (prefix.lastIndexOf(".") >= 0) {
                    prefix = prefix.substring(0, prefix.lastIndexOf("."));
                    continue;
                }
                prefix = "";
            }
        }
        return this.defaultPriority;
    }

    public static Priority intToPriority(int priority) {
        switch (priority) {
            case 4: {
                return Priority.DEBUG;
            }
            case 3: {
                return Priority.INFO;
            }
            case 2: {
                return Priority.WARN;
            }
            case 1: {
                return Priority.ERROR;
            }
        }
        return Priority.FATAL_ERROR;
    }

    public void setDefaultLogFile(String fileName, long maxLogSize) throws IOException {
        FileOutputStream logStream = new FileOutputStream(fileName, this.append);
        if (maxLogSize == 0L) {
            OutputStreamWriter logWriter = new OutputStreamWriter(logStream);
            this.defaultTarget = new WriterTarget((Writer)logWriter, (Formatter)this.logFormatter);
        } else {
            this.defaultTarget = new RotatingFileTarget(this.append, (Formatter)this.logFormatter, (RotateStrategy)new RotateStrategyBySize(maxLogSize * 1000L), (FileStrategy)new RevolvingFileStrategy(new File(fileName), 10000));
        }
    }
}

