/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.config.element.ListEntries;
import org.apache.myfaces.config.element.ListEntry;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.ManagedProperty;
import org.apache.myfaces.config.element.MapEntries;
import org.apache.myfaces.config.element.MapEntry;
import org.apache.myfaces.util.ClassUtils;

public class ManagedBeanBuilder {
    static /* synthetic */ Class class$java$lang$String;

    public Object buildManagedBean(FacesContext facesContext, ManagedBean beanConfiguration) throws FacesException {
        Object bean = ClassUtils.newInstance(beanConfiguration.getManagedBeanClassName());
        switch (beanConfiguration.getInitMode()) {
            case 1: {
                try {
                    this.initializeProperties(facesContext, beanConfiguration.getManagedProperties(), bean);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(e.getMessage() + " for bean '" + beanConfiguration.getManagedBeanName() + "' check the configuration to make sure all properties correspond with get/set methods");
                }
            }
            case 2: {
                if (!(bean instanceof Map)) {
                    throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a Map.");
                }
                this.initializeMap(facesContext, beanConfiguration.getMapEntries(), (Map)bean);
                break;
            }
            case 3: {
                if (!(bean instanceof List)) {
                    throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a List.");
                }
                this.initializeList(facesContext, beanConfiguration.getListEntries(), (List)bean);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown managed bean type " + bean.getClass().getName() + " for managed bean " + beanConfiguration.getManagedBeanName() + '.');
            }
        }
        return bean;
    }

    private void initializeProperties(FacesContext facesContext, Iterator managedProperties, Object bean) {
        while (managedProperties.hasNext()) {
            ManagedProperty property = (ManagedProperty)managedProperties.next();
            Object value = null;
            switch (property.getType()) {
                case 4: {
                    value = new ArrayList();
                    this.initializeList(facesContext, property.getListEntries(), (List)value);
                    break;
                }
                case 1: {
                    value = new HashMap();
                    this.initializeMap(facesContext, property.getMapEntries(), (Map)value);
                    break;
                }
                case 2: {
                    value = null;
                    break;
                }
                case 3: {
                    value = property.getRuntimeValue(facesContext);
                }
            }
            PropertyResolver propertyResolver = facesContext.getApplication().getPropertyResolver();
            Class propertyClass = null;
            propertyClass = property.getPropertyClass() == null ? propertyResolver.getType(bean, (Object)property.getPropertyName()) : ClassUtils.simpleJavaTypeToClass(property.getPropertyClass());
            if (null == propertyClass) {
                throw new IllegalArgumentException("unable to find the type of property " + property.getPropertyName());
            }
            Object coercedValue = ClassUtils.convertToType(value, propertyClass);
            propertyResolver.setValue(bean, (Object)property.getPropertyName(), coercedValue);
        }
    }

    private void initializeMap(FacesContext facesContext, MapEntries mapEntries, Map map) {
        Class keyClass;
        Application application = facesContext.getApplication();
        Class clazz = mapEntries.getKeyClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : (keyClass = ClassUtils.simpleJavaTypeToClass(mapEntries.getKeyClass()));
        Class valueClass = mapEntries.getValueClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : ClassUtils.simpleJavaTypeToClass(mapEntries.getValueClass());
        Iterator iterator = mapEntries.getMapEntries();
        while (iterator.hasNext()) {
            ValueBinding valueBinding;
            MapEntry entry = (MapEntry)iterator.next();
            Object key = entry.getKey();
            if (UIComponentTag.isValueReference((String)key)) {
                valueBinding = application.createValueBinding((String)key);
                key = valueBinding.getValue(facesContext);
            }
            if (entry.isNullValue()) {
                map.put(ClassUtils.convertToType(key, keyClass), null);
                continue;
            }
            Object value = entry.getValue();
            if (UIComponentTag.isValueReference((String)value)) {
                valueBinding = application.createValueBinding((String)value);
                value = valueBinding.getValue(facesContext);
            }
            map.put(ClassUtils.convertToType(key, keyClass), ClassUtils.convertToType(value, valueClass));
        }
    }

    private void initializeList(FacesContext facesContext, ListEntries listEntries, List list) {
        Application application = facesContext.getApplication();
        Class clazz = listEntries.getValueClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : ClassUtils.simpleJavaTypeToClass(listEntries.getValueClass());
        Class valueClass = clazz;
        Iterator iterator = listEntries.getListEntries();
        while (iterator.hasNext()) {
            ListEntry entry = (ListEntry)iterator.next();
            if (entry.isNullValue()) {
                list.add(null);
                continue;
            }
            Object value = entry.getValue();
            if (UIComponentTag.isValueReference((String)value)) {
                ValueBinding valueBinding = application.createValueBinding((String)value);
                value = valueBinding.getValue(facesContext);
            }
            list.add(ClassUtils.convertToType(value, valueClass));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

