/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.Util;

public class DatabaseCertLoginModule
extends BaseCertLoginModule {
    private String dsJndiName;
    private String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
        this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, (AbstractServerLoginModule)this);
        return roleSets;
    }
}

