/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.SocketServerInvoker;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger((Class)ServerThread.class);
    protected BufferedInputStream bis;
    protected BufferedOutputStream bos;
    protected ObjectInputStream in;
    protected ObjectOutputStream out;
    protected Socket socket;
    protected SocketServerInvoker invoker;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected volatile boolean running = true;
    protected volatile boolean handlingResponse = true;
    protected volatile boolean shutdown = false;
    protected static int id = 0;

    public static synchronized int nextID() {
        int nextID = id++;
        return nextID;
    }

    public ServerThread(Socket socket, SocketServerInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout) throws Exception {
        super("SocketServerInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID());
        this.socket = socket;
        this.invoker = invoker;
        this.clientpool = clientpool;
        this.threadpool = threadpool;
        socket.setSoTimeout(timeout);
    }

    public void shutdown() {
        this.shutdown = true;
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void evict() {
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void wakeup(Socket socket, int timeout) throws Exception {
        this.socket = socket;
        String name = "SocketServerInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID();
        super.setName(name);
        socket.setSoTimeout(timeout);
        this.running = true;
        this.handlingResponse = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                this.dorun();
                if (this.shutdown) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        this.clientpool.remove(this);
                        return;
                    }
                }
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        LinkedList linkedList = this.threadpool;
                        synchronized (linkedList) {
                            this.clientpool.remove(this);
                            this.threadpool.add(this);
                            Thread.interrupted();
                            ((Object)((Object)this.clientpool)).notify();
                        }
                    }
                    log.debug((Object)"begin thread wait");
                    this.wait();
                    log.debug((Object)"WAKEUP in SERVER THREAD");
                }
            }
        }
        catch (Exception exception) {
            log.debug((Object)"Exiting run on exception", (Throwable)exception);
            return;
        }
    }

    protected void acknowledge() throws Exception {
        byte ACK = 0;
        long startWait = System.currentTimeMillis();
        try {
            ACK = this.in.readByte();
        }
        catch (EOFException eof) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("socket timeout is set to : " + this.socket.getSoTimeout()));
                log.trace((Object)("EOFException waiting on ACK in readByte(). Time waited was " + (System.currentTimeMillis() - startWait)));
            }
            throw eof;
        }
        catch (IOException e) {
            log.debug((Object)"IOException when reading in ACK", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("***acknowledge read byte" + Thread.currentThread()));
        }
        this.handlingResponse = true;
        this.out.writeByte(ACK);
        this.out.flush();
        this.out.reset();
    }

    protected void processInvocation() throws Exception {
        this.handlingResponse = true;
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(this.invoker.getLocator(), this.getClass().getClassLoader());
        if (unmarshaller == null) {
            unmarshaller = MarshalFactory.getUnMarshaller(this.invoker.getDataType());
        }
        Object obj = unmarshaller.read(this.in, null);
        Object resp = null;
        try {
            boolean interrupted = Thread.interrupted();
            resp = this.invoker.invoke(obj);
        }
        catch (Exception ex) {
            resp = ex;
        }
        Thread.interrupted();
        Marshaller marshaller = MarshalFactory.getMarshaller(this.invoker.getLocator(), this.getClass().getClassLoader());
        if (marshaller == null) {
            marshaller = MarshalFactory.getMarshaller(this.invoker.getDataType());
        }
        marshaller.write(resp, this.out);
        this.handlingResponse = false;
    }

    protected void dorun() {
        log.debug((Object)"beginning dorun");
        this.running = true;
        this.handlingResponse = true;
        try {
            this.bos = new BufferedOutputStream(this.socket.getOutputStream());
            this.out = new ObjectOutputStream(this.bos);
            this.out.flush();
            this.bis = new BufferedInputStream(this.socket.getInputStream());
            this.in = new ObjectInputStream(this.bis);
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize", (Throwable)e);
        }
        try {
            this.processInvocation();
        }
        catch (Exception ex) {
            log.debug((Object)"failed to process invocation.", (Throwable)ex);
            this.running = false;
        }
        while (this.running) {
            try {
                this.acknowledge();
                this.processInvocation();
            }
            catch (InterruptedIOException e) {
                log.debug((Object)"socket timed out", (Throwable)e);
                this.running = false;
            }
            catch (InterruptedException e) {
                log.debug((Object)"interrupted", (Throwable)e);
            }
            catch (Exception ex) {
                log.debug((Object)"failed", (Throwable)ex);
                this.running = false;
            }
            Thread.interrupted();
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed cleanup", (Throwable)ex);
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }
}

