/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

public class HTTPUnMarshaller
extends SerializableUnMarshaller {
    public static final String DATATYPE = "http";
    protected final Logger log = Logger.getLogger(this.getClass());

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        String ret = null;
        int bufferSize = 1024;
        byte[] byteBuffer = new byte[bufferSize];
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        int pointer = 0;
        int amtRead = inputStream.read(byteBuffer);
        while (amtRead > 0) {
            byteOutputStream.write(byteBuffer, pointer, amtRead);
            if (amtRead < bufferSize) break;
            amtRead = inputStream.read(byteBuffer);
        }
        byteOutputStream.flush();
        byte[] totalByteArray = byteOutputStream.toByteArray();
        if (totalByteArray.length == 0) {
            return null;
        }
        try {
            return super.read(new ByteArrayInputStream(totalByteArray), metadata);
        }
        catch (StreamCorruptedException sce) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(totalByteArray)));
                StringBuffer buffer = new StringBuffer();
                String str = null;
                while ((str = reader.readLine()) != null) {
                    buffer.append(str);
                }
                reader.close();
                ret = buffer.toString();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not unmarshall inputstream.  Tried to unmarshall as both an object and string type.", (Throwable)e);
                throw new IOException("Can not unmarshall inputstream.");
            }
            return ret;
        }
    }
}

