/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.util.id.GUID;

public class Client {
    public static final int MAX_NUM_ONEWAY_THREADS = 10;
    private static final Logger log = Logger.getLogger((Class)Client.class);
    private ClientInvoker invoker;
    private ClassLoader classloader;
    private String subsystem;
    private String sessionId = new GUID().toString();
    private static PooledExecutor onewayExecutor;
    private static int onewayThreadCounter;
    public static final String RAW = "RAW_PAYLOAD";

    public Client(InvokerLocator locator) throws Exception {
        this(locator, null);
    }

    public Client(InvokerLocator locator, String subsystem) throws Exception {
        this(Thread.currentThread().getContextClassLoader(), locator, subsystem);
    }

    public Client(ClassLoader cl, InvokerLocator locator, String subsystem) throws Exception {
        this(cl, InvokerRegistry.createClientInvoker(locator), subsystem);
    }

    public Client(ClassLoader cl, ClientInvoker invoker, String subsystem) throws Exception {
        this.classloader = cl;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.invoker = invoker;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return this.invoker != null && this.invoker.isConnected();
    }

    public void connect() throws Exception {
        this.invoker.connect();
    }

    public void disconnect() {
        this.invoker.disconnect();
    }

    public ClientInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClientInvoker invoker) {
        this.invoker = invoker;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    private void setClientLocator(InvokerLocator locator) throws Exception {
        if (this.invoker == null) {
            throw new Exception("Can not set client locator because client invoker is null.");
        }
        this.invoker.setClientLocator(locator);
    }

    public Object invoke(Object param) throws Throwable {
        return this.invoke(param, null);
    }

    public Object invoke(Object param, Map metadata) throws Throwable {
        ClientInvoker localInvoker = this.invoker;
        if (localInvoker != null) {
            if (!localInvoker.isConnected()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("invoke called, but our invoker is disconnected, discarding and fetching another fresh invoker for: " + this.invoker.getLocator()));
                }
                localInvoker = InvokerRegistry.createClientInvoker(localInvoker.getLocator());
                this.connect();
            }
        } else {
            throw new Exception("Can not perform invoke because invoker is null.");
        }
        Object ret = localInvoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, null));
        this.invoker = localInvoker;
        return ret;
    }

    public void invokeOneway(final Object param, final Map sendPayload, boolean clientSide) throws Throwable {
        if (clientSide) {
            Executor executor = Client.getOnewayExecutor();
            Runnable onewayRun = new Runnable(){

                public void run() {
                    try {
                        Client.this.invoke(param, sendPayload);
                    }
                    catch (Throwable e) {
                        log.error((Object)("Error executing client oneway invocation request: " + param), e);
                    }
                }
            };
            executor.execute(onewayRun);
        } else {
            OnewayInvocation invocation = new OnewayInvocation(param);
            this.invoke(invocation, sendPayload);
        }
    }

    private static synchronized Executor getOnewayExecutor() {
        if (onewayExecutor == null) {
            onewayExecutor = new PooledExecutor(10);
            onewayExecutor.setKeepAliveTime(3000L);
            onewayExecutor.waitWhenBlocked();
            onewayExecutor.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "Remoting client oneway " + onewayThreadCounter++);
                }
            });
        }
        return onewayExecutor;
    }

    public void invokeOneway(Object param, Map sendPayload) throws Throwable {
        this.invokeOneway(param, sendPayload, false);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        this.addListener(callbackHandler, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator) throws Throwable {
        this.addListener(callbackHandler, clientLocator, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject) throws Throwable {
        this.invoker.setClientLocator(clientLocator);
        if (clientLocator != null) {
            Client client = new Client(clientLocator, this.subsystem);
            client.setSessionId(this.getSessionId());
            client.connect();
            client.invoke(new InternalInvocation("addClientListener", new Object[]{callbackHandler, callbackHandlerObject}), null);
            client.disconnect();
        }
        this.invoke(new InternalInvocation("addListener", null), null);
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        InvokerLocator locator = this.invoker.getClientLocator();
        if (locator != null) {
            Client client = new Client(locator, this.subsystem);
            client.setSessionId(this.getSessionId());
            client.connect();
            client.invoke(new InternalInvocation("removeClientListener", new Object[]{callbackHandler}), null);
            client.disconnect();
        }
        this.invoke(new InternalInvocation("removeListener", null), null);
    }

    public List getCallbacks() throws Throwable {
        return (List)this.invoke(new InternalInvocation("getCallbacks", null), null);
    }

    public void setMarshaller(Marshaller marshaller) {
        if (this.invoker != null && marshaller != null) {
            this.invoker.setMarshaller(marshaller);
        }
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        if (this.invoker != null && unmarshaller != null) {
            this.invoker.setUnMarshaller(unmarshaller);
        }
    }

    static {
        onewayThreadCounter = 0;
    }
}

