/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.CallbackStoreMBean;

public class CallbackStore
implements CallbackStoreMBean {
    private String filePath = null;
    private String fileSuffix = "ser";
    private boolean isStarted = false;
    private boolean purgeOnShutdown = false;
    public static final String FILE_PATH_KEY = "StoreFilePath";
    public static final String FILE_SUFFIX_KEY = "StoreFileSuffix";
    private static final Logger log = Logger.getLogger((Class)CallbackStore.class);

    public CallbackStore() {
    }

    public CallbackStore(boolean purgeOnDestroy) {
        this.purgeOnShutdown = purgeOnDestroy;
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            boolean madeDir;
            File storeFile;
            if (this.filePath == null) {
                this.filePath = System.getProperty("jboss.server.data.dir", "data");
            }
            if (!(storeFile = new File(this.filePath)).exists() && !(madeDir = storeFile.mkdirs())) {
                throw new IOException("Can not create directory for store.  Path given: " + this.filePath);
            }
            this.isStarted = true;
        }
    }

    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
        this.purgeOnShutdown = purgeOnShutdown;
    }

    public boolean getPurgeOnShutdown() {
        return this.purgeOnShutdown;
    }

    public void create() throws Exception {
    }

    public void stop() {
        this.isStarted = false;
    }

    public void destroy() {
        if (this.purgeOnShutdown) {
            this.purgeFiles();
        }
    }

    public void purgeFiles() {
        String[] fileList = this.getObjectFileList();
        String fileToDelete = null;
        for (int x = 0; x < fileList.length; ++x) {
            try {
                fileToDelete = this.filePath + System.getProperty("file.separator") + fileList[x];
                File currentFile = new File(fileToDelete);
                boolean deleted = currentFile.delete();
                if (deleted) continue;
                log.warn((Object)("Error purging file " + fileToDelete));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Error purging file " + fileToDelete));
            }
        }
    }

    public void setConfig(Map config) {
        if (config != null) {
            String newFileSuffix;
            String newFilePath = (String)config.get(FILE_PATH_KEY);
            if (newFilePath != null) {
                this.filePath = newFilePath;
            }
            if ((newFileSuffix = (String)config.get(FILE_SUFFIX_KEY)) != null) {
                this.fileSuffix = newFileSuffix;
            }
        }
    }

    public String getStoreFilePath() {
        return this.filePath;
    }

    public void setStoreFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getStoreFileSuffix() {
        return this.fileSuffix;
    }

    public void setStoreFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public int size() {
        this.verifyStarted();
        String[] objectFileList = this.getObjectFileList();
        if (objectFileList != null) {
            return objectFileList.length;
        }
        return 0;
    }

    private void verifyStarted() {
        if (!this.isStarted) {
            throw new RuntimeException("Can not call upon this store method before it has been started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNext() throws IOException {
        this.verifyStarted();
        Object obj = null;
        String objectFilePath = null;
        String string = this.filePath;
        synchronized (string) {
            String[] objectFileList = this.getObjectFileList();
            FileInputStream inFile = null;
            ObjectInputStream in = null;
            if (objectFileList != null && objectFileList.length > 0) {
                try {
                    objectFilePath = this.filePath + System.getProperty("file.separator") + objectFileList[0];
                    inFile = new FileInputStream(objectFilePath);
                    in = new ObjectInputStream(inFile);
                    try {
                        obj = in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Error loading persisted object.  Could not load class (" + e.getMessage() + ").");
                    }
                }
                finally {
                    if (inFile != null) {
                        try {
                            inFile.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                        }
                    }
                }
            }
        }
        if (objectFilePath != null) {
            File objectFile = new File(objectFilePath);
            boolean isDeleted = objectFile.delete();
            if (log.isTraceEnabled()) {
                log.trace((Object)("object file (" + objectFilePath + ") has been deleted - " + isDeleted));
            }
        }
        return obj;
    }

    private String[] getObjectFileList() {
        File storePath = new File(this.filePath);
        String[] objectFileList = storePath.list(new StoreFileFilter());
        return objectFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Serializable object) throws IOException {
        this.verifyStarted();
        String string = this.filePath;
        synchronized (string) {
            long currentTimestamp = System.currentTimeMillis();
            File storeFile = new File(this.filePath + System.getProperty("file.separator") + String.valueOf(currentTimestamp) + "." + this.fileSuffix);
            FileOutputStream outFile = null;
            ObjectOutputStream out = null;
            try {
                outFile = new FileOutputStream(storeFile, false);
                out = new ObjectOutputStream(outFile);
                out.writeObject(object);
                out.flush();
            }
            finally {
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                    }
                }
            }
        }
    }

    public class StoreFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(CallbackStore.this.fileSuffix);
        }
    }
}

