/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CachedDataRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;

class TextTable
extends Table {
    private String dataSource = "";
    private boolean isReversed = false;

    TextTable(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        super(database, hsqlName, n, n2);
    }

    private void openCache(String string, boolean bl, boolean bl2) throws HsqlException {
        if (string == null) {
            string = "";
        }
        this.database.logger.closeTextCache(this);
        this.cache = null;
        this.clearAllRows();
        if (string.length() > 0) {
            try {
                this.cache = this.database.logger.openTextCache(this, string, bl2, bl);
                TextCache textCache = (TextCache)this.cache;
                CachedDataRow cachedDataRow = null;
                int n = 0;
                while ((cachedDataRow = (CachedDataRow)this.rowStore.get(n = textCache.getNextRowPos())) != null) {
                    cachedDataRow.setNewNodes();
                    this.insertNoChange(cachedDataRow);
                }
            }
            catch (HsqlException hsqlException) {
                int n;
                int n2 = n = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
                if (!this.dataSource.equals(string) || bl != this.isReversed || bl2 != this.isReadOnly) {
                    this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
                } else {
                    if (this.cache != null) {
                        this.cache.close(false);
                    }
                    this.cache = null;
                    this.dataSource = "";
                    this.isReversed = false;
                }
                throw Trace.error(76, new Object[]{new Integer(n), hsqlException.getMessage()});
            }
        }
        this.dataSource = string;
        this.isReversed = bl && string.length() > 0;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        if (this.isTemp) {
            Trace.check(session.getId() == this.ownerSessionId, 33);
        } else {
            session.checkAdmin();
        }
        string = string.trim();
        if (bl2 && FileUtil.exists(string)) {
            throw Trace.error(196, string);
        }
        if (bl || bl != this.isReversed || !this.dataSource.equals(string)) {
            this.openCache(string, bl, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String string) throws HsqlException {
        if (this.cache != null && ((TextCache)this.cache).ignoreFirst) {
            ((TextCache)this.cache).setHeader(string);
            return;
        }
        throw Trace.error(150);
    }

    public String getHeader() {
        String string = ((TextCache)this.cache).getHeader();
        return string == null ? null : StringConverter.toQuotedString(string, '\"', true);
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.dataSource.length() == 0) {
            throw Trace.error(48);
        }
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (this.isReversed && bl) {
            throw Trace.error(32);
        }
        this.openCache(this.dataSource, this.isReversed, bl);
        this.isReadOnly = bl;
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws HsqlException {
        return new TextTable(this.database, this.tableName, this.getTableType(), this.ownerSessionId);
    }

    void drop() throws HsqlException {
        this.openCache("", false, false);
    }

    void setIndexRoots(String string) throws HsqlException {
    }
}

