/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;

public class SetFunction {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int type;
    private int count;
    private boolean hasNull;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    long hi;
    long lo;
    private double sk;
    private double vk;
    private double v;
    private long n;
    private boolean initialized;

    SetFunction(int n, int n2, boolean bl) {
        this.setType = n;
        this.type = n2;
        if (bl) {
            this.isDistinct = true;
            this.distinctValues = new HashSet();
        }
    }

    void add(Object object) throws HsqlException {
        if (object == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(object)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 40: {
                return;
            }
            case 41: 
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)object).intValue();
                        return;
                    }
                    case -5: {
                        this.addLong(((Number)object).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)object).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)object : this.currentBigDecimal.add((BigDecimal)object);
                        return;
                    }
                }
                throw Trace.error(15);
            }
            case 42: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (Column.compare(this.currentValue, object, this.type) > 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 43: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (Column.compare(this.currentValue, object, this.type) < 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 45: 
            case 46: {
                return;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.addDataPoint((Number)object);
                return;
            }
        }
    }

    Object getValue() throws HsqlException {
        if (this.setType == 40) {
            return new Integer(this.count);
        }
        if (this.count == 0) {
            return null;
        }
        switch (this.setType) {
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong / (long)this.count);
                    }
                    case -5: {
                        long l = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(l);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal.divide(new BigDecimal((double)this.count), 5);
                    }
                }
                throw Trace.error(15);
            }
            case 41: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong);
                    }
                    case -5: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                }
                throw Trace.error(15);
            }
            case 42: 
            case 43: {
                return this.currentValue;
            }
            case 45: {
                return this.hasNull ? Boolean.FALSE : Boolean.TRUE;
            }
            case 46: {
                return this.count == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 47: 
            case 48: {
                return this.getStdDev();
            }
            case 49: 
            case 50: {
                return this.getVariance();
            }
        }
        throw Trace.error(95);
    }

    static int getType(int n, int n2) throws HsqlException {
        switch (n) {
            case 40: {
                return 4;
            }
            case 44: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 41: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case -5: {
                        return 3;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 42: 
            case 43: {
                return n2;
            }
            case 45: 
            case 46: {
                return 16;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return 8;
            }
        }
        throw Trace.error(95);
    }

    void addLong(long l) {
        if (l != 0L) {
            if (l > 0L) {
                this.hi += l >> 32;
                this.lo += l & 0xFFFFFFFFL;
            } else if (l == Long.MIN_VALUE) {
                this.hi -= 0x80000000L;
            } else {
                long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hi -= l2 >> 32;
                this.lo -= l2 & 0xFFFFFFFFL;
            }
        }
    }

    BigInteger getLongSum() throws HsqlException {
        BigInteger bigInteger = BigInteger.valueOf(this.lo);
        BigInteger bigInteger2 = BigInteger.valueOf(this.hi);
        BigInteger bigInteger3 = bigInteger2.multiply(multiplier).add(bigInteger);
        return bigInteger3;
    }

    private void addDataPoint(Number number) {
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = d;
            this.vk = 0.0;
            this.v = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        this.vk += Math.pow(this.sk - (double)(this.n - 1L) * d, 2.0) / (double)this.n / (double)(this.n - 1L);
        this.sk += d;
        this.v = this.vk / (double)this.n;
    }

    private Number getVariance() {
        return this.initialized ? new Double(this.v) : null;
    }

    private Number getStdDev() {
        return this.initialized ? new Double(Math.sqrt(this.v)) : null;
    }
}

