/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class DiskNode
extends Node {
    protected Row rData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    static final int SIZE_IN_BYTE = 16;

    DiskNode(CachedRow cachedRow, RowInputInterface rowInputInterface, int n) throws IOException, HsqlException {
        this.iId = n;
        this.rData = cachedRow;
        this.iBalance = rowInputInterface.readIntData();
        this.iLeft = rowInputInterface.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = rowInputInterface.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = rowInputInterface.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow cachedRow, int n) {
        this.iId = n;
        this.rData = cachedRow;
    }

    void delete() {
        this.iBalance = -2;
    }

    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return -1;
    }

    Row getRow() throws HsqlException {
        return this.rData;
    }

    private Node findNode(int n) throws HsqlException {
        Node node = null;
        CachedRow cachedRow = ((CachedRow)this.rData).getTable().getRow(n, null);
        if (cachedRow != null) {
            node = cachedRow.getNode(this.iId);
        }
        return node;
    }

    Node getLeft() throws HsqlException {
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft);
    }

    Node getRight() throws HsqlException {
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight);
    }

    Node getParent() throws HsqlException {
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent);
    }

    boolean isRoot() {
        return this.iParent == -1;
    }

    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        DiskNode diskNode = (DiskNode)this.getParent();
        if (diskNode.iLeft != -1) {
            return this.getKey() == diskNode.iLeft;
        }
        return this.equals(diskNode.getLeft());
    }

    Object[] getData() throws HsqlException {
        return this.rData.getData();
    }

    void setParent(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iParent = -1;
        if (node != null) {
            this.iParent = node.getKey();
        }
    }

    void setBalance(int n) throws HsqlException {
        if (this.iBalance != n) {
            ((CachedRow)this.rData).setChanged();
            this.iBalance = n;
        }
    }

    void setLeft(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iLeft = -1;
        if (node != null) {
            this.iLeft = node.getKey();
        }
    }

    void setRight(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iRight = -1;
        if (node != null) {
            this.iRight = node.getKey();
        }
    }

    boolean equals(Node node) {
        return this == node || node != null && this.getKey() == ((DiskNode)node).getKey();
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeIntData(this.iBalance);
        rowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        rowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        rowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }

    Node getUpdatedNode() throws HsqlException {
        Row row = this.rData.getUpdatedRow();
        return row == null ? null : row.getNode(this.iId);
    }

    void writeTranslate(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeIntData(this.iBalance);
        this.writeTranslatePointer(this.iLeft, rowOutputInterface, intLookup);
        this.writeTranslatePointer(this.iRight, rowOutputInterface, intLookup);
        this.writeTranslatePointer(this.iParent, rowOutputInterface, intLookup);
    }

    private void writeTranslatePointer(int n, RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        int n2 = 0;
        if (n != -1) {
            n2 = intLookup.lookupFirstEqual(n);
        }
        rowOutputInterface.writeIntData(n2);
    }
}

