/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats.report;

import java.util.Iterator;
import java.util.Map;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.TxReport;
import org.jboss.varia.stats.TxStatistics;
import org.jboss.varia.stats.report.ReportGenerator;

public class GeneralReportGenerator
extends ReportGenerator {
    public void content(String reportName, StringBuffer buf) throws Exception {
        buf.append("<table><tr valign='top'><td>");
        buf.append("<table>");
        buf.append("<tr><th>Transaction started by</th><th>total</th>");
        buf.append("</tr>");
        TxStatistics stats = this.getTxStatistics();
        Iterator iter = stats.getReports();
        while (iter.hasNext()) {
            boolean anchor;
            TxReport report = (TxReport)iter.next();
            String name = report.getName();
            buf.append("<tr valign='top'>").append("<td>");
            boolean bl = anchor = !name.equals(reportName) && reportName != null;
            if (anchor) {
                buf.append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(this.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append(name).append("'>");
            }
            buf.append(name).append("</td><td>").append(report.getCount()).append("</td>");
            if (anchor) {
                buf.append("</a>");
            }
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        buf.append("</td><td>");
        TxReport report = stats.getReports(reportName);
        if (report != null) {
            int i;
            buf.append("<table><tr>");
            String[] itemNames = stats.getCollectedItemNames();
            for (i = 0; i < itemNames.length; ++i) {
                buf.append("<th>").append(itemNames[i]).append("</th>");
            }
            buf.append("</tr><tr valign='top'>");
            for (i = 0; i < itemNames.length; ++i) {
                buf.append("<td>");
                String itemName = itemNames[i];
                Map itemMap = (Map)report.getStats().get(itemName);
                if (itemMap != null && !itemMap.isEmpty()) {
                    buf.append("<table width='100%'>").append("<tr><th>item</th><th>%</th><th>avg</th><th>min</th><th>max</th></tr>");
                    Iterator itemIter = itemMap.values().iterator();
                    while (itemIter.hasNext()) {
                        StatisticalItem item = (StatisticalItem)itemIter.next();
                        buf.append("<tr><td>").append(item.getValue()).append("</td><td>").append(100.0 * ((double)item.getMergedItemsTotal() / (double)report.getCount())).append("</td><td>").append((double)item.getCount() / (double)report.getCount()).append("</td><td>").append(item.getMinCountPerTx()).append("</td><td>").append(item.getMaxCountPerTx()).append("</td>");
                    }
                    buf.append("</table>");
                }
                buf.append("</td>");
            }
            buf.append("</tr></table>");
        }
        buf.append("</td></tr></table>");
        buf.append("<ul>").append("<li><b>Transaction started by</b> - the method which started the transaction</li>").append("<li><b>total</b> - the total number of transactions in the run</li>").append("<li><b>%</b> - the percentage of transactions this item took place in</li>").append("<li><b>avg</b> - the average number of times the item took place in the given transaction</li>").append("<li><b>min</b> - the minimum number of times the item took place in the given transaction</li>").append("<li><b>max</b> - the maximum number of times the item took place in the given transaction</li>").append("</ul>");
    }
}

