/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.varia.stats.TxReport;
import org.w3c.dom.Element;

public class TxStatisticsInterceptor
extends AbstractInterceptor
implements XmlLoadable {
    private MBeanServer server;
    private ObjectName serviceName;
    private String local;
    private String localHome;
    private String remote;
    private String home;
    static /* synthetic */ Class class$org$jboss$varia$stats$StatisticalItem;

    public void importXml(Element element) throws Exception {
        String service = element.getAttribute("service");
        if (service == null || service.trim().length() == 0) {
            throw new DeploymentException("Required attribute 'service' is not set.");
        }
        this.serviceName = new ObjectName(service);
        this.server = MBeanServerLocator.locateJBoss();
    }

    public void start() {
        BeanMetaData bean = this.container.getBeanMetaData();
        this.local = bean.getLocal();
        this.localHome = bean.getLocalHome();
        this.remote = bean.getRemote();
        this.home = bean.getHome();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        Method method = mi.getMethod();
        if (method != null) {
            String className = mi.getType() == InvocationType.LOCALHOME ? this.localHome : this.home;
            this.logInvocation(className + "." + method.getName());
        }
        return super.invokeHome(mi);
    }

    public Object invoke(Invocation mi) throws Exception {
        Method method = mi.getMethod();
        if (method != null) {
            String className = mi.getType() == InvocationType.LOCAL ? this.local : this.remote;
            this.logInvocation(className + "." + method.getName());
        }
        return super.invoke(mi);
    }

    private void logInvocation(String method) {
        try {
            TxReport.MethodStats item = new TxReport.MethodStats(method);
            this.server.invoke(this.serviceName, "addStatisticalItem", new Object[]{item}, new String[]{(class$org$jboss$varia$stats$StatisticalItem == null ? (class$org$jboss$varia$stats$StatisticalItem = TxStatisticsInterceptor.class$("org.jboss.varia.stats.StatisticalItem")) : class$org$jboss$varia$stats$StatisticalItem).getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

