/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.jboss.hibernate.jmx.HibernateMBean;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;

public class Hibernate
extends ServiceMBeanSupport
implements HibernateMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$hibernate$jmx$Hibernate == null ? (class$org$jboss$hibernate$jmx$Hibernate = Hibernate.class$("org.jboss.hibernate.jmx.Hibernate")) : class$org$jboss$hibernate$jmx$Hibernate));
    public static final String SESSION_FACTORY_CREATE = "hibernate.sessionfactory.create";
    public static final String SESSION_FACTORY_DESTROY = "hibernate.sessionfactory.destroy";
    private String datasourceName;
    private String dialect;
    private String defaultSchema;
    private String defaultCatalog;
    private String maxFetchDepth;
    private String jdbcBatchSize;
    private String batchVersionedDataEnabled;
    private String jdbcFetchSize;
    private String jdbcScrollableResultSetEnabled;
    private String getGeneratedKeysEnabled;
    private String streamsForBinaryEnabled;
    private String reflectionOptimizationEnabled;
    private String hbm2ddlAuto;
    private String querySubstitutions;
    private String showSqlEnabled;
    private String username;
    private String password;
    private String queryCacheEnabled;
    private String cacheProviderClass;
    private ObjectName deployedTreeCacheObjectName;
    private String minimalPutsEnabled;
    private String cacheRegionPrefix;
    private String sessionFactoryInterceptor;
    private URL harUrl;
    private String sessionFactoryName;
    private boolean dirty = false;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$jboss$hibernate$jmx$Hibernate;
    static /* synthetic */ Class class$org$hibernate$transaction$JBossTransactionManagerLookup;
    static /* synthetic */ Class class$org$hibernate$transaction$JTATransactionFactory;

    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
        this.dirty = true;
    }

    public URL getHarUrl() {
        return this.harUrl;
    }

    public void setHarUrl(URL harUrl) {
        this.harUrl = harUrl;
        this.dirty = true;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        this.dirty = true;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        this.dirty = true;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public String getHbm2ddlAuto() {
        return this.hbm2ddlAuto;
    }

    public void setHbm2ddlAuto(String hbm2ddlAuto) {
        this.hbm2ddlAuto = hbm2ddlAuto;
        this.dirty = true;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        this.dirty = true;
    }

    public String getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public void setMaxFetchDepth(String maxFetchDepth) {
        this.maxFetchDepth = maxFetchDepth;
        this.dirty = true;
    }

    public String getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public void setJdbcBatchSize(String jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
        this.dirty = true;
    }

    public String getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(String jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
        this.dirty = true;
    }

    public String getJdbcScrollableResultSetEnabled() {
        return this.jdbcScrollableResultSetEnabled;
    }

    public void setJdbcScrollableResultSetEnabled(String jdbcScrollableResultSetEnabled) {
        this.jdbcScrollableResultSetEnabled = jdbcScrollableResultSetEnabled;
        this.dirty = true;
    }

    public String getGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    public void setGetGeneratedKeysEnabled(String getGeneratedKeysEnabled) {
        this.getGeneratedKeysEnabled = getGeneratedKeysEnabled;
        this.dirty = true;
    }

    public String getQuerySubstitutions() {
        return this.querySubstitutions;
    }

    public void setQuerySubstitutions(String querySubstitutions) {
        this.querySubstitutions = querySubstitutions;
        this.dirty = true;
    }

    public String getQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    public void setQueryCacheEnabled(String queryCacheEnabled) {
        this.queryCacheEnabled = queryCacheEnabled;
        this.dirty = true;
    }

    public String getCacheProviderClass() {
        return this.cacheProviderClass;
    }

    public void setCacheProviderClass(String cacheProviderClass) {
        this.cacheProviderClass = cacheProviderClass;
        this.dirty = true;
    }

    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    public void setCacheRegionPrefix(String cacheRegionPrefix) {
        this.cacheRegionPrefix = cacheRegionPrefix;
        this.dirty = true;
    }

    public String getMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    public void setMinimalPutsEnabled(String minimalPutsEnabled) {
        this.minimalPutsEnabled = minimalPutsEnabled;
        this.dirty = true;
    }

    public String getShowSqlEnabled() {
        return this.showSqlEnabled;
    }

    public void setShowSqlEnabled(String showSqlEnabled) {
        this.showSqlEnabled = showSqlEnabled;
        this.dirty = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.dirty = true;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.dirty = true;
    }

    public String getSessionFactoryInterceptor() {
        return this.sessionFactoryInterceptor;
    }

    public void setSessionFactoryInterceptor(String sessionFactoryInterceptor) {
        this.sessionFactoryInterceptor = sessionFactoryInterceptor;
        this.dirty = true;
    }

    public ObjectName getDeployedTreeCacheObjectName() {
        return this.deployedTreeCacheObjectName;
    }

    public void setDeployedTreeCacheObjectName(ObjectName deployedTreeCacheObjectName) {
        this.deployedTreeCacheObjectName = deployedTreeCacheObjectName;
    }

    public String getBatchVersionedDataEnabled() {
        return this.batchVersionedDataEnabled;
    }

    public void setBatchVersionedDataEnabled(String batchVersionedDataEnabled) {
        this.batchVersionedDataEnabled = batchVersionedDataEnabled;
        this.dirty = true;
    }

    public String getStreamsForBinaryEnabled() {
        return this.streamsForBinaryEnabled;
    }

    public void setStreamsForBinaryEnabled(String streamsForBinaryEnabled) {
        this.streamsForBinaryEnabled = streamsForBinaryEnabled;
        this.dirty = true;
    }

    public String getReflectionOptimizationEnabled() {
        return this.reflectionOptimizationEnabled;
    }

    public void setReflectionOptimizationEnabled(String reflectionOptimizationEnabled) {
        this.reflectionOptimizationEnabled = reflectionOptimizationEnabled;
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSessionFactoryRunning() {
        return this.sessionFactory != null;
    }

    public void rebuildSessionFactory() throws Exception {
        this.destroySessionFactory();
        this.buildSessionFactory();
    }

    public void startService() throws Exception {
        log.debug((Object)("Hibernate MBean starting; " + this));
        this.buildSessionFactory();
    }

    public void stopService() throws Exception {
        this.destroySessionFactory();
    }

    private void buildSessionFactory() throws Exception {
        log.debug((Object)("Building SessionFactory; " + this));
        Configuration cfg = new Configuration();
        cfg.addProperties(this.getProperties());
        File file = new File(this.harUrl.getFile());
        if (file.isDirectory()) {
            cfg.addDirectory(file);
        } else {
            cfg.addJar(file);
        }
        Interceptor interceptorInstance = this.generateInterceptorInstance();
        if (interceptorInstance != null) {
            cfg.setInterceptor(interceptorInstance);
        }
        this.sessionFactory = cfg.buildSessionFactory();
        try {
            this.bind();
        }
        catch (HibernateException e) {
            this.forceCleanup();
            throw e;
        }
        this.dirty = false;
        this.sendNotification(new Notification(SESSION_FACTORY_CREATE, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        log.info((Object)("SessionFactory successfully built and bound into JNDI [" + this.sessionFactoryName + "]"));
    }

    private void destroySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            this.unbind();
            this.sessionFactory.close();
            this.sessionFactory = null;
            this.sendNotification(new Notification(SESSION_FACTORY_DESTROY, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        }
    }

    private Properties getProperties() {
        String objNameString;
        Properties props = new Properties();
        this.setUnlessNull(props, "hibernate.connection.datasource", this.datasourceName);
        this.setUnlessNull(props, "hibernate.dialect", this.dialect);
        if (this.cacheProviderClass == null) {
            this.cacheProviderClass = "org.hibernate.cache.HashtableCacheProvider";
        }
        this.setUnlessNull(props, "hibernate.cache.provider_class", this.cacheProviderClass);
        this.setUnlessNull(props, "hibernate.cache.region_prefix", this.cacheRegionPrefix);
        this.setUnlessNull(props, "hibernate.cache.use_minimal_puts", this.minimalPutsEnabled);
        this.setUnlessNull(props, "hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        this.setUnlessNull(props, "hibernate.default_schema", this.defaultSchema);
        this.setUnlessNull(props, "hibernate.jdbc.batch_size", this.jdbcBatchSize);
        log.info((Object)("Using JDBC batch size : " + this.jdbcBatchSize));
        this.setUnlessNull(props, "hibernate.jdbc.fetch_size", this.jdbcFetchSize);
        this.setUnlessNull(props, "hibernate.jdbc.use_scrollable_resultset", this.jdbcScrollableResultSetEnabled);
        this.setUnlessNull(props, "hibernate.cache.use_query_cache", this.queryCacheEnabled);
        this.setUnlessNull(props, "hibernate.query.substitutions", this.querySubstitutions);
        this.setUnlessNull(props, "hibernate.max_fetch_depth", this.maxFetchDepth);
        this.setUnlessNull(props, "hibernate.show_sql", this.showSqlEnabled);
        this.setUnlessNull(props, "hibernate.jdbc.use_get_generated_keys", this.getGeneratedKeysEnabled);
        this.setUnlessNull(props, "hibernate.connection.username", this.username);
        this.setUnlessNull(props, "hibernate.connection.password", this.password);
        this.setUnlessNull(props, "hibernate.jdbc.batch_versioned_data", this.batchVersionedDataEnabled);
        this.setUnlessNull(props, "hibernate.jdbc.use_streams_for_binary", this.streamsForBinaryEnabled);
        this.setUnlessNull(props, "hibernate.cglib.use_reflection_optimizer", this.reflectionOptimizationEnabled);
        this.setUnlessNull(props, "hibernate.transaction.manager_lookup_class", (class$org$hibernate$transaction$JBossTransactionManagerLookup == null ? (class$org$hibernate$transaction$JBossTransactionManagerLookup = Hibernate.class$("org.hibernate.transaction.JBossTransactionManagerLookup")) : class$org$hibernate$transaction$JBossTransactionManagerLookup).getName());
        this.setUnlessNull(props, "hibernate.transaction.factory_class", (class$org$hibernate$transaction$JTATransactionFactory == null ? (class$org$hibernate$transaction$JTATransactionFactory = Hibernate.class$("org.hibernate.transaction.JTATransactionFactory")) : class$org$hibernate$transaction$JTATransactionFactory).getName());
        if (this.deployedTreeCacheObjectName != null && (objNameString = this.deployedTreeCacheObjectName.toString()) != null && !"".equals(objNameString)) {
            props.setProperty("hibernate.treecache.objectName", objNameString);
        }
        props.setProperty("hibernate.transaction.flush_before_completion", "true");
        props.setProperty("hibernate.transaction.auto_close_session", "true");
        props.setProperty("hibernate.connection.agressive_release", "true");
        return props;
    }

    private void setUnlessNull(Properties props, String key, String value) {
        if (value != null) {
            props.setProperty(key, value);
        }
    }

    private Interceptor generateInterceptorInstance() {
        if (this.sessionFactoryInterceptor == null) {
            return null;
        }
        log.info((Object)("Generating session factory interceptor instance [" + this.sessionFactoryInterceptor + "]"));
        try {
            return (Interceptor)Thread.currentThread().getContextClassLoader().loadClass(this.sessionFactoryInterceptor).newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to generate session factory interceptor instance", t);
            return null;
        }
    }

    private void bind() throws HibernateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Util.bind((Context)ctx, (String)this.sessionFactoryName, (Object)this.sessionFactory);
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to bind SessionFactory into JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private void unbind() throws HibernateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)this.sessionFactoryName);
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to unbind SessionFactory from JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private void forceCleanup() {
        try {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + " [ServiceName=" + this.serviceName + ", JNDI=" + this.sessionFactoryName + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

