/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSContentHandler;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.impl.XSLogicalParser;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.apache.ws.jaxme.xs.parser.impl.XSContextImpl;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSParser {
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    private static final ThreadLocal parser = new ThreadLocal();
    private XSContext data;
    private boolean notValidating;
    private List addedImports = new ArrayList();

    public void setValidating(boolean pValidating) {
        this.notValidating = !pValidating;
    }

    public boolean isValidating() {
        return !this.notValidating;
    }

    public void addImport(String pNamespace, String pSchemaLocation) {
        this.addedImports.add(new XSLogicalParser.AddedImport(pNamespace, pSchemaLocation));
    }

    public void addImport(String pNamespace, Node pSchema) {
        this.addedImports.add(new XSLogicalParser.AddedImport(pNamespace, pSchema));
    }

    public XSContext getContext() {
        if (this.data == null) {
            this.setData(new XSContextImpl());
        }
        return this.data;
    }

    protected void setData(XSContext pData) {
        this.data = pData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XsESchema parseSyntax(InputSource pSource) throws ParserConfigurationException, SAXException, IOException {
        XSContext context = this.getContext();
        parser.set(this);
        try {
            XsObjectFactory factory = context.getXsObjectFactory();
            XsSAXParser xsSAXParser = factory.newXsSAXParser();
            context.setCurrentContentHandler(xsSAXParser);
            XMLReader xr = factory.newXMLReader(this.isValidating());
            xr.setContentHandler(xsSAXParser);
            xr.parse(pSource);
            XsESchema xsESchema = (XsESchema)xsSAXParser.getBean();
            Object var8_7 = null;
            context.setCurrentContentHandler(null);
            parser.set(null);
            return xsESchema;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.setCurrentContentHandler(null);
            parser.set(null);
            throw throwable;
        }
    }

    protected XSLogicalParser newXSLogicalParser() {
        XSLogicalParser logicalParser = this.getContext().getXSObjectFactory().newXSLogicalParser();
        logicalParser.setValidating(this.isValidating());
        for (int i = 0; i < this.addedImports.size(); ++i) {
            XSLogicalParser.AddedImport addedImport = (XSLogicalParser.AddedImport)this.addedImports.get(i);
            if (addedImport.getNode() == null) {
                logicalParser.addImport(addedImport.getNamespace(), addedImport.getSchemaLocation());
                continue;
            }
            logicalParser.addImport(addedImport.getNamespace(), addedImport.getNode());
        }
        return logicalParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSSchema parse(InputSource pSource) throws ParserConfigurationException, SAXException, IOException {
        XSContext myData = this.getContext();
        parser.set(this);
        try {
            XSSchema xSSchema = this.newXSLogicalParser().parse(pSource);
            Object var5_4 = null;
            myData.setCurrentContentHandler(null);
            parser.set(null);
            return xSSchema;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            myData.setCurrentContentHandler(null);
            parser.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSSchema parse(Node pNode) throws SAXException {
        XSContext myData = this.getContext();
        parser.set(this);
        try {
            XSSchema xSSchema = this.newXSLogicalParser().parse(pNode);
            Object var5_4 = null;
            myData.setCurrentContentHandler(null);
            parser.set(null);
            return xSSchema;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            myData.setCurrentContentHandler(null);
            parser.set(null);
            throw throwable;
        }
    }

    public XSContentHandler getXSContentHandler() throws SAXException {
        parser.set(this);
        return this.newXSLogicalParser().getXSContentHandler();
    }

    public static XSParser getRunningInstance() {
        return (XSParser)parser.get();
    }
}

