/*
 * Decompiled with CFR 0.152.
 */
package components.renderkit;

import components.components.GraphComponent;
import components.model.Graph;
import components.model.Node;
import components.renderkit.MenuBarRenderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MenuTreeRenderer
extends MenuBarRenderer {
    public static final String IMAGE_HANDLE_DOWN_LAST = "handledownlast.gif";
    public static final String IMAGE_HANDLE_DOWN_MIDDLE = "handledownmiddle.gif";
    public static final String IMAGE_HANDLE_RIGHT_LAST = "handlerightlast.gif";
    public static final String IMAGE_HANDLE_RIGHT_MIDDLE = "handlerightmiddle.gif";
    public static final String IMAGE_LINE_LAST = "linelastnode.gif";
    public static final String IMAGE_LINE_MIDDLE = "linemiddlenode.gif";
    public static final String IMAGE_LINE_VERTICAL = "linevertical.gif";
    String imageLocation = null;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Graph graph = null;
        graph = (Graph)((GraphComponent)component).getValue();
        if (graph == null) {
            throw new FacesException("Graph could not be located");
        }
        Node root = graph.getRoot();
        if (root == null) {
            throw new FacesException("Graph has no root node");
        }
        if (root.getChildCount() < 1) {
            return;
        }
        this.component = component;
        this.context = context;
        this.clientId = component.getClientId(context);
        this.imageLocation = this.getImagesLocation(context);
        this.treeClass = (String)component.getAttributes().get("graphClass");
        this.selectedClass = (String)component.getAttributes().get("selectedClass");
        this.unselectedClass = (String)component.getAttributes().get("unselectedClass");
        ResponseWriter writer = context.getResponseWriter();
        writer.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
        if (this.treeClass != null) {
            writer.write(" class=\"");
            writer.write(this.treeClass);
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        int level = 0;
        this.encodeNode(writer, root, level, root.getDepth(), true);
        writer.write("<input type=\"hidden\" name=\"" + this.clientId + "\" />");
        writer.write("</table>");
        writer.write("\n");
    }

    protected void encodeNode(ResponseWriter writer, Node node, int level, int width, boolean last) throws IOException {
        writer.write("  <tr valign=\"middle\">");
        int i = 0;
        while (i < level) {
            int levels = level - i;
            Node parent = node;
            int j = 1;
            while (j <= levels) {
                parent = parent.getParent();
                ++j;
            }
            if (parent.isLast()) {
                writer.write("    <td></td>");
            } else {
                writer.write("    <td><img src=\"");
                writer.write(this.imageLocation);
                writer.write("/");
                writer.write(IMAGE_LINE_VERTICAL);
                writer.write("\" border=\"0\"></td>");
            }
            writer.write("\n");
            ++i;
        }
        writer.write("    <td>");
        if (!node.isLeaf()) {
            writer.write("<a href=\"");
            writer.write(this.getSubmitScript(node.getPath(), this.context));
            writer.write(" >");
            writer.write("<img src=\"");
            writer.write(this.imageLocation);
            writer.write("/");
            if (node.isLast()) {
                writer.write(IMAGE_HANDLE_RIGHT_LAST);
            } else {
                writer.write(IMAGE_HANDLE_RIGHT_MIDDLE);
            }
            writer.write("\" border=\"0\">");
            writer.write("</a>");
            writer.write("</td>");
        } else {
            writer.write("<img src=\"");
            writer.write(this.imageLocation);
            writer.write("/");
            if (node.isLeaf()) {
                if (node.isLast()) {
                    writer.write(IMAGE_LINE_LAST);
                } else {
                    writer.write(IMAGE_LINE_MIDDLE);
                }
            } else if (node.isExpanded()) {
                if (node.isLast()) {
                    writer.write(IMAGE_HANDLE_DOWN_LAST);
                } else {
                    writer.write(IMAGE_HANDLE_DOWN_MIDDLE);
                }
            }
            writer.write("\" border=\"0\">");
            writer.write("</td>");
        }
        writer.write("    <td colspan=\"");
        writer.write(String.valueOf(width - level + 1));
        writer.write("\">");
        if (node.getIcon() != null) {
            if (node.getAction() != null) {
                writer.write("<a href=\"");
                writer.write(this.href(node.getAction()));
                writer.write("\">");
            }
            writer.write("<img src=\"");
            writer.write(this.imageLocation);
            writer.write("/");
            writer.write(node.getIcon());
            writer.write("\" border=\"0\">");
            if (node.getAction() != null) {
                writer.write("</a>");
            }
        }
        if (node.getLabel() != null) {
            writer.write("   ");
            String labelStyle = null;
            if (node.isSelected() && this.selectedClass != null) {
                labelStyle = this.selectedClass;
            } else if (!node.isSelected() && this.unselectedClass != null) {
                labelStyle = this.unselectedClass;
            }
            if (node.isEnabled()) {
                writer.write("<a href=\"");
                writer.write(this.href(node.getAction()));
                writer.write("\"");
                if (labelStyle != null) {
                    writer.write(" class=\"");
                    writer.write(labelStyle);
                    writer.write("\"");
                }
                writer.write(">");
            } else if (labelStyle != null) {
                writer.write("<span class=\"");
                writer.write(labelStyle);
                writer.write("\">");
            }
            writer.write(node.getLabel());
            if (node.getLabel() != null) {
                writer.write("</a>");
            } else if (labelStyle != null) {
                writer.write("</span>");
            }
        }
        writer.write("</td>");
        writer.write("\n");
        writer.write("  </tr>");
        writer.write("\n");
        if (node.isExpanded()) {
            Iterator children = node.getChildren();
            int lastIndex = node.getChildCount() - 1;
            int newLevel = level + 1;
            while (children.hasNext()) {
                Node nextChild = (Node)children.next();
                boolean lastNode = nextChild.isLast();
                this.encodeNode(writer, nextChild, newLevel, width, lastNode);
            }
        }
    }

    protected String getImagesLocation(FacesContext context) {
        StringBuffer sb = new StringBuffer();
        String contextPath = context.getExternalContext().getRequestContextPath();
        sb.append(contextPath);
        Map initParameterMap = context.getExternalContext().getInitParameterMap();
        String images = (String)initParameterMap.get("tree.control.images");
        if (images == null) {
            images = "/images";
        }
        sb.append(images);
        return sb.toString();
    }
}

