/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import org.jboss.axis.message.MimeHeadersImpl;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static Logger log = Logger.getLogger((String)SOAPPartImpl.class.getName());
    private SOAPMessage soapMessage;
    private MimeHeaders mimeHeaders;
    private SOAPEnvelope soapEnvelope;
    private Document document;
    private Source contentSource;

    public SOAPPartImpl() {
    }

    public SOAPPartImpl(SOAPMessage soapMessage, InputStream inStream, MimeHeaders headers) {
        this.soapMessage = soapMessage;
        this.mimeHeaders = new MimeHeadersImpl(headers);
        if (headers == null) {
            this.mimeHeaders = new MimeHeadersImpl();
            this.mimeHeaders.addHeader("Content-Type", "text/xml");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(inStream);
            this.document.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.setMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        this.setMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.contentSource = source;
    }

    public Source getContent() throws SOAPException {
        return this.contentSource;
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        return this.soapEnvelope;
    }

    private String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    public String getXmlVersion() {
        return null;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public String getDocumentURI() {
        return null;
    }

    public void setDocumentURI(String documentURI) {
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }
}

