/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListDeserializer
extends DeserializerImpl {
    private static Logger log = Logger.getLogger((String)ListDeserializer.class.getName());
    private List valueList = new ArrayList();
    private Class javaType;
    private QName xmlType;

    public ListDeserializer(Class javaType, QName xmlType) {
        this.javaType = javaType;
        this.xmlType = xmlType;
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ListDeserializer::startElement()");
        }
        if (context.isNil(attributes)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ListDeserializer::startElement()");
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ListDeserializer::endElement()");
        }
        Class<?> componentType = this.javaType.getComponentType();
        Constructor<?> ctor = null;
        try {
            ctor = componentType.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot obtain string constructor for: " + componentType);
        }
        Object[] objArr = (Object[])Array.newInstance(componentType, this.valueList.size());
        String strValue = null;
        try {
            for (int i = 0; i < this.valueList.size(); ++i) {
                strValue = (String)this.valueList.get(i);
                Object obj = ctor.newInstance(strValue);
                objArr[i] = obj;
            }
            this.value = objArr;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot construct object with: " + strValue);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ListDeserializer::endElement()");
        }
    }

    public void characters(char[] p1, int p2, int p3) throws SAXException {
        super.characters(p1, p2, p3);
        String strContent = new String(p1, p2, p3);
        StringTokenizer st = new StringTokenizer(strContent);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            Object item = this.getValueAsObject(nextToken);
            this.valueList.add(item);
        }
    }

    private Object getValueAsObject(String token) {
        return token;
    }
}

