/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.emb.ContentAccessException;
import javax.emb.ContentUnmutableException;
import javax.emb.ConversionException;
import javax.emb.FormatNotFoundException;
import javax.emb.GenericMediaFormat;
import javax.emb.Media;
import javax.emb.MediaBean;
import javax.emb.MediaConverter;
import javax.emb.MediaConverterSpec;
import javax.emb.MediaEntityLocal;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaFormatRegistry;
import javax.emb.MediaHeader;
import javax.emb.MediaListener;
import javax.emb.MetaDataEntityLocal;
import javax.emb.ProtocolConstraints;
import org.jboss.logging.Logger;

public abstract class MediaEntity {
    private Logger log = Logger.getLogger((Class)(class$org$jboss$media$entity$MediaEntity == null ? (class$org$jboss$media$entity$MediaEntity = MediaEntity.class$("org.jboss.media.entity.MediaEntity")) : class$org$jboss$media$entity$MediaEntity));
    static /* synthetic */ Class class$org$jboss$media$entity$MediaEntity;

    public abstract String getManagedIdentity();

    public abstract void setManagedIdentity(String var1);

    public abstract byte[] getManagedContent();

    public abstract void setManagedContent(byte[] var1);

    public abstract String getManagedLocation();

    public abstract void setManagedLocation(String var1);

    public abstract String getManagedDescription();

    public abstract void setManagedDescription(String var1);

    public abstract String getManagedName();

    public abstract void setManagedName(String var1);

    public abstract String getManagedMimeType();

    public abstract void setManagedMimeType(String var1);

    public abstract long getManagedLastModified();

    public abstract void setManagedLastModified(long var1);

    public abstract Vector getManagedListeners();

    public abstract void setManagedListeners(Vector var1);

    public abstract MediaEntityLocal getManagedProxy();

    public abstract void setManagedProxy(MediaEntityLocal var1);

    public abstract MediaEntityLocal getManagedPreviousVersion();

    public abstract void setManagedPreviousVersion(MediaEntityLocal var1);

    public abstract MediaEntityLocal getManagedNextVersion();

    public abstract void setManagedNextVersion(MediaEntityLocal var1);

    public abstract Collection getManagedParents();

    public abstract void setManagedParents(Collection var1);

    public abstract Collection getManagedChildren();

    public abstract void setManagedChildren(Collection var1);

    public abstract Collection getManagedMetaDatas();

    public abstract void setManagedMetaDatas(Collection var1);

    public void addListener(MediaListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Vector listeners = this.getManagedListeners();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            this.setManagedListeners(listeners);
        }
    }

    public void addMetaData(MetaDataEntityLocal metaData) throws MediaException {
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (!this.getManagedMetaDatas().contains(metaData)) {
            this.getManagedMetaDatas().add(metaData);
        }
    }

    public void convert(MediaConverterSpec[] specifications) throws MediaException {
        if (specifications == null) {
            throw new NullPointerException();
        }
        if (this.getManagedLocation() != null) {
            throw new ContentUnmutableException();
        }
        int specificationsLength = specifications.length;
        if (specificationsLength == 0) {
            return;
        }
        for (int i = 0; i < specificationsLength; ++i) {
            if (specifications[i] != null) continue;
            throw new ConversionException();
        }
        InputStream inputStream = new ByteArrayInputStream(this.getContent());
        for (int i = 0; i < specificationsLength - 1; ++i) {
            MediaConverterSpec mediaConverterSpec = specifications[i];
            MediaConverter mediaConverter = mediaConverterSpec.getConverter();
            inputStream = mediaConverter.process(inputStream);
        }
        MediaConverterSpec lastSpecification = specifications[specificationsLength - 1];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        lastSpecification.getConverter().process(inputStream, (OutputStream)outputStream);
        byte[] convertedContent = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String convertedName = this.getFileName(this.getManagedName()) + "." + lastSpecification.getTargetFileExtension();
        String convertedMimeType = lastSpecification.getTargetMimeType();
        this.setContent(convertedContent);
        this.setName(convertedName);
        this.setMimeType(convertedMimeType);
        this.updateLastModified();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL exportMedia(URL targetDirectoryLocation) throws MediaException {
        String name = this.getManagedName();
        String exportedFilePrefix = this.getFileName(name);
        String exportedFileSuffix = this.getFileExtension(name);
        try {
            File targetDirectory = new File(targetDirectoryLocation.getPath());
            File exportedFile = File.createTempFile(exportedFilePrefix, exportedFileSuffix, targetDirectory);
            FileOutputStream exportedFileStream = new FileOutputStream(exportedFile);
            try {
                int bytesRead;
                int DEFAULT_BUFFER_SIZE = 65536;
                byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
                long position = 0L;
                while ((bytesRead = this.readContent(position, buffer)) != -1) {
                    ((OutputStream)exportedFileStream).write(buffer, 0, bytesRead);
                    position += (long)bytesRead;
                }
                URL uRL = exportedFile.toURL();
                return uRL;
            }
            catch (IOException e) {
                throw new ContentAccessException(e.getMessage());
            }
            finally {
                try {
                    ((OutputStream)exportedFileStream).close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
    }

    public MediaEntityLocal[] getChildren() throws MediaException {
        Collection children = this.getManagedChildren();
        return children.toArray(new MediaEntityLocal[0]);
    }

    public byte[] getContent() throws MediaException {
        byte[] content = this.getManagedContent();
        if (content == null) {
            throw new ContentAccessException();
        }
        return content;
    }

    public String getDescription() throws MediaException {
        return this.getManagedDescription();
    }

    public MediaFormat getFormat() throws MediaException {
        String name = this.getName();
        if (name == null) {
            throw new FormatNotFoundException();
        }
        String fileExtension = this.getFileExtension(name);
        MediaFormat mediaFormat = MediaFormatRegistry.SINGLETON.lookup(fileExtension);
        return mediaFormat;
    }

    public MediaHeader getHeader() throws MediaException {
        ByteArrayInputStream content = new ByteArrayInputStream(this.getContent());
        return this.getFormat().extractHeader((InputStream)content);
    }

    public long getLastModified() throws MediaException {
        return this.getManagedLastModified();
    }

    public MediaListener[] getListeners() throws MediaException {
        Vector listeners = this.getManagedListeners();
        return listeners.toArray(new MediaListener[0]);
    }

    public URL getLocation() throws MediaException {
        String location = this.getManagedLocation();
        try {
            return new URL(location);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public MetaDataEntityLocal[] getMetaData() throws MediaException {
        return this.getManagedMetaDatas().toArray(new MetaDataEntityLocal[0]);
    }

    public String getMimeType() throws MediaException {
        String mimeType = this.getManagedMimeType();
        if (mimeType == null) {
            mimeType = this.getFormat().getDefaultMimeType();
        }
        return mimeType;
    }

    public String getName() throws MediaException {
        return this.getManagedName();
    }

    public MediaEntityLocal getNextVersion() throws MediaException {
        return this.getManagedNextVersion();
    }

    public MediaEntityLocal[] getParents() throws MediaException {
        Collection parents = this.getManagedParents();
        return parents.toArray(new MediaEntityLocal[0]);
    }

    public MediaEntityLocal getPreviousVersion() throws MediaException {
        return this.getManagedPreviousVersion();
    }

    public Media getProxy() throws MediaException {
        MediaEntityLocal proxy = this.getManagedProxy();
        Media proxyMedia = null;
        try {
            if (proxy != null) {
                ByteArrayInputStream content = new ByteArrayInputStream(proxy.getContent());
                proxyMedia = new MediaBean((InputStream)content, proxy.getMimeType(), proxy.getName());
            } else {
                ByteArrayInputStream content = new ByteArrayInputStream(this.getContent());
                proxyMedia = this.getFormat().extractProxy((InputStream)content);
            }
            if (proxyMedia != null) {
                return proxyMedia;
            }
            return new GenericMediaFormat().extractProxy(null);
        }
        catch (MediaException e) {
            return new GenericMediaFormat().extractProxy(null);
        }
    }

    public long getSize() throws MediaException {
        if (this.getContent() == null) {
            throw new ContentAccessException();
        }
        return this.getContent().length;
    }

    public void importMedia(URL sourceLocation, String name) throws MediaException {
        if (sourceLocation == null) {
            throw new NullPointerException();
        }
        this.setName(name);
        FileInputStream sourceStream = null;
        try {
            sourceStream = new FileInputStream(sourceLocation.getPath());
            this.setContent(sourceStream);
        }
        catch (IOException e) {
            throw new ContentAccessException();
        }
        finally {
            if (sourceStream != null) {
                try {
                    ((InputStream)sourceStream).close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public int readContent(long position, byte[] buffer) throws MediaException {
        return this.readContent(position, buffer, 0, buffer.length);
    }

    public int readContent(long position, byte[] buffer, int offset, int length) throws MediaException {
        byte[] content = this.getManagedContent();
        if (content == null) {
            throw new ContentAccessException();
        }
        System.arraycopy(content, (int)position, buffer, offset, length);
        return content.length;
    }

    public void removeListener(MediaListener listener) throws MediaException {
        if (listener == null) {
            throw new NullPointerException();
        }
        Vector listeners = this.getManagedListeners();
        if (listeners.contains(listener)) {
            listeners.remove(listener);
            this.setManagedListeners(listeners);
        }
    }

    public void removeMetaData(MetaDataEntityLocal metaData) throws MediaException {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.getManagedMetaDatas().remove(metaData);
    }

    public void setChildren(MediaEntityLocal[] children) throws MediaException {
        if (children == null) {
            throw new NullPointerException();
        }
        if (this.getLocation() != null) {
            throw new ContentUnmutableException();
        }
        if (this.getContent() == null) {
            throw new ContentAccessException();
        }
        for (int i = 0; i < children.length; ++i) {
            this.getManagedChildren().add(children[i]);
        }
    }

    public void setContent(byte[] content) throws MediaException {
        if (this.getLocation() != null) {
            throw new ContentUnmutableException();
        }
        this.setManagedContent(content);
        this.updateLastModified();
    }

    public void setContent(InputStream content) throws MediaException {
        if (content == null) {
            throw new NullPointerException();
        }
        if (this.getLocation() != null) {
            throw new ContentUnmutableException();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int bytesRead;
            int DEFAULT_BUFFER_SIZE = 65536;
            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
            while ((bytesRead = content.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] newContent = new byte[out.size()];
            newContent = out.toByteArray();
            this.setManagedContent(newContent);
            this.updateLastModified();
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ignore) {}
        }
    }

    public void setDescription(String description) throws MediaException {
        this.setManagedDescription(description);
        this.updateLastModified();
    }

    public void setLocation(URL location) throws MediaException {
        if (this.getContent() != null) {
            throw new ContentUnmutableException();
        }
        this.setManagedLocation(location.toExternalForm());
        this.updateLastModified();
    }

    public void setMimeType(String mimeType) throws MediaException {
        this.setManagedMimeType(mimeType);
        this.updateLastModified();
    }

    public void setName(String name) throws MediaException {
        this.setManagedName(name);
        this.updateLastModified();
    }

    public void setPreviousVersion(MediaEntityLocal mediaEntity) throws MediaException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public void setProxy(MediaEntityLocal mediaEntity) throws MediaException {
        this.setManagedProxy(mediaEntity);
    }

    public URL[] ejbHomeExportMedia(MediaEntityLocal[] sourceMedia, URL targetDirectoryLocation) throws MediaException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public MediaEntityLocal[] ejbHomeImportMedia(URL[] sourceLocations, String[] names) throws CreateException, MediaException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public URL ejbHomePublishContent(Media mediaObject, byte protocol, ProtocolConstraints constraints) throws MediaException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public Media ejbHomePublishMedia(MediaEntityLocal[] playlist, byte transferType, ProtocolConstraints constraints) throws MediaException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected void updateLastModified() {
        this.setManagedLastModified(System.currentTimeMillis());
    }

    private String getFileName(String name) {
        int lastDotPosition = name.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return name;
        }
        return name.substring(0, lastDotPosition);
    }

    private String getFileExtension(String name) {
        int lastDotPosition = name.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return name.substring(lastDotPosition + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

