/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.ErrorCodeConverter;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;

public class HSQLDialect
extends Dialect {
    public HSQLDialect() {
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric");
        this.registerColumnType(2004, "longvarbinary");
        this.registerColumnType(2005, "longvarchar");
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction("char", Hibernate.CHARACTER));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lcase", new StandardSQLFunction("lcase"));
        this.registerFunction("ucase", new StandardSQLFunction("ucase"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("reverse", new StandardSQLFunction("reverse"));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("rawtohex", new StandardSQLFunction("rawtohex"));
        this.registerFunction("hextoraw", new StandardSQLFunction("hextoraw"));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING));
        this.registerFunction("database", new NoArgSQLFunction("database", Hibernate.STRING));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("curdate", new NoArgSQLFunction("curdate", Hibernate.DATE));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("now", new NoArgSQLFunction("now", Hibernate.TIMESTAMP));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", Hibernate.TIME, false));
        this.registerFunction("curtime", new NoArgSQLFunction("curtime", Hibernate.TIME));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("quater", new StandardSQLFunction("quater", Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction("hour", Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction("minute", Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction("second", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("rand", new StandardSQLFunction("rand", Hibernate.FLOAT));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("roundmagic", new StandardSQLFunction("roundmagic"));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "generated by default as identity (start with 1)";
    }

    public String getIdentitySelectString() {
        return "call identity()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 10).append(sql).insert(sql.toLowerCase().indexOf("select") + 6, hasOffset ? " limit ? ?" : " top ?").toString();
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public String[] getCreateSequenceStrings(String sequenceName) {
        return new String[]{"create table dual_" + sequenceName + " (zero integer)", "insert into dual_" + sequenceName + " values (0)", "create sequence " + sequenceName + " start with 1"};
    }

    public String[] getDropSequenceStrings(String sequenceName) {
        return new String[]{"drop table dual_" + sequenceName + " if exists", "drop sequence " + sequenceName};
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select next value for " + sequenceName + " from dual_" + sequenceName;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select sequence_name from system_sequences";
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new ExceptionConverter(this.getViolatedConstraintNameExtracter());
    }

    private static class ExceptionConverter
    extends ErrorCodeConverter {
        private int[] sqlGrammarCodes = new int[]{-22, -28};
        private int[] integrityViolationCodes = new int[]{-9, -177, -104};

        public ExceptionConverter(ViolatedConstraintNameExtracter extracter) {
            super(extracter);
        }

        protected int[] getSQLGrammarErrorCodes() {
            return this.sqlGrammarCodes;
        }

        protected int[] getIntegrityViolationErrorCodes() {
            return this.integrityViolationCodes;
        }
    }
}

