/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.mail.inflow;

import java.lang.reflect.Method;
import javax.mail.Message;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.mail.MailResourceAdapter;
import org.jboss.resource.adapter.mail.inflow.MailActivationSpec;
import org.jboss.resource.adapter.mail.inflow.MailFolder;
import org.jboss.resource.adapter.mail.inflow.MailListener;

public class MailActivation
implements Comparable,
Work {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$mail$inflow$MailActivation == null ? (class$org$jboss$resource$adapter$mail$inflow$MailActivation = MailActivation.class$("org.jboss.resource.adapter.mail.inflow.MailActivation")) : class$org$jboss$resource$adapter$mail$inflow$MailActivation));
    public static final Method ON_MESSAGE;
    private boolean released;
    private boolean trace;
    private long nextNewMsgCheckTime;
    protected MailResourceAdapter ra;
    protected MailActivationSpec spec;
    protected MessageEndpointFactory endpointFactory;
    static /* synthetic */ Class class$org$jboss$resource$adapter$mail$inflow$MailActivation;
    static /* synthetic */ Class class$javax$mail$Message;
    static /* synthetic */ Class class$org$jboss$resource$adapter$mail$inflow$MailListener;

    public MailActivation(MailResourceAdapter ra, MessageEndpointFactory endpointFactory, MailActivationSpec spec) {
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        this.trace = log.isTraceEnabled();
    }

    public long getNextNewMsgCheckTime() {
        return this.nextNewMsgCheckTime;
    }

    public void updateNextNewMsgCheckTime(long now) {
        this.nextNewMsgCheckTime = now + this.spec.getPollingInterval();
    }

    public int compareTo(Object obj) {
        MailActivation ma = (MailActivation)obj;
        long compareTo = this.nextNewMsgCheckTime - ma.getNextNewMsgCheckTime();
        return (int)compareTo;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void release() {
        this.released = true;
        if (this.trace) {
            log.trace((Object)"released");
        }
    }

    public void run() {
        this.released = false;
        if (this.trace) {
            log.trace((Object)"Begin new msgs check");
        }
        try {
            MailFolder mailFolder = new MailFolder(this.spec);
            mailFolder.open();
            Message[] msgs = mailFolder.getNewMessages();
            for (int n = 0; !this.released && n < msgs.length; ++n) {
                Message msg = msgs[n];
                this.deliverMsg(msg);
            }
            mailFolder.close();
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute folder check, spec=" + this.spec));
        }
        if (this.trace) {
            log.trace((Object)"End new msgs check");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMsg(Message msg) {
        MessageEndpoint endpoint = null;
        try {
            endpoint = this.endpointFactory.createEndpoint(null);
            if (endpoint != null) {
                if (this.trace) {
                    log.trace((Object)("deliverMsg, msg subject=" + msg.getSubject()));
                }
                MailListener listener = (MailListener)endpoint;
                listener.onMessage(msg);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"onMessage delivery failure", e);
        }
        finally {
            if (endpoint != null) {
                endpoint.release();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] sig = new Class[]{class$javax$mail$Message == null ? (class$javax$mail$Message = MailActivation.class$("javax.mail.Message")) : class$javax$mail$Message};
            ON_MESSAGE = (class$org$jboss$resource$adapter$mail$inflow$MailListener == null ? (class$org$jboss$resource$adapter$mail$inflow$MailListener = MailActivation.class$("org.jboss.resource.adapter.mail.inflow.MailListener")) : class$org$jboss$resource$adapter$mail$inflow$MailListener).getMethod("onMessage", sig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

