/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.lang.reflect.Method;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable {
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private transient Method method = null;
    private String type = null;
    private MBeanParameterInfo[] signature = null;
    private int impact = 3;

    MBeanOperationInfo(MBeanOperationInfo mBeanOperationInfo) {
        super(mBeanOperationInfo.name, mBeanOperationInfo.description);
        this.signature = mBeanOperationInfo.signature;
        this.type = mBeanOperationInfo.type;
        this.impact = mBeanOperationInfo.impact;
    }

    public MBeanOperationInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, String string3, int n) {
        super(string, string2);
        this.signature = mBeanParameterInfoArray;
        this.type = string3;
        this.impact = n;
    }

    public MBeanOperationInfo(String string, Method method) {
        super(method.getName(), string);
        this.method = method;
        this.findMethodReturnType();
        this.findMethodParameterTypes();
    }

    private void findMethodParameterTypes() {
        String[] stringArray = MetaData.findSignatures(this.method.getParameterTypes());
        if (stringArray != null) {
            int n = stringArray.length;
            this.signature = new MBeanParameterInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.signature[n2] = new MBeanParameterInfo(stringArray[n2], stringArray[n2], "");
                ++n2;
            }
        }
    }

    private void findMethodReturnType() {
        this.type = this.method.getReturnType().getName();
    }

    public int getImpact() {
        return this.impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature != null) {
            int n = this.signature.length;
            MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[n];
            int n2 = 0;
            while (n2 < n) {
                mBeanParameterInfoArray[n2] = new MBeanParameterInfo(this.signature[n2]);
                ++n2;
            }
            return mBeanParameterInfoArray;
        }
        return new MBeanParameterInfo[0];
    }
}

