/*
 * Decompiled with CFR 0.152.
 */
package javax.emb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.emb.ContentAccessException;
import javax.emb.ContentTooLargeException;
import javax.emb.FormatNotFoundException;
import javax.emb.Media;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaFormatRegistry;
import javax.emb.MediaHeader;

public class MediaBean
implements Media {
    private String name;
    private String mimeType;
    private transient File tempFile;

    public MediaBean(InputStream contentStream, String mimeType, String name) throws MediaException {
        if (contentStream == null || name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        if (mimeType != null) {
            this.mimeType = mimeType;
        } else {
            try {
                MediaFormatRegistry.SINGLETON.lookup(MediaBean.getFileExtension(name));
            }
            catch (FormatNotFoundException e) {
                this.mimeType = "www/unknown";
            }
        }
        String tempFilePrefix = MediaBean.getFileName(name);
        String tempFileSuffix = MediaBean.getFileExtension(name);
        try {
            this.tempFile = File.createTempFile(tempFilePrefix, tempFileSuffix);
            this.tempFile.deleteOnExit();
            FileOutputStream tempFileStream = new FileOutputStream(this.tempFile);
            try {
                int bytesRead;
                int DEFAULT_BUFFER_SIZE = 65536;
                byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
                while ((bytesRead = contentStream.read(buffer)) != -1) {
                    ((OutputStream)tempFileStream).write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                throw new ContentAccessException(e.getMessage());
            }
            finally {
                try {
                    ((OutputStream)tempFileStream).close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
        finally {
            try {
                contentStream.close();
            }
            catch (IOException ignore) {}
        }
    }

    public MediaBean(File mediaFile, String mimeType) throws MediaException {
        if (mediaFile == null) {
            throw new NullPointerException();
        }
        if (!mediaFile.exists()) {
            throw new ContentAccessException("The given file is not present or cannot be accessed.");
        }
        this.tempFile = mediaFile;
        this.name = mediaFile.getName();
        if (mimeType != null) {
            this.mimeType = mimeType;
        } else {
            try {
                MediaFormatRegistry.SINGLETON.lookup(MediaBean.getFileExtension(this.name));
            }
            catch (FormatNotFoundException e) {
                this.mimeType = "www/unknown";
            }
        }
    }

    public byte[] getContent() throws MediaException {
        long size = this.getSize();
        if (size > Integer.MAX_VALUE) {
            throw new ContentTooLargeException("Content exceeds maximum Java array size.");
        }
        return this.getContent(0L, (int)size);
    }

    public MediaFormat getFormat() throws MediaException {
        String fileExtension = MediaBean.getFileExtension(this.name);
        return MediaFormatRegistry.SINGLETON.lookup(fileExtension);
    }

    public MediaHeader getHeader() throws MediaException {
        return this.getFormat().extractHeader(this.getContentStream());
    }

    public String getMimeType() throws MediaException {
        return this.mimeType;
    }

    public String getName() throws MediaException {
        return this.name;
    }

    public Media getProxy() throws MediaException {
        return this.getFormat().extractProxy(this.getContentStream());
    }

    public long getSize() throws MediaException {
        return this.tempFile.length();
    }

    public int readContent(long position, byte[] buffer) throws MediaException {
        return this.readContent(position, buffer, 0, buffer.length);
    }

    public int readContent(long position, byte[] buffer, int offset, int length) throws MediaException {
        if (position < 0L || position > this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (position < 0L) {
            throw new NegativeArraySizeException();
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        int bytesRead = 0;
        try {
            FileInputStream contentStream = new FileInputStream(this.tempFile);
            long contentPosition = ((InputStream)contentStream).skip(position);
            bytesRead = ((InputStream)contentStream).read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
        return bytesRead;
    }

    private byte[] getContent(long position, int length) throws MediaException {
        if (position < 0L || position > this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        int contentLength = this.getSize() - position < (long)length ? (int)(this.getSize() - position) : length;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.tempFile, "r");
            byte[] content = new byte[contentLength];
            randomAccessFile.seek(position);
            randomAccessFile.read(content);
            byte[] byArray = content;
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new ContentAccessException(e.getMessage());
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private InputStream getContentStream() throws MediaException {
        try {
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            throw new ContentAccessException(e.getMessage());
        }
    }

    private static String getFileName(String name) {
        int lastDotPosition = name.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return name;
        }
        return name.substring(0, lastDotPosition);
    }

    private static String getFileExtension(String name) {
        int lastDotPosition = name.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return name.substring(lastDotPosition + 1);
    }
}

