/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jgroups.blocks.MethodCall;

public class LockInterceptor
extends Interceptor {
    private TransactionManager tx_mgr = null;
    TransactionTable tx_table = null;
    HashMap lock_table;
    private long lock_acquisition_timeout;
    ReentrantLock create_lock = new ReentrantLock();
    private List transactions = Collections.synchronizedList(new ArrayList());
    static final int NONE = 0;
    static final int READ = 1;
    static final int WRITE = 2;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
        this.lock_table = cache.getLockTable();
        this.lock_acquisition_timeout = cache.getLockAcquisitionTimeout();
    }

    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        Object retval = null;
        Fqn fqn = null;
        int lock_type = 0;
        long lock_timeout = this.lock_acquisition_timeout;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        LinkedList locks = null;
        boolean recursive = false;
        boolean createIfNotExists = false;
        if (this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx)) {
            if (!this.transactions.contains(tx)) {
                gtx = this.cache.getCurrentTransaction(tx);
                if (gtx == null) {
                    throw new Exception("failed to get global transaction");
                }
                try {
                    OrderedSynchronizationHandler handler = OrderedSynchronizationHandler.getInstance(tx);
                    SynchronizationHandler myHandler = new SynchronizationHandler(gtx, tx, this.cache);
                    handler.registerAtTail(myHandler);
                    this.transactions.add(tx);
                }
                catch (Exception e) {
                    this.log.error((Object)("registration for tx=" + tx + " with transaction manager failed, running without TX"), (Throwable)e);
                }
            } else {
                gtx = this.cache.getTransactionTable().get(tx);
            }
        } else {
            locks = (LinkedList)this.lock_table.get(Thread.currentThread());
            if (locks == null) {
                locks = new LinkedList();
                this.lock_table.put(Thread.currentThread(), locks);
            }
        }
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal) || meth.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
            createIfNotExists = true;
            fqn = (Fqn)args[1];
            lock_type = 2;
            if (meth.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
                lock_timeout = (Long)args[5];
            }
        } else if (meth.equals(TreeCache.removeNodeMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
            recursive = true;
        } else if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
        } else if (meth.equals(TreeCache.evictNodeMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 2;
        } else if (meth.equals(TreeCache.addChildMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
        } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.lockMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = (Integer)args[1];
            recursive = (Boolean)args[2];
        }
        if (fqn != null) {
            if (createIfNotExists) {
                do {
                    this.lock(fqn, gtx, lock_type, locks, recursive, lock_timeout, createIfNotExists);
                } while (!this.cache.exists(fqn));
            } else {
                this.lock(fqn, gtx, lock_type, locks, recursive, lock_timeout, createIfNotExists);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("bypassed locking as method " + m.getName() + "() doesn't require locking"));
        }
        if (meth.equals(TreeCache.lockMethodLocal)) {
            return null;
        }
        retval = super.invoke(m);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(Fqn fqn, GlobalTransaction gtx, int lock_type, List locks, boolean recursive, long lock_timeout, boolean createIfNotExists) throws TimeoutException, LockingException, InterruptedException {
        Node child_node = null;
        Fqn tmp_fqn = new Fqn();
        Object owner = gtx != null ? gtx : Thread.currentThread();
        boolean acquired = false;
        if (fqn == null) {
            this.log.error((Object)"fqn is null - this should not be the case");
            return;
        }
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        Node n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Set acquired_locks;
            block20: {
                Object child_name = fqn.get(i);
                tmp_fqn = new Fqn(tmp_fqn, child_name);
                if (createIfNotExists) {
                    this.create_lock.acquire();
                }
                try {
                    child_node = n.getChild(child_name);
                    if (child_node != null) break block20;
                    if (createIfNotExists) {
                        child_node = n.createChild(child_name, tmp_fqn, n);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("created child " + child_name));
                        }
                        if (gtx != null) {
                            this.cache.addNode(gtx, (Fqn)tmp_fqn.clone());
                        }
                        this.create_lock.release();
                        this.cache.notifyNodeCreated(tmp_fqn);
                        break block20;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("failed finding child " + child_name + " of node " + n.getFqn()));
                    }
                    return;
                }
                finally {
                    if (this.create_lock.holds() > 0L) {
                        this.create_lock.release();
                    }
                }
            }
            if (lock_type != 0) {
                acquired = lock_type == 2 && i == treeNodeSize - 1 ? child_node.acquire(owner, lock_timeout, 2) : child_node.acquire(owner, lock_timeout, 1);
            }
            if (acquired) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLock(gtx, child_node.getLock());
                } else {
                    IdentityLock l = child_node.getLock();
                    if (!locks.contains(l)) {
                        locks.add(l);
                    }
                }
            }
            if (recursive && i == treeNodeSize - 1 && (acquired_locks = child_node.acquireAll(owner, lock_timeout, lock_type)).size() > 0) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLocks(gtx, acquired_locks);
                } else {
                    locks.addAll(acquired_locks);
                }
            }
            n = child_node;
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        LinkedList list = new LinkedList(entry.getLocks());
        for (int i = list.size() - 1; i >= 0; --i) {
            IdentityLock lock = (IdentityLock)list.get(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
            }
            lock.release(gtx);
        }
        entry.getLocks().clear();
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + gtx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(gtx);
    }

    private void rollback(GlobalTransaction tx) {
        TransactionEntry entry = this.tx_table.get(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + tx));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + tx + " not found (transaction has possibly already been rolled back)"));
            return;
        }
        LinkedList undo_ops = new LinkedList(entry.getUndoOperations());
        ListIterator it = undo_ops.listIterator(undo_ops.size());
        while (it.hasPrevious()) {
            MethodCall undo_op = (MethodCall)it.previous();
            try {
                Object retval = undo_op.invoke((Object)this.cache);
                if (retval == null || !(retval instanceof Throwable)) continue;
                this.log.error((Object)("undo operation failed, error=" + retval));
            }
            catch (Throwable t) {
                this.log.error((Object)"undo operation failed", t);
            }
        }
        it = new LinkedList(entry.getNodes()).listIterator(entry.getNodes().size());
        while (it.hasPrevious()) {
            Fqn node_name = (Fqn)it.previous();
            try {
                this.cache._remove(tx, node_name, false);
            }
            catch (Throwable t) {
                this.log.error((Object)("failed removing node \"" + node_name + "\""), t);
            }
        }
        LinkedList list = new LinkedList(entry.getLocks());
        for (int i = list.size() - 1; i >= 0; --i) {
            IdentityLock lock = (IdentityLock)list.get(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
            }
            lock.release(tx);
        }
        entry.getLocks().clear();
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + tx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(tx);
    }

    class SynchronizationHandler
    implements Synchronization {
        GlobalTransaction gtx = null;
        Transaction tx = null;
        TreeCache cache = null;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.cache = cache;
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            LockInterceptor.this.transactions.remove(this.tx);
            switch (status) {
                case 3: {
                    LockInterceptor.this.commit(this.gtx);
                    break;
                }
                case 1: 
                case 4: {
                    if (LockInterceptor.this.log.isDebugEnabled()) {
                        LockInterceptor.this.log.debug((Object)"rolling back transaction");
                    }
                    LockInterceptor.this.rollback(this.gtx);
                    break;
                }
                default: {
                    LockInterceptor.this.rollback(this.gtx);
                    throw new IllegalStateException("failed rolling back transaction: " + status);
                }
            }
        }
    }
}

