/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Replicatable;
import org.jboss.cache.ReplicationQueue;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionManagerLookup;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TreeCache
extends ServiceMBeanSupport
implements TreeCacheMBean,
Cloneable,
MembershipListener {
    protected Node root = new Node("/", Fqn.fromString("/"), null, null, this);
    protected final Vector listeners = new Vector();
    protected JChannel channel = null;
    protected boolean coordinator = false;
    protected String cluster_name = "TreeCache-Group";
    protected String cluster_props = null;
    protected final Vector members = new Vector();
    protected RpcDispatcher disp = null;
    protected MessageListener ml = new MessageListenerAdaptor(this, this.log);
    protected long state_fetch_timeout = 5000L;
    protected long sync_repl_timeout = 15000L;
    protected boolean use_repl_queue = false;
    protected int repl_queue_max_elements = 1000;
    protected long repl_queue_interval = 5000L;
    private final TransactionTable tx_table = new TransactionTable();
    private final HashMap lock_table = new HashMap();
    protected boolean fetch_state_on_startup = true;
    protected long lock_acquisition_timeout = 10000L;
    protected String eviction_policy_class = null;
    protected TreeCacheListener eviction_policy_provider = null;
    protected int cache_mode = 1;
    public static Method putDataMethodLocal = null;
    public static Method putDataEraseMethodLocal = null;
    public static Method putKeyValMethodLocal = null;
    public static Method putFailFastKeyValueMethodLocal = null;
    public static Method removeNodeMethodLocal = null;
    public static Method removeKeyMethodLocal = null;
    public static Method removeDataMethodLocal = null;
    public static Method evictNodeMethodLocal = null;
    public static Method prepareMethod = null;
    public static Method commitMethod = null;
    public static Method rollbackMethod = null;
    public static Method replicateMethod = null;
    public static Method replicateAllMethod = null;
    public static Method addChildMethodLocal = null;
    public static Method getKeyValueMethodLocal = null;
    public static Method getNodeMethodLocal = null;
    public static Method getKeysMethodLocal = null;
    public static Method getChildrenNamesMethodLocal = null;
    public static Method releaseAllLocksMethodLocal = null;
    public static Method printMethodLocal = null;
    public static Method lockMethodLocal = null;
    static LinkedList crud_methods = new LinkedList();
    protected boolean isStateSet = false;
    private final Object stateLock = new Object();
    protected IsolationLevel isolationLevel = IsolationLevel.REPEATABLE_READ;
    protected Element evictConfig_ = null;
    protected Interceptor interceptor_chain = null;
    protected Replicatable replication_handler = null;
    protected TransactionManagerLookup tm_lookup = null;
    protected String tm_lookup_class = null;
    protected TransactionManager tm = null;
    protected String cache_loader_class = null;
    protected CacheLoader cache_loader = null;
    protected Properties cache_loader_config = null;
    protected boolean cache_loader_shared = true;
    protected List cache_loader_preload = null;
    protected boolean cache_loader_fetch_transient_state = true;
    protected boolean cache_loader_fetch_persistent_state = true;
    protected boolean sync_commit_phase = false;
    protected boolean sync_rollback_phase = false;
    protected boolean deadlockDetection = false;
    protected ReplicationQueue repl_queue = null;
    public static final String SEPARATOR = "/";
    public static final int LOCAL = 1;
    public static final int REPL_ASYNC = 2;
    public static final int REPL_SYNC = 3;
    public static final String UNINITIALIZED = "jboss:internal:uninitialized";
    static final String JNDI_LOCATOR_URI = "socket://localhost:6789";
    static /* synthetic */ Class class$org$jboss$cache$GlobalTransaction;
    static /* synthetic */ Class class$org$jboss$cache$Fqn;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$jboss$cache$TreeCache;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$jgroups$Address;
    static /* synthetic */ Class class$org$jboss$cache$Node;
    static /* synthetic */ Class class$org$jgroups$blocks$MethodCall;

    public MessageListener getMessageListener() {
        return this.ml;
    }

    public static boolean isCrudMethod(Method m) {
        return m == null ? false : crud_methods.contains(m);
    }

    public TreeCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        if (cluster_name != null) {
            this.cluster_name = cluster_name;
        }
        if (props != null) {
            this.cluster_props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
    }

    public TreeCache() throws Exception {
    }

    public TreeCache(JChannel channel) throws Exception {
        this.channel = channel;
    }

    public Node getRoot() {
        return this.root;
    }

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String name) {
        this.cluster_name = name;
    }

    public String getClusterProperties() {
        return this.cluster_props;
    }

    public void setClusterProperties(String cluster_props) {
        this.cluster_props = cluster_props;
    }

    public TransactionTable getTransactionTable() {
        return this.tx_table;
    }

    public HashMap getLockTable() {
        return this.lock_table;
    }

    public String dumpTransactionTable() {
        return this.tx_table.toString(true);
    }

    public boolean getDeadlockDetection() {
        return this.deadlockDetection;
    }

    public void setDeadlockDetection(boolean dt) {
        this.deadlockDetection = dt;
        if (this.disp != null) {
            this.disp.setDeadlockDetection(dt);
        }
    }

    public String getInterceptorChain() {
        String retval = this.printInterceptorChain(this.interceptor_chain);
        if (retval == null || retval.length() == 0) {
            return "<empty>";
        }
        return retval;
    }

    public List getInterceptors() {
        if (this.interceptor_chain == null) {
            return null;
        }
        int num = 1;
        Interceptor tmp = this.interceptor_chain;
        while ((tmp = tmp.getNext()) != null) {
            ++num;
        }
        ArrayList<Interceptor> retval = new ArrayList<Interceptor>(num);
        tmp = this.interceptor_chain;
        num = 0;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return retval;
    }

    public String getCacheLoaderClass() {
        return this.cache_loader_class;
    }

    public void setCacheLoaderClass(String cache_loader_class) {
        this.cache_loader_class = cache_loader_class;
    }

    public Properties getCacheLoaderConfig() {
        return this.cache_loader_config;
    }

    public void setCacheLoaderConfig(Properties cache_loader_config) {
        this.cache_loader_config = cache_loader_config;
    }

    public CacheLoader getCacheLoader() {
        return this.cache_loader;
    }

    public void setCacheLoader(CacheLoader cache_loader) {
        this.cache_loader = cache_loader;
    }

    public boolean getCacheLoaderShared() {
        return this.cache_loader_shared;
    }

    public void setCacheLoaderShared(boolean shared) {
        this.cache_loader_shared = shared;
    }

    public void setCacheLoaderPreload(String list) {
        if (list == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        ArrayList<Fqn> l = new ArrayList<Fqn>();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            Fqn fqn = Fqn.fromString(tok.trim());
            l.add(fqn);
        }
        if (l.size() > 0) {
            this.cache_loader_preload = l;
        }
    }

    public String getCacheLoaderPreload() {
        return this.cache_loader_preload != null ? this.cache_loader_preload.toString() : null;
    }

    public void setCacheLoaderFetchPersistentState(boolean flag) {
        this.cache_loader_fetch_persistent_state = flag;
    }

    public boolean getCacheLoaderFetchPersistentState() {
        return this.cache_loader_fetch_persistent_state;
    }

    public void setCacheLoaderFetchTransientState(boolean flag) {
        this.cache_loader_fetch_transient_state = flag;
    }

    public boolean getCacheLoaderFetchTransientState() {
        return this.cache_loader_fetch_transient_state;
    }

    public boolean getSyncCommitPhase() {
        return this.sync_commit_phase;
    }

    public void setSyncCommitPhase(boolean sync_commit_phase) {
        this.sync_commit_phase = sync_commit_phase;
    }

    public boolean getSyncRollbackPhase() {
        return this.sync_rollback_phase;
    }

    public void setSyncRollbackPhase(boolean sync_rollback_phase) {
        this.sync_rollback_phase = sync_rollback_phase;
    }

    public void setEvictionPolicyConfig(Element config) {
        this.evictConfig_ = config;
        this.log.info((Object)("setEvictionPolicyConfig(): " + config));
    }

    public Element getEvictionPolicyConfig() {
        return this.evictConfig_;
    }

    public void setClusterConfig(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            org.w3c.dom.Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        this.setClusterProperties(buffer.toString());
        this.log.info((Object)("setting cluster properties from xml to: " + this.cluster_props));
    }

    public long getInitialStateRetrievalTimeout() {
        return this.state_fetch_timeout;
    }

    public void setInitialStateRetrievalTimeout(long timeout) {
        this.state_fetch_timeout = timeout;
    }

    public String getCacheMode() {
        return this.mode2String(this.cache_mode);
    }

    public int getCacheModeInternal() {
        return this.cache_mode;
    }

    private String mode2String(int mode) {
        switch (mode) {
            case 1: {
                return "LOCAL";
            }
            case 2: {
                return "REPL_ASYNC";
            }
            case 3: {
                return "REPL_SYNC";
            }
        }
        throw new RuntimeException("setCacheMode(): caching mode " + mode + " is invalid");
    }

    public void setCacheMode(String mode) throws Exception {
        int m = this.string2Mode(mode);
        this.setCacheMode(m);
    }

    public void setCacheMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("setCacheMode(): caching mode " + mode + " is invalid");
        }
        this.cache_mode = mode;
    }

    public long getSyncReplTimeout() {
        return this.sync_repl_timeout;
    }

    public void setSyncReplTimeout(long timeout) {
        this.sync_repl_timeout = timeout;
    }

    public boolean getUseReplQueue() {
        return this.use_repl_queue;
    }

    public void setUseReplQueue(boolean flag) {
        this.use_repl_queue = flag;
        if (flag) {
            if (this.repl_queue == null) {
                this.repl_queue = new ReplicationQueue(this, this.repl_queue_interval, this.repl_queue_max_elements);
                if (this.repl_queue_interval >= 0L) {
                    this.repl_queue.start();
                }
            }
        } else if (this.repl_queue != null) {
            this.repl_queue.stop();
            this.repl_queue = null;
        }
    }

    public long getReplQueueInterval() {
        return this.repl_queue_interval;
    }

    public void setReplQueueInterval(long interval) {
        this.repl_queue_interval = interval;
        if (this.repl_queue != null) {
            this.repl_queue.setInterval(interval);
        }
    }

    public int getReplQueueMaxElements() {
        return this.repl_queue_max_elements;
    }

    public void setReplQueueMaxElements(int max_elements) {
        this.repl_queue_max_elements = max_elements;
        if (this.repl_queue != null) {
            this.repl_queue.setMax_elements(max_elements);
        }
    }

    public ReplicationQueue getReplQueue() {
        return this.repl_queue;
    }

    public String getIsolationLevel() {
        return this.isolationLevel.toString();
    }

    public void setIsolationLevel(String level) {
        IsolationLevel tmp_level = IsolationLevel.stringToIsolationLevel(level);
        if (tmp_level == null) {
            throw new IllegalArgumentException("TreeCache.setIsolationLevel(): level \"" + level + "\" is invalid");
        }
        this.setIsolationLevel(tmp_level);
    }

    public void setIsolationLevel(IsolationLevel level) {
        this.isolationLevel = level;
        LockStrategyFactory.setIsolationLevel(level);
    }

    public IsolationLevel getIsolationLevelClass() {
        return this.isolationLevel;
    }

    public boolean getFetchStateOnStartup() {
        return this.fetch_state_on_startup;
    }

    public void setFetchStateOnStartup(boolean flag) {
        this.fetch_state_on_startup = flag;
    }

    public long getLockAcquisitionTimeout() {
        return this.lock_acquisition_timeout;
    }

    public void setLockAcquisitionTimeout(long timeout) {
        this.lock_acquisition_timeout = timeout;
    }

    public String getEvictionPolicyClass() {
        return this.eviction_policy_class;
    }

    public void setEvictionPolicyClass(String eviction_policy_class) {
        if (eviction_policy_class == null || eviction_policy_class.length() == 0) {
            return;
        }
        try {
            this.eviction_policy_class = eviction_policy_class;
            this.eviction_policy_provider = (TreeCacheListener)this.getClass().getClassLoader().loadClass(eviction_policy_class).newInstance();
            this.addTreeCacheListener(this.eviction_policy_provider);
        }
        catch (Throwable t) {
            this.log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), t);
        }
    }

    public int getEvictionThreadWakeupIntervalSeconds() {
        if (this.eviction_policy_provider == null) {
            return -1;
        }
        return ((LRUPolicy)this.eviction_policy_provider).getWakeupIntervalSeconds();
    }

    public void setTransactionManagerLookup(TransactionManagerLookup l) {
        this.tm_lookup = l;
    }

    public String getTransactionManagerLookupClass() {
        return this.tm_lookup_class;
    }

    public void setTransactionManagerLookupClass(String cl) throws Exception {
        this.tm_lookup_class = cl;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public TreeCache getInstance() {
        return this;
    }

    public void setReplicationHandler(Replicatable handler) {
        this.replication_handler = handler;
    }

    public Replicatable getReplicationHandler() {
        return this.replication_handler;
    }

    public void fetchState(long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.channel == null) {
            throw new ChannelNotConnectedException();
        }
        boolean rc = this.channel.getState(null, timeout);
        if (rc) {
            this.log.info((Object)"fetchState(): state was retrieved successfully");
        } else {
            this.log.info((Object)"fetchState(): state could not be retrieved (first member)");
        }
    }

    public void addTreeCacheListener(TreeCacheListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTreeCacheListener(TreeCacheListener listener) {
        this.listeners.removeElement(listener);
    }

    public void createService() throws Exception {
    }

    public void destroyService() {
    }

    public void startService() throws Exception {
        if (this.tm_lookup == null && this.tm_lookup_class != null) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.tm_lookup_class);
            this.tm_lookup = (TransactionManagerLookup)clazz.newInstance();
        }
        try {
            if (this.tm_lookup != null) {
                this.tm = this.tm_lookup.getTransactionManager();
            } else {
                this.log.warn((Object)"No transaction manager lookup class has been defined. Transactions cannot be used");
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"failed looking up TransactionManager, will not use transactions", (Throwable)e);
        }
        this.createCacheLoader();
        this.createInterceptorChain();
        this.createEvictionPolicy();
        switch (this.cache_mode) {
            case 1: {
                this.log.info((Object)"cache mode is local, will not create the channel");
                break;
            }
            case 2: 
            case 3: {
                this.log.info((Object)("cache mode is " + this.mode2String(this.cache_mode)));
                if (this.channel != null) {
                    this.log.info((Object)"channel is already running");
                    return;
                }
                if (this.cluster_props == null) {
                    this.cluster_props = this.getDefaultProperties();
                    this.log.debug((Object)"setting cluster properties to default value");
                }
                this.channel = new JChannel(this.cluster_props);
                this.channel.setOpt(5, (Object)Boolean.TRUE);
                this.channel.setOpt(6, (Object)Boolean.TRUE);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("cache properties: " + this.cluster_props));
                }
                this.channel.setOpt(4, (Object)Boolean.TRUE);
                this.disp = new RpcDispatcher((Channel)this.channel, this.ml, (MembershipListener)this, (Object)this);
                this.disp.setDeadlockDetection(this.deadlockDetection);
                this.channel.connect(this.cluster_name);
                if (!this.fetch_state_on_startup) break;
                this.fetchStateOnStartup();
                break;
            }
            default: {
                throw new IllegalArgumentException("cache mode " + this.cache_mode + " is invalid");
            }
        }
        this.cacheLoaderPreload();
        this.coordinator = this.determineCoordinator();
        this.notifyCacheStarted();
    }

    private void createEvictionPolicy() {
        if (this.eviction_policy_provider != null) {
            ((LRUPolicy)this.eviction_policy_provider).configure(this);
        }
    }

    protected void createInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor call_interceptor = null;
        Interceptor lock_interceptor = null;
        Interceptor repl_interceptor = null;
        Interceptor cache_loader_interceptor = null;
        Interceptor cache_store_interceptor = null;
        Interceptor unlock_interceptor = null;
        Interceptor first = null;
        call_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CallInterceptor");
        call_interceptor.setCache(this);
        lock_interceptor = this.createInterceptor("org.jboss.cache.interceptors.LockInterceptor");
        lock_interceptor.setCache(this);
        unlock_interceptor = this.createInterceptor("org.jboss.cache.interceptors.UnlockInterceptor");
        unlock_interceptor.setCache(this);
        if (this.cache_mode != 1) {
            repl_interceptor = this.createInterceptor("org.jboss.cache.interceptors.ReplicationInterceptor");
            repl_interceptor.setCache(this);
        }
        if (this.cache_loader_class != null || this.cache_loader != null) {
            cache_loader_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheLoaderInterceptor");
            cache_loader_interceptor.setCache(this);
            cache_store_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheStoreInterceptor");
            cache_store_interceptor.setCache(this);
        }
        if (cache_loader_interceptor != null && this.cache_loader_shared) {
            if (first == null) {
                first = cache_store_interceptor;
            } else {
                this.addInterceptor(first, cache_store_interceptor);
            }
        }
        if (repl_interceptor != null) {
            if (first == null) {
                first = repl_interceptor;
            } else {
                this.addInterceptor(first, repl_interceptor);
            }
        }
        if (unlock_interceptor != null) {
            if (first == null) {
                first = unlock_interceptor;
            } else {
                this.addInterceptor(first, unlock_interceptor);
            }
        }
        if (cache_loader_interceptor != null) {
            if (this.cache_loader_shared) {
                if (first == null) {
                    first = cache_loader_interceptor;
                } else {
                    this.addInterceptor(first, cache_loader_interceptor);
                }
            } else {
                if (first == null) {
                    first = cache_loader_interceptor;
                } else {
                    this.addInterceptor(first, cache_loader_interceptor);
                }
                if (first == null) {
                    first = cache_store_interceptor;
                } else {
                    this.addInterceptor(first, cache_store_interceptor);
                }
            }
        }
        if (first == null) {
            first = lock_interceptor;
        } else {
            this.addInterceptor(first, lock_interceptor);
        }
        if (first == null) {
            first = call_interceptor;
        } else {
            this.addInterceptor(first, call_interceptor);
        }
        this.interceptor_chain = first;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("interceptor chain is:\n" + this.printInterceptorChain(first)));
        }
    }

    private String printInterceptorChain(Interceptor i) {
        StringBuffer sb = new StringBuffer();
        if (i != null) {
            if (i.getNext() != null) {
                sb.append(this.printInterceptorChain(i.getNext())).append("\n");
            }
            sb.append(i.getClass());
        }
        return sb.toString();
    }

    private void addInterceptor(Interceptor first, Interceptor i) {
        if (first == null) {
            return;
        }
        while (first.getNext() != null && (first = first.getNext()) != null) {
        }
        first.setNext(i);
    }

    private Interceptor createInterceptor(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
        return (Interceptor)clazz.newInstance();
    }

    protected void createCacheLoader() throws Exception {
        if (this.cache_loader == null && this.cache_loader_class != null) {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(this.cache_loader_class);
            this.cache_loader = (CacheLoader)cl.newInstance();
            this.cache_loader.setConfig(this.cache_loader_config);
            this.cache_loader.setCache(this);
            this.cache_loader.create();
            this.cache_loader.start();
        }
    }

    protected void cacheLoaderPreload() throws Exception {
        if (this.cache_loader != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("preloading " + this.cache_loader_preload));
            }
            if (this.cache_loader_preload != null) {
                Iterator it = this.cache_loader_preload.iterator();
                while (it.hasNext()) {
                    Fqn fqn = (Fqn)it.next();
                    this.preload(fqn, true, true);
                }
            }
        }
    }

    public void load(String fqn) throws Exception {
        if (this.cache_loader != null) {
            this.preload(Fqn.fromString(fqn), true, true);
        }
    }

    void preload(Fqn fqn, boolean preload_parents, boolean preload_children) throws Exception {
        this.get(fqn, (Object)"bla");
        if (preload_parents) {
            Fqn tmp_fqn = new Fqn();
            for (int i = 0; i < fqn.size() - 1; ++i) {
                tmp_fqn = new Fqn(tmp_fqn, fqn.get(i));
                this.get(tmp_fqn, (Object)"bla");
            }
        }
        if (!preload_children) {
            return;
        }
        Set children = this.cache_loader.getChildrenNames(fqn);
        if (children == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            String child_name = (String)it.next();
            Fqn child_fqn = new Fqn(fqn, child_name);
            this.preload(child_fqn, false, true);
        }
    }

    void destroyCacheLoader() {
        if (this.cache_loader != null) {
            this.cache_loader.stop();
            this.cache_loader.destroy();
            this.cache_loader = null;
        }
    }

    protected boolean determineCoordinator() {
        if (this.channel == null) {
            return false;
        }
        Object local_addr = this.getLocalAddress();
        if (local_addr == null) {
            return false;
        }
        View view = this.channel.getView();
        if (view == null) {
            return false;
        }
        ViewId vid = view.getVid();
        if (vid == null) {
            return false;
        }
        Address coord = vid.getCoordAddress();
        if (coord == null) {
            return false;
        }
        return local_addr.equals(coord);
    }

    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        View view = this.channel.getView();
        if (view == null) {
            return null;
        }
        ViewId vid = view.getVid();
        if (vid == null) {
            return null;
        }
        Address coord = vid.getCoordAddress();
        return coord;
    }

    public byte[] getStateBytes() {
        return this.getMessageListener().getState();
    }

    public void setStateBytes(byte[] state) {
        this.getMessageListener().setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchStateOnStartup() throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            this.isStateSet = false;
            long start = System.currentTimeMillis();
            boolean rc = this.channel.getState(null, this.state_fetch_timeout);
            if (rc) {
                while (!this.isStateSet) {
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException iex) {}
                }
                long stop = System.currentTimeMillis();
                this.log.info((Object)("state was retrieved successfully (in " + (stop - start) + " milliseconds)"));
            } else {
                this.log.info((Object)"state could not be retrieved (must be first member in group)");
            }
        }
    }

    public void stopService() {
        if (this.channel != null) {
            this.log.info((Object)"stopService(): closing the channel");
            this.channel.close();
            this.channel = null;
        }
        if (this.disp != null) {
            this.log.info((Object)"stopService(): stopping the dispatcher");
            this.disp.stop();
            this.disp = null;
        }
        if (this.members != null && this.members.size() > 0) {
            this.members.clear();
        }
        if (this.repl_queue != null) {
            this.repl_queue.stop();
        }
        this.destroyCacheLoader();
        this.notifyCacheStopped();
        this.listeners.clear();
    }

    public Node get(String fqn) throws CacheException {
        return this.get(Fqn.fromString(fqn));
    }

    public Node get(Fqn fqn) throws CacheException {
        MethodCall m = new MethodCall(getNodeMethodLocal, new Object[]{fqn});
        return (Node)this.invokeMethod(m);
    }

    public Node _get(Fqn fqn) throws CacheException {
        return this.findNode(fqn);
    }

    public Set getKeys(String fqn) throws CacheException {
        return this.getKeys(Fqn.fromString(fqn));
    }

    public Set getKeys(Fqn fqn) throws CacheException {
        MethodCall m = new MethodCall(getKeysMethodLocal, new Object[]{fqn});
        return (Set)this.invokeMethod(m);
    }

    public Set _getKeys(Fqn fqn) throws CacheException {
        Set retval = null;
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        retval = n.getDataKeys();
        return retval != null ? new LinkedHashSet(retval) : null;
    }

    public Object get(String fqn, Object key) throws CacheException {
        return this.get(Fqn.fromString(fqn), key);
    }

    public Object get(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, true);
    }

    public Object _get(Fqn fqn, Object key, boolean sendNodeEvent) throws CacheException {
        Node n;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_get(, \"" + fqn + "\", " + key + ", \"" + sendNodeEvent + "\")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            return null;
        }
        if (sendNodeEvent) {
            this.notifyNodeVisisted(fqn);
        }
        return n.get(key);
    }

    protected Object get(Fqn fqn, Object key, boolean sendNodeEvent) throws CacheException {
        MethodCall m = new MethodCall(getKeyValueMethodLocal, new Object[]{fqn, key, new Boolean(sendNodeEvent)});
        return this.invokeMethod(m);
    }

    public Object peek(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, false);
    }

    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    public boolean exists(Fqn fqn) {
        Node n = this.findInternal(fqn);
        return n != null;
    }

    private Node findInternal(Fqn fqn) {
        if (fqn == null || fqn.size() == 0) {
            return this.root;
        }
        Node n = this.root;
        Node retval = null;
        for (int i = 0; i < fqn.size(); ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChild(obj)) == null) {
                return null;
            }
            retval = n;
        }
        return retval;
    }

    public boolean exists(String fqn, Object key) {
        return this.exists(Fqn.fromString(fqn), key);
    }

    public boolean exists(Fqn fqn, Object key) {
        Node n = this.findInternal(fqn);
        if (n == null) {
            return false;
        }
        return n.containsKey(key);
    }

    public void put(String fqn, Map data) throws CacheException {
        this.put(Fqn.fromString(fqn), data);
    }

    public void put(Fqn fqn, Map data) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(putDataMethodLocal, new Object[]{tx, fqn, data, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public Object put(String fqn, Object key, Object value) throws CacheException {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    public Object putFailFast(Fqn fqn, Object key, Object value, long timeout) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(putFailFastKeyValueMethodLocal, new Object[]{tx, fqn, key, value, Boolean.TRUE, new Long(timeout)});
        return this.invokeMethod(m);
    }

    public Object putFailFast(String fqn, Object key, Object value, long timeout) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        Fqn fqntmp = Fqn.fromString(fqn);
        MethodCall m = new MethodCall(putFailFastKeyValueMethodLocal, new Object[]{tx, fqntmp, key, value, Boolean.TRUE, new Long(timeout)});
        return this.invokeMethod(m);
    }

    public Object put(Fqn fqn, Object key, Object value) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(putKeyValMethodLocal, new Object[]{tx, fqn, key, value, Boolean.TRUE});
        return this.invokeMethod(m);
    }

    public void remove(String fqn) throws CacheException {
        this.remove(Fqn.fromString(fqn));
    }

    public void remove(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(removeNodeMethodLocal, new Object[]{tx, fqn, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public void evict(Fqn fqn) throws CacheException {
        MethodCall m = new MethodCall(evictNodeMethodLocal, new Object[]{fqn});
        this.invokeMethod(m);
    }

    public Object remove(String fqn, Object key) throws CacheException {
        return this.remove(Fqn.fromString(fqn), key);
    }

    public Object remove(Fqn fqn, Object key) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(removeKeyMethodLocal, new Object[]{tx, fqn, key, Boolean.TRUE});
        return this.invokeMethod(m);
    }

    public void removeData(String fqn) throws CacheException {
        this.removeData(Fqn.fromString(fqn));
    }

    public void removeData(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = new MethodCall(removeDataMethodLocal, new Object[]{tx, fqn, Boolean.TRUE});
        this.invokeMethod(m);
    }

    public void releaseAllLocks(String fqn) {
        this.releaseAllLocks(Fqn.fromString(fqn));
    }

    public void releaseAllLocks(Fqn fqn) {
        MethodCall m = new MethodCall(releaseAllLocksMethodLocal, new Object[]{fqn});
        try {
            this.invokeMethod(m);
        }
        catch (CacheException e) {
            this.log.error((Object)("failed releasing all locks for " + fqn), (Throwable)((Object)e));
        }
    }

    public String print(String fqn) {
        return this.print(Fqn.fromString(fqn));
    }

    public String print(Fqn fqn) {
        MethodCall m = new MethodCall(printMethodLocal, new Object[]{fqn});
        Object retval = null;
        try {
            retval = this.invokeMethod(m);
        }
        catch (Throwable e) {
            retval = e;
        }
        if (retval != null) {
            return retval.toString();
        }
        return "";
    }

    public Set getChildrenNames(String fqn) throws CacheException {
        return this.getChildrenNames(Fqn.fromString(fqn));
    }

    public Set getChildrenNames(Fqn fqn) throws CacheException {
        MethodCall m = new MethodCall(getChildrenNamesMethodLocal, new Object[]{fqn});
        return (Set)this.invokeMethod(m);
    }

    public Set _getChildrenNames(Fqn fqn) throws CacheException {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map m = n.getChildren();
        if (m != null) {
            return new LinkedHashSet(m.keySet());
        }
        return null;
    }

    public boolean hasChild(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        Node n = this.root;
        for (int i = 0; i < fqn.size(); ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChild(obj)) != null) continue;
            return false;
        }
        return n.hasChildren();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            Map children = this.root.getChildren();
            if (children != null && children.size() > 0) {
                Collection nodes = children.values();
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    ((Node)it.next()).print(sb, indent);
                    sb.append("\n");
                }
            } else {
                sb.append(SEPARATOR);
            }
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        Map children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            Collection nodes = children.values();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((Node)it.next()).printDetails(sb, indent);
                sb.append("\n");
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public String printLockInfo() {
        StringBuffer sb = new StringBuffer("\n");
        int indent = 0;
        Map children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            Collection nodes = children.values();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((Node)it.next()).printLockInfo(sb, indent);
                sb.append("\n");
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public int getNumberOfLocksHeld() {
        return this.numLocks(this.root);
    }

    int numLocks(Node n) {
        Map children;
        int num = 0;
        if (n.isLocked()) {
            ++num;
        }
        if ((children = n.getChildren()) != null) {
            Iterator it = children.values().iterator();
            while (it.hasNext()) {
                num += this.numLocks((Node)it.next());
            }
        }
        return num;
    }

    public int getNumberOfNodes() {
        return this.numNodes(this.root) - 1;
    }

    int numNodes(Node n) {
        Map children;
        if (n == null) {
            return 0;
        }
        int count = 1;
        if (n.hasChildren() && (children = n.getChildren()) != null && children.size() > 0) {
            Collection child_nodes = children.values();
            Iterator it = child_nodes.iterator();
            while (it.hasNext()) {
                Node child = (Node)it.next();
                count += this.numNodes(child);
            }
        }
        return count;
    }

    public int getNumberOfAttributes() {
        return this.numAttributes(this.root);
    }

    int numAttributes(Node n) {
        Map children;
        if (n == null) {
            return 0;
        }
        int count = n.numAttributes();
        if (n.hasChildren() && (children = n.getChildren()) != null && children.size() > 0) {
            Collection child_nodes = children.values();
            Iterator it = child_nodes.iterator();
            while (it.hasNext()) {
                Node child = (Node)it.next();
                count += child.numAttributes();
            }
        }
        return count;
    }

    public List callRemoteMethods(Vector mbrs, MethodCall method_call, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Object local_addr;
        Vector validMembers;
        int mode;
        int n = mode = synchronous ? 2 : 6;
        if (this.disp == null) {
            return null;
        }
        Vector vector = validMembers = mbrs != null ? new Vector(mbrs) : new Vector(this.members);
        if (exclude_self && validMembers.size() > 0 && (local_addr = this.getLocalAddress()) != null) {
            validMembers.remove(local_addr);
        }
        if (validMembers.size() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"destination list is empty, discarding call");
            }
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("callRemoteMethods(): valid members are " + validMembers));
        }
        RspList rsps = this.disp.callRemoteMethods(validMembers, method_call, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + method_call.getName() + ":\n" + rsps));
        }
        if (rsps == null) {
            return null;
        }
        ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.wasSuspected() || !rsp.wasReceived()) {
                retval.add((Object)new TimeoutException("rsp=" + rsp));
                continue;
            }
            retval.add(rsp.getValue());
        }
        return retval;
    }

    public List callRemoteMethods(Vector members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(members, new MethodCall(method, args), synchronous, exclude_self, timeout);
    }

    public List callRemoteMethods(Vector members, String method_name, Class[] types, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Method method = this.getClass().getDeclaredMethod(method_name, types);
        return this.callRemoteMethods(members, method, args, synchronous, exclude_self, timeout);
    }

    public void _put(GlobalTransaction tx, String fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, Fqn.fromString(fqn), data, create_undo_ops);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, boolean erase_contents) throws CacheException {
        Node n;
        MethodCall undo_op = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_put(" + tx + ", \"" + fqn + "\", " + data + ")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        if (tx != null && create_undo_ops) {
            Map old_data = n.getData();
            undo_op = old_data == null ? new MethodCall(removeDataMethodLocal, new Object[]{tx, fqn, Boolean.FALSE}) : new MethodCall(putDataEraseMethodLocal, new Object[]{tx, fqn, new HashMap(old_data), Boolean.FALSE, Boolean.TRUE});
        }
        n.put(data, erase_contents);
        if (tx != null && create_undo_ops) {
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        this.notifyNodeModified(fqn);
    }

    public Object _put(GlobalTransaction tx, String fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        return this._put(tx, Fqn.fromString(fqn), key, value, create_undo_ops);
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        Node n = null;
        MethodCall undo_op = null;
        Object old_value = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_put(" + tx + ", \"" + fqn + "\", " + key + ", " + value + ")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        old_value = n.get(key);
        n.put(key, value);
        if (tx != null && create_undo_ops) {
            undo_op = old_value == null ? new MethodCall(removeKeyMethodLocal, new Object[]{tx, fqn, key, Boolean.FALSE}) : new MethodCall(putKeyValMethodLocal, new Object[]{tx, fqn, key, old_value, Boolean.FALSE});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        this.notifyNodeModified(fqn);
        return old_value;
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops, long timeout) throws CacheException {
        return this._put(tx, fqn, key, value, create_undo_ops);
    }

    public void _remove(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, true);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._remove(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        MethodCall undo_op = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\")"));
        }
        if (fqn.size() == 0) {
            Set children = this.getChildrenNames(fqn);
            if (children != null) {
                Object[] kids = children.toArray();
                for (int i = 0; i < kids.length; ++i) {
                    Object s = kids[i];
                    Fqn tmp = new Fqn(fqn, s);
                    try {
                        this._remove(tx, tmp, create_undo_ops, true, eviction);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("failure removing node " + tmp));
                    }
                }
            }
            return;
        }
        Node n = this.findNode(fqn);
        if (n == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        Node parent_node = n.getParent();
        parent_node.removeChild(n.getName());
        n.releaseAll(tx != null ? tx : Thread.currentThread());
        if (tx != null && create_undo_ops && n != null && !eviction) {
            undo_op = new MethodCall(addChildMethodLocal, new Object[]{tx, parent_node.getFqn(), n.getName(), n});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        if (sendNodeEvent) {
            this.notifyNodeRemoved(fqn);
        } else {
            this.notifyNodeEvicted(fqn);
        }
    }

    public Object _remove(GlobalTransaction tx, String fqn, Object key, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, Fqn.fromString(fqn), key, create_undo_ops);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, fqn, key, create_undo_ops, false);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        Node n = null;
        MethodCall undo_op = null;
        Object old_value = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\", " + key + ")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return null;
        }
        old_value = n.remove(key);
        if (tx != null && create_undo_ops && old_value != null) {
            undo_op = new MethodCall(putKeyValMethodLocal, new Object[]{tx, fqn, key, old_value, Boolean.FALSE});
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        if (sendNodeEvent) {
            this.notifyNodeModified(fqn);
        }
        return old_value;
    }

    public void _removeData(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        Node n = null;
        MethodCall undo_op = null;
        Map old_data = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_removeData(" + tx + ", \"" + fqn + "\")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        if (tx != null && create_undo_ops && (old_data = n.getData()) != null && !eviction) {
            undo_op = new MethodCall(putDataMethodLocal, new Object[]{tx, fqn, new HashMap(old_data), Boolean.FALSE});
        }
        n.clear();
        if (eviction) {
            n.put(UNINITIALIZED, null);
        }
        if (sendNodeEvent) {
            this.notifyNodeVisisted(fqn);
        } else if (eviction) {
            this.notifyNodeEvicted(fqn);
        } else {
            this.notifyNodeModified(fqn);
        }
        if (tx != null && create_undo_ops) {
            this.tx_table.addUndoOperation(tx, undo_op);
        }
    }

    public void _evict(Fqn fqn) throws CacheException {
        if (!this.exists(fqn)) {
            return;
        }
        boolean create_undo_ops = false;
        boolean sendNodeEvent = false;
        boolean eviction = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_evict(" + fqn + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, create_undo_ops, sendNodeEvent, eviction);
        } else {
            this._remove((GlobalTransaction)null, fqn, create_undo_ops, sendNodeEvent, eviction);
        }
    }

    public void _addChild(GlobalTransaction tx, Fqn parent_fqn, Object child_name, Node old_node) throws CacheException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_addChild(" + tx + ", \"" + parent_fqn + "\", \"" + child_name + "\")"));
        }
        if (parent_fqn == null || child_name == null || old_node == null) {
            this.log.error((Object)"parent_fqn or child_name or node was null");
            return;
        }
        Node tmp = this.findNode(parent_fqn);
        if (tmp == null) {
            this.log.warn((Object)("node " + parent_fqn + " not found"));
            return;
        }
        tmp.addChild(child_name, old_node);
    }

    public Object _replicate(MethodCall method_call) throws Throwable {
        if (this.replication_handler != null) {
            return this.replication_handler.replicate(method_call);
        }
        throw new UnsupportedOperationException("no replication handler is installed");
    }

    public void _replicate(List method_calls) throws Throwable {
        if (this.replication_handler == null) {
            throw new UnsupportedOperationException("no replication handler is installed");
        }
        this.replication_handler.replicate(method_calls);
    }

    public void _releaseAllLocks(Fqn fqn) {
        try {
            Node n = this.findNode(fqn);
            if (n == null) {
                this.log.error((Object)("releaseAllLocks(): node " + fqn + " not found"));
                return;
            }
            n.releaseAllForce();
        }
        catch (Throwable t) {
            this.log.error((Object)"releaseAllLocks(): failed", t);
        }
    }

    public String _print(Fqn fqn) {
        try {
            Node n = this.findNode(fqn);
            if (n == null) {
                return null;
            }
            return n.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void _lock(Fqn fqn, int lock_type, boolean recursive) throws TimeoutException, LockingException {
        this.log.warn((Object)"method _lock() should not be invoked on TreeCache");
    }

    public void prepare(GlobalTransaction global_tx, List modifications, Address coord, boolean commit) {
        throw new UnsupportedOperationException("prepare() should not be called on TreeCache directly");
    }

    public void commit(GlobalTransaction tx) {
        throw new UnsupportedOperationException("commit() should not be called on TreeCache directly");
    }

    public void rollback(GlobalTransaction tx) {
        throw new UnsupportedOperationException("rollback() should not be called on TreeCache directly");
    }

    public void addNode(GlobalTransaction gtx, Fqn node) {
        this.tx_table.addNode(gtx, node);
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        this.log.info((Object)("viewAccepted(): new members: " + new_mbrs));
        if (new_mbrs != null) {
            this.members.removeAllElements();
            this.members.addAll(new_view.getMembers());
            this.notifyViewChange(new_view);
        }
        if (this.cache_loader_shared) {
            this.coordinator = this.determineCoordinator();
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    protected Transaction getLocalTransaction() {
        if (this.tm == null) {
            return null;
        }
        try {
            return this.tm.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    boolean isValid(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0 || status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    public GlobalTransaction getCurrentTransaction() {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!this.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            this.log.warn((Object)("status is " + status + " (not ACTIVE or PREPARING); returning null)"));
            return null;
        }
        return this.getCurrentTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        TransactionTable transactionTable = this.tx_table;
        synchronized (transactionTable) {
            GlobalTransaction gtx = this.tx_table.get(tx);
            if (gtx == null) {
                Address addr = (Address)this.getLocalAddress();
                gtx = GlobalTransaction.create(addr);
                this.tx_table.put(tx, gtx);
                TransactionEntry ent = new TransactionEntry();
                ent.setTransaction(tx);
                this.tx_table.put(gtx, ent);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("created new GTX: " + gtx + ", local TX=" + tx));
                }
            }
            return gtx;
        }
    }

    protected Object invokeMethod(MethodCall m) throws CacheException {
        try {
            return this.interceptor_chain.invoke(m);
        }
        catch (Throwable t) {
            if (t instanceof CacheException) {
                throw (CacheException)((Object)t);
            }
            throw new NestedRuntimeException(t);
        }
    }

    private Node findNode(Fqn fqn) {
        Node child_node = null;
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return this.root;
        }
        Node n = this.root;
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            child_node = n.getChild(child_name);
            if (child_node == null) {
                return null;
            }
            n = child_node;
        }
        return child_node;
    }

    public void notifyNodeCreated(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeCreated(fqn);
        }
    }

    public void notifyNodeLoaded(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeLoaded(fqn);
        }
    }

    protected void notifyNodeRemoved(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeRemoved(fqn);
        }
    }

    protected void notifyNodeEvicted(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeEvicted(fqn);
        }
    }

    protected void notifyNodeModified(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeModified(fqn);
        }
    }

    protected void notifyNodeVisisted(Fqn fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).nodeVisited(fqn);
        }
    }

    protected void notifyCacheStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).cacheStarted(this);
        }
    }

    protected void notifyCacheStopped() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).cacheStopped(this);
        }
    }

    protected void notifyViewChange(View v) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeCacheListener)this.listeners.elementAt(i)).viewChange(v);
        }
    }

    protected void notifyAllNodesCreated(Node curr) {
        if (curr == null) {
            return;
        }
        this.notifyNodeCreated(curr.fqn);
        Map children = curr.getChildren();
        if (children != null) {
            Iterator it = children.values().iterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                this.notifyAllNodesCreated(n);
            }
        }
    }

    protected String getDefaultProperties() {
        return "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;max_xmit_size=8192;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    }

    protected int string2Mode(String mode) {
        if (mode == null) {
            return -1;
        }
        String m = mode.toLowerCase().trim();
        if (m.equals("local")) {
            return 1;
        }
        if (m.equals("repl_async") || m.equals("repl-async")) {
            return 2;
        }
        if (m.equals("repl_sync") || m.equals("repl-sync")) {
            return 3;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            putDataMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_put", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$util$Map == null ? (class$java$util$Map = TreeCache.class$("java.util.Map")) : class$java$util$Map, Boolean.TYPE);
            putDataEraseMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_put", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$util$Map == null ? (class$java$util$Map = TreeCache.class$("java.util.Map")) : class$java$util$Map, Boolean.TYPE, Boolean.TYPE);
            putKeyValMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_put", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE);
            putFailFastKeyValueMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_put", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE, Long.TYPE);
            removeNodeMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_remove", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, Boolean.TYPE);
            removeKeyMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_remove", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE);
            removeDataMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_removeData", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, Boolean.TYPE);
            evictNodeMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_evict", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            prepareMethod = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("prepare", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$java$util$List == null ? (class$java$util$List = TreeCache.class$("java.util.List")) : class$java$util$List, class$org$jgroups$Address == null ? (class$org$jgroups$Address = TreeCache.class$("org.jgroups.Address")) : class$org$jgroups$Address, Boolean.TYPE);
            commitMethod = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("commit", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction);
            rollbackMethod = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("rollback", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction);
            addChildMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_addChild", class$org$jboss$cache$GlobalTransaction == null ? (class$org$jboss$cache$GlobalTransaction = TreeCache.class$("org.jboss.cache.GlobalTransaction")) : class$org$jboss$cache$GlobalTransaction, class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, class$org$jboss$cache$Node == null ? (class$org$jboss$cache$Node = TreeCache.class$("org.jboss.cache.Node")) : class$org$jboss$cache$Node);
            getKeyValueMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_get", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = TreeCache.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE);
            getNodeMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_get", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            getKeysMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_getKeys", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            getChildrenNamesMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_getChildrenNames", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            replicateMethod = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_replicate", class$org$jgroups$blocks$MethodCall == null ? (class$org$jgroups$blocks$MethodCall = TreeCache.class$("org.jgroups.blocks.MethodCall")) : class$org$jgroups$blocks$MethodCall);
            replicateAllMethod = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_replicate", class$java$util$List == null ? (class$java$util$List = TreeCache.class$("java.util.List")) : class$java$util$List);
            releaseAllLocksMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_releaseAllLocks", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            printMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_print", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            lockMethodLocal = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCache.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("_lock", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCache.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, Integer.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
        crud_methods.add(putDataMethodLocal);
        crud_methods.add(putDataEraseMethodLocal);
        crud_methods.add(putKeyValMethodLocal);
        crud_methods.add(putFailFastKeyValueMethodLocal);
        crud_methods.add(removeNodeMethodLocal);
        crud_methods.add(removeKeyMethodLocal);
        crud_methods.add(removeDataMethodLocal);
    }

    class MessageListenerAdaptor
    implements MessageListener {
        final TreeCache cache;
        final Logger log;

        MessageListenerAdaptor(TreeCache cache, Logger log) {
            this.cache = cache;
            this.log = log;
        }

        public void receive(Message msg) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            Object owner = null;
            boolean fetch_persistent_state = TreeCache.this.cache_loader != null && !TreeCache.this.cache_loader_shared && TreeCache.this.cache_loader_fetch_persistent_state;
            byte[] transient_state = null;
            byte[] persistent_state = null;
            byte[][] states = new byte[2][];
            byte[] retval = null;
            boolean locked = false;
            owner = TreeCache.this.getCurrentTransaction();
            if (owner == null) {
                owner = Thread.currentThread();
            }
            states[1] = null;
            states[0] = null;
            try {
                if (TreeCache.this.cache_loader_fetch_transient_state) {
                    this.log.info((Object)"locking the tree to obtain transient state");
                    TreeCache.this.root.acquireAll(owner, TreeCache.this.state_fetch_timeout, 1);
                    locked = true;
                    transient_state = Util.objectToByteBuffer((Object)TreeCache.this.root);
                    states[0] = transient_state;
                    this.log.info((Object)("returning the transient state (" + transient_state.length + " bytes)"));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"failed getting the transient state", t);
            }
            try {
                if (fetch_persistent_state) {
                    if (!locked) {
                        this.log.info((Object)"locking the tree to obtain persistent state");
                        TreeCache.this.root.acquireAll(owner, TreeCache.this.state_fetch_timeout, 1);
                        locked = true;
                    }
                    this.log.info((Object)"getting the persistent state");
                    persistent_state = TreeCache.this.cache_loader.loadEntireState();
                    states[1] = persistent_state;
                    this.log.info((Object)("returning the persistent state (" + persistent_state.length + " bytes)"));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"failed getting the persistent state", t);
            }
            try {
                byte[] t = retval = Util.objectToByteBuffer((Object)states);
                return t;
            }
            catch (Throwable t) {
                this.log.error((Object)"failed serializing transient and persistent state", t);
                byte[] byArray = retval;
                return byArray;
            }
            finally {
                TreeCache.this.root.releaseAll(owner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] new_state) {
            try {
                this._setState(new_state);
            }
            finally {
                Object object = TreeCache.this.stateLock;
                synchronized (object) {
                    TreeCache.this.stateLock.notifyAll();
                    if (TreeCache.this.root != null) {
                        TreeCache.this.root.releaseAllForce();
                    }
                }
            }
        }

        void _setState(byte[] new_state) {
            Node new_root = null;
            Node old_root = null;
            Object owner = null;
            byte[][] states = null;
            byte[] transient_state = null;
            byte[] persistent_state = null;
            boolean locked = false;
            if (new_state == null) {
                this.log.info((Object)"new cache is null (maybe first member in cluster)");
                return;
            }
            try {
                this.log.info((Object)("received the state (size=" + new_state.length + " bytes)"));
                states = (byte[][])Util.objectFromByteBuffer((byte[])new_state);
                transient_state = states[0];
                persistent_state = states[1];
                if (transient_state != null) {
                    this.log.info((Object)("transient state: " + transient_state.length + " bytes"));
                }
                if (persistent_state != null) {
                    this.log.info((Object)("persistent state: " + persistent_state.length + " bytes"));
                }
                if ((owner = TreeCache.this.getCurrentTransaction()) == null) {
                    owner = Thread.currentThread();
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"failed unserializing state", t);
            }
            if (transient_state != null) {
                try {
                    this.log.info((Object)"setting transient state");
                    Object obj = Util.objectFromByteBuffer(transient_state);
                    new_root = (Node)obj;
                    new_root.setRecursiveTreeCacheInstance(this.cache);
                    this.log.info((Object)"locking the old tree");
                    TreeCache.this.root.acquireAll(owner, TreeCache.this.state_fetch_timeout, 2);
                    locked = true;
                    this.log.info((Object)"locking the old tree was successful");
                    old_root = TreeCache.this.root;
                    TreeCache.this.root = new_root;
                    this.log.info((Object)"setting the transient state was successful");
                    TreeCache.this.notifyAllNodesCreated(TreeCache.this.root);
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed setting transient state", t);
                }
            }
            if (persistent_state != null) {
                if (TreeCache.this.cache_loader == null) {
                    this.log.error((Object)"cache loader is null, cannot set persistent state");
                } else {
                    try {
                        if (!locked) {
                            this.log.info((Object)"locking the old tree");
                            TreeCache.this.root.acquireAll(owner, TreeCache.this.state_fetch_timeout, 2);
                            old_root = TreeCache.this.root;
                            locked = true;
                            TreeCache.this.root = new Node(TreeCache.SEPARATOR, Fqn.fromString(TreeCache.SEPARATOR), null, null, this.cache);
                            this.log.info((Object)"locking the old tree was successful");
                        }
                        this.log.info((Object)"setting the persistent state");
                        TreeCache.this.cache_loader.storeEntireState(persistent_state);
                        this.log.info((Object)"setting the persistent state was successful");
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"failed setting persistent state", t);
                    }
                }
            }
            if (old_root != null) {
                this.log.info((Object)"forcing release of all locks in old tree");
                try {
                    old_root.releaseAllForce();
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed releasing locks", t);
                }
            }
            TreeCache.this.isStateSet = true;
        }
    }
}

