/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public final class HtmlRendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlRendererUtils == null ? (class$org$apache$myfaces$renderkit$html$HtmlRendererUtils = HtmlRendererUtils.class$("org.apache.myfaces.renderkit.html.HtmlRendererUtils")) : class$org$apache$myfaces$renderkit$html$HtmlRendererUtils));
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_link_hidden_";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlRendererUtils;

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(paramMap.get(clientId));
        } else if (!HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(RendererUtils.EMPTY_STRING);
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = (String)paramMap.get(clientId);
            if (reqValue != null && (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true"))) {
                ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.TRUE);
            } else {
                ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.FALSE);
            }
        } else if (!HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.FALSE);
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("disabled")) || HtmlRendererUtils.isTrue(component.getAttributes().get("readOnly"));
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        if (paramValuesMap.containsKey(clientId = component.getClientId(facesContext))) {
            String[] reqValues = (String[])paramValuesMap.get(clientId);
            ((EditableValueHolder)((Object)component)).setSubmittedValue(reqValues);
        } else if (!HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(RendererUtils.EMPTY_STRING);
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(paramMap.get(clientId));
        } else if (!HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(RendererUtils.EMPTY_STRING);
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectOne, disabled, size, false);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectMany, disabled, size, true);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectOne, disabled, 1, false);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectMany, disabled, 1, true);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany) throws IOException {
        boolean useSubmittedValue;
        Set<String> lookupSet;
        Converter converter;
        List selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        writer.writeAttribute("name", uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", "true", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
            try {
                converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent);
            }
            catch (FacesException e) {
                log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
                converter = null;
            }
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
            try {
                converter = RendererUtils.findUIOutputConverter(facesContext, (UISelectOne)uiComponent);
            }
            catch (FacesException e) {
                log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
                converter = null;
            }
        }
        if (size == 0) {
            writer.writeAttribute("size", Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                useSubmittedValue = false;
                lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            } else {
                useSubmittedValue = true;
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                useSubmittedValue = false;
                lookup = uiSelectOne.getValue();
            } else {
                useSubmittedValue = true;
            }
            String lookupString = RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
            lookupSet = Collections.singleton(lookupString);
        }
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, useSubmittedValue, selectItemList);
        writer.writeText("", null);
        writer.endElement("select");
    }

    private static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, boolean useSubmittedValue, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", null);
                writer.writeAttribute("label", selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, useSubmittedValue, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            writer.write("\t\t");
            writer.startElement("option", null);
            if (itemStrValue != null) {
                writer.writeAttribute("value", itemStrValue, null);
            }
            if (lookupSet.contains(itemStrValue)) {
                writer.writeAttribute("selected", "selected", null);
            }
            if (selectItem.isDisabled()) {
                writer.writeAttribute("disabled", "disabled", null);
            }
            writer.writeText(selectItem.getLabel(), null);
            writer.endElement("option");
        }
    }

    public static void writePrettyLineSeparator(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(LINE_SEPARATOR);
        }
    }

    public static void writePrettyIndent(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(9);
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void writeIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            writer.writeAttribute("id", component.getClientId(facesContext), null);
        }
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        Iterator it = dummyFormParams.iterator();
        while (it.hasNext()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", null);
            writer.writeAttribute("name", it.next(), null);
            writer.endElement("input");
        }
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.write("\n<!--");
        writer.write("\nfunction ");
        writer.write(functionName);
        writer.write("() {");
        if (dummyFormParams != null) {
            writer.write("\n  var f = document.forms['");
            writer.write(formName);
            writer.write("'];");
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                writer.write("\n  f.elements['");
                writer.write((String)it.next());
                writer.write("'].value=null;");
            }
        }
        writer.write("\n  f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            writer.write("'';");
        } else {
            writer.write("'");
            writer.write(formTarget);
            writer.write("';");
        }
        writer.write("\n}");
        writer.write("\n");
        writer.write(functionName);
        writer.write("();");
        writer.write("\n//-->\n");
        writer.endElement("script");
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }

    public static String getFormName(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((UIForm)parent).getClientId(context);
        }
        return "linkDummyForm";
    }

    public static String getHiddenCommandLinkFieldName(String formName) {
        return formName + ':' + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LinkParameter {
        private String _name;
        private Object _value;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

