/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.util.DebugUtils;
import org.apache.myfaces.webapp.webxml.ServletMapping;
import org.apache.myfaces.webapp.webxml.WebXml;

public class JspViewHandlerImpl
extends ViewHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$application$jsp$JspViewHandlerImpl == null ? (class$org$apache$myfaces$application$jsp$JspViewHandlerImpl = JspViewHandlerImpl.class$("org.apache.myfaces.application.jsp.JspViewHandlerImpl")) : class$org$apache$myfaces$application$jsp$JspViewHandlerImpl));
    public static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    public static final int FORM_STATE_MARKER_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    static /* synthetic */ Class class$org$apache$myfaces$application$jsp$JspViewHandlerImpl;

    public JspViewHandlerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New ViewHandler instance created");
        }
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Iterator locales = facesContext.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            Iterator it = facesContext.getApplication().getSupportedLocales();
            while (it.hasNext()) {
                Locale supportLocale = (Locale)it.next();
                if (locale.getLanguage().equals(supportLocale.getLanguage()) && (supportLocale.getCountry() == null || supportLocale.getCountry().length() == 0)) {
                    return supportLocale;
                }
                if (!supportLocale.equals(locale)) continue;
                return supportLocale;
            }
        }
        Locale defaultLocale = facesContext.getApplication().getDefaultLocale();
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        String renderKitId = facesContext.getApplication().getDefaultRenderKitId();
        return renderKitId != null ? renderKitId : "HTML_BASIC";
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        Locale currentLocale = null;
        String currentRenderKitId = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            currentLocale = uiViewRoot.getLocale();
            currentRenderKitId = uiViewRoot.getRenderKitId();
        }
        uiViewRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
        uiViewRoot.setViewId(viewId);
        if (currentLocale != null) {
            uiViewRoot.setLocale(currentLocale);
        } else {
            uiViewRoot.setLocale(this.calculateLocale(facesContext));
        }
        if (currentRenderKitId != null) {
            uiViewRoot.setRenderKitId(currentRenderKitId);
        } else {
            uiViewRoot.setRenderKitId(this.calculateRenderKitId(facesContext));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created view " + viewId));
        }
        return uiViewRoot;
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        if (PortletUtil.isRenderResponse(facesContext)) {
            RenderResponse response = (RenderResponse)facesContext.getExternalContext().getResponse();
            PortletURL url = response.createActionURL();
            url.setParameter(MyFacesGenericPortlet.VIEW_ID, viewId);
            return url.toString();
        }
        String path = this.getViewIdPath(facesContext, viewId);
        if (path.length() > 0 && path.charAt(0) == '/') {
            return facesContext.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return facesContext.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        ServletResponse response;
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = facesContext.getViewRoot().getViewId();
        if (PortletUtil.isPortletRequest(facesContext)) {
            externalContext.dispatch(viewId);
            return;
        }
        ServletMapping servletMapping = JspViewHandlerImpl.getServletMapping(externalContext);
        if (servletMapping.isExtensionMapping()) {
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            DebugUtils.assertError(suffix.charAt(0) == '.', log, "Default suffix must start with a dot!");
            if (!viewId.endsWith(suffix)) {
                int dot = viewId.lastIndexOf(46);
                if (dot == -1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current viewId has no extension, appending default suffix " + suffix));
                    }
                    viewId = viewId + suffix;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Replacing extension of current viewId by suffix " + suffix));
                    }
                    viewId = viewId.substring(0, dot) + suffix;
                }
                facesContext.getViewRoot().setViewId(viewId);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dispatching to " + viewId));
        }
        if (externalContext.getResponse() instanceof ServletResponse) {
            response = (ServletResponse)externalContext.getResponse();
            response.setLocale(viewToRender.getLocale());
        }
        externalContext.dispatch(viewId);
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            response = (HttpServletResponse)externalContext.getResponse();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
            }
        }
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        Application application = facesContext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(facesContext);
        UIViewRoot viewRoot = application.getStateManager().restoreView(facesContext, viewId, renderKitId);
        return viewRoot;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        if (facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
            facesContext.getResponseWriter().write(FORM_STATE_MARKER);
        }
    }

    protected String getViewIdPath(FacesContext facescontext, String viewId) {
        if (viewId == null) {
            log.error((Object)"ViewId must not be null");
            throw new NullPointerException("ViewId must not be null");
        }
        if (!viewId.startsWith("/")) {
            log.error((Object)("ViewId must start with '/' (viewId = " + viewId + ")"));
            throw new IllegalArgumentException("ViewId must start with '/' (viewId = " + viewId + ")");
        }
        if (PortletUtil.isPortletRequest(facescontext)) {
            return viewId;
        }
        ServletMapping servletMapping = JspViewHandlerImpl.getServletMapping(facescontext.getExternalContext());
        if (servletMapping.isExtensionMapping()) {
            String urlpattern = servletMapping.getUrlPattern();
            if (urlpattern.startsWith("*")) {
                urlpattern = urlpattern.substring(1, urlpattern.length());
            }
            if (viewId.endsWith(urlpattern)) {
                return viewId;
            }
            int idx = viewId.lastIndexOf(".");
            if (idx >= 0) {
                return viewId.substring(0, idx) + urlpattern;
            }
            return viewId + urlpattern;
        }
        String urlpattern = servletMapping.getUrlPattern();
        if (urlpattern.endsWith("/*")) {
            urlpattern = urlpattern.substring(0, urlpattern.length() - 2);
        }
        return urlpattern + viewId;
    }

    private static ServletMapping getServletMapping(ExternalContext externalContext) {
        String servletPath = externalContext.getRequestServletPath();
        String requestPathInfo = externalContext.getRequestPathInfo();
        WebXml webxml = WebXml.getWebXml(externalContext);
        List mappings = webxml.getFacesServletMappings();
        boolean isExtensionMapping = requestPathInfo == null;
        int size = mappings.size();
        for (int i = 0; i < size; ++i) {
            String extension;
            ServletMapping servletMapping = (ServletMapping)mappings.get(i);
            if (servletMapping.isExtensionMapping() != isExtensionMapping) continue;
            String urlpattern = servletMapping.getUrlPattern();
            if (!(isExtensionMapping ? servletPath.endsWith(extension = urlpattern.substring(1, urlpattern.length())) : servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2)))) continue;
            return servletMapping;
        }
        if (mappings.size() > 0) {
            return (ServletMapping)mappings.get(0);
        }
        log.error((Object)"no faces servlet mappings found");
        throw new IllegalArgumentException("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

