/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.docproc.revdiff;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.docproc.revdiff.ModuleElementsComparator;
import org.hibernate.docproc.revdiff.ModuleElementsExtractor;
import org.hibernate.docproc.revdiff.ModuleReportHTML;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RevDiffReportTask
extends Task {
    private String saxParser = "org.apache.xerces.parsers.SAXParser";
    private String original;
    private String copy;
    private String report;

    public void setSaxParser(String string) {
        this.saxParser = string;
    }

    public void setOriginal(String string) {
        this.original = string;
    }

    public void setCopy(String string) {
        this.copy = string;
    }

    public void setReport(String string) {
        this.report = string;
    }

    public void execute() throws BuildException {
        try {
            System.setProperty("org.xml.sax.driver", this.saxParser);
            HashSet hashSet = new HashSet();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setContentHandler(new ModuleElementsExtractor(hashSet));
            xMLReader.parse(this.original);
            xMLReader.setContentHandler(new ModuleElementsComparator(hashSet));
            xMLReader.parse(this.copy);
            Properties properties = new Properties();
            properties.setProperty("DESTINATION_FILE", this.report);
            ModuleReportHTML moduleReportHTML = new ModuleReportHTML();
            moduleReportHTML.runReport(hashSet, properties);
        }
        catch (IOException iOException) {
            throw new BuildException("Files not found : " + this.original + " or " + this.copy, (Throwable)iOException);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

