/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.sql.ConditionFragment;

public class NotEmptyExpression
implements Criterion {
    private final String propertyName;
    private static final TypedValue[] NO_VALUES = new TypedValue[0];

    protected NotEmptyExpression(String propertyName) {
        this.propertyName = propertyName;
    }

    public String toString() {
        return this.propertyName + " is not empty";
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String role = criteriaQuery.getEntityName(criteria, this.propertyName) + '.' + criteriaQuery.getPropertyName(this.propertyName);
        QueryableCollection cp = (QueryableCollection)criteriaQuery.getFactory().getCollectionPersister(role);
        String[] fk = cp.getKeyColumnNames();
        String[] pk = ((Loadable)cp.getOwnerEntityPersister()).getIdentifierColumnNames();
        return "exists (select 1 from " + cp.getTableName() + " where " + new ConditionFragment().setTableAlias(criteriaQuery.getSQLAlias(criteria, this.propertyName)).setCondition(pk, fk).toFragmentString() + ")";
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_VALUES;
    }
}

