/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.hibernate.util.LinkedHashCollectionHelper;

public class PersistentSet
extends AbstractPersistentCollection
implements Set {
    Set set;
    private transient List tempList;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        HashMap<Object, Object> clonedSet = new HashMap<Object, Object>(this.set.size());
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object copied = persister.getElementType().deepCopy(iter.next(), entityMode, persister.getFactory());
            clonedSet.put(copied, copied);
        }
        return clonedSet;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        return PersistentSet.getOrphans(sn.keySet(), this.set, entityName, this.getSession());
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Map sn = (Map)((Object)this.getSnapshot());
        if (sn.size() != this.set.size()) {
            return false;
        }
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue != null && !elementType.isDirty(oldValue, test, this.getSession())) continue;
            return false;
        }
        return true;
    }

    public PersistentSet(SessionImplementor session) {
        super(session);
    }

    public PersistentSet() {
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = persister.hasOrdering() ? LinkedHashCollectionHelper.createLinkedHashSet() : new HashSet();
    }

    public PersistentSet(SessionImplementor session, Set set) {
        super(session);
        this.set = set;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            Object element = persister.getElementType().assemble(array[i], this.getSession(), owner);
            if (element == null) continue;
            this.set.add(element);
        }
        this.setInitialized();
    }

    public boolean empty() {
        return this.set.isEmpty();
    }

    public int size() {
        this.read();
        return this.set.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.set.isEmpty();
    }

    public boolean contains(Object o) {
        this.read();
        return this.set.contains(o);
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.set.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.read();
        return this.set.toArray(array);
    }

    public boolean add(Object value) {
        this.write();
        return this.set.add(value);
    }

    public boolean remove(Object value) {
        this.write();
        return this.set.remove(value);
    }

    public boolean containsAll(Collection coll) {
        this.read();
        return this.set.containsAll(coll);
    }

    public boolean addAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.addAll(coll);
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        this.write();
        return this.set.retainAll(coll);
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.removeAll(coll);
        }
        return false;
    }

    public void clear() {
        this.write();
        this.set.clear();
    }

    public String toString() {
        this.read();
        return this.set.toString();
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        if (element != null) {
            this.tempList.add(element);
        }
        return element;
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.set.addAll(this.tempList);
        this.tempList = null;
        this.setInitialized();
        return true;
    }

    public Iterator entries(CollectionPersister persister) {
        return this.set.iterator();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Serializable[] result = new Serializable[this.set.size()];
        Iterator iter = this.set.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = persister.getElementType().disassemble(iter.next(), this.getSession(), null);
        }
        return result;
    }

    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Object test;
        Type elementType = persister.getElementType();
        Map sn = (Map)((Object)this.getSnapshot());
        ArrayList<Object> deletes = new ArrayList<Object>(sn.size());
        Iterator<Object> iter = sn.keySet().iterator();
        while (iter.hasNext()) {
            test = iter.next();
            if (this.set.contains(test)) continue;
            deletes.add(test);
        }
        iter = this.set.iterator();
        while (iter.hasNext()) {
            test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue == null || !elementType.isDirty(test, oldValue, this.getSession())) continue;
            deletes.add(oldValue);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        Object oldValue = sn.get(entry);
        return oldValue == null || elemType.isDirty(oldValue, entry, this.getSession());
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    public boolean isRowUpdatePossible() {
        return false;
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Sets don't have indexes");
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i) {
        throw new UnsupportedOperationException("Sets don't support updating by element");
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.set).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.set).hashCode();
    }

    public boolean entryExists(Object key, int i) {
        return true;
    }

    public boolean isWrapper(Object collection) {
        return this.set == collection;
    }
}

