/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.loader.custom.SQLQueryCollectionReturn;
import org.hibernate.loader.custom.SQLQueryJoinReturn;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.QueryList;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public final class HbmBinder {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$cfg$HbmBinder == null ? (class$org$hibernate$cfg$HbmBinder = HbmBinder.class$("org.hibernate.cfg.HbmBinder")) : class$org$hibernate$cfg$HbmBinder));
    static /* synthetic */ Class class$org$hibernate$cfg$HbmBinder;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$hibernate$persister$entity$UnionSubclassEntityPersister;
    static /* synthetic */ Class class$org$hibernate$persister$entity$SingleTableEntityPersister;
    static /* synthetic */ Class class$org$hibernate$persister$entity$JoinedSubclassEntityPersister;

    private HbmBinder() {
    }

    public static void bindRoot(Document doc, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        List names = HbmBinder.getExtendsNeeded(doc, mappings);
        if (!names.isEmpty()) {
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                mappings.addToExtendsQueue(className, doc);
            }
            return;
        }
        Element hmNode = doc.getRootElement();
        inheritedMetas = HbmBinder.getMetas(hmNode, inheritedMetas, true);
        HbmBinder.extractRootAttributes(hmNode, mappings);
        Iterator filterDefs = hmNode.elementIterator("filter-def");
        while (filterDefs.hasNext()) {
            HbmBinder.parseFilterDef((Element)filterDefs.next(), mappings);
        }
        Iterator typeDefs = hmNode.elementIterator("typedef");
        while (typeDefs.hasNext()) {
            Element typeDef = (Element)typeDefs.next();
            String typeClass = typeDef.attributeValue("class");
            String typeName = typeDef.attributeValue("name");
            Iterator paramIter = typeDef.elementIterator("param");
            Properties parameters = new Properties();
            while (paramIter.hasNext()) {
                Element param = (Element)paramIter.next();
                parameters.setProperty(param.attributeValue("name"), param.getTextTrim());
            }
            mappings.addTypeDef(typeName, typeClass, parameters);
        }
        Iterator nodes = hmNode.elementIterator("class");
        while (nodes.hasNext()) {
            Element n = (Element)nodes.next();
            RootClass rootclass = new RootClass();
            HbmBinder.bindRootClass(n, rootclass, mappings, inheritedMetas);
            mappings.addClass(rootclass);
        }
        Iterator subclassnodes = hmNode.elementIterator("subclass");
        while (subclassnodes.hasNext()) {
            Element subnode = (Element)subclassnodes.next();
            PersistentClass superModel = HbmBinder.getSuperclass(mappings, subnode);
            HbmBinder.handleSubclass(superModel, mappings, subnode, inheritedMetas);
        }
        Iterator joinedsubclassnodes = hmNode.elementIterator("joined-subclass");
        while (joinedsubclassnodes.hasNext()) {
            Element subnode = (Element)joinedsubclassnodes.next();
            PersistentClass superModel = HbmBinder.getSuperclass(mappings, subnode);
            HbmBinder.handleJoinedSubclass(superModel, mappings, subnode, inheritedMetas);
        }
        Iterator unionsubclassnodes = hmNode.elementIterator("union-subclass");
        while (unionsubclassnodes.hasNext()) {
            Element subnode = (Element)unionsubclassnodes.next();
            PersistentClass superModel = HbmBinder.getSuperclass(mappings, subnode);
            HbmBinder.handleUnionSubclass(superModel, mappings, subnode, inheritedMetas);
        }
        nodes = hmNode.elementIterator("query");
        while (nodes.hasNext()) {
            HbmBinder.bindNamedQuery((Element)nodes.next(), mappings);
        }
        nodes = hmNode.elementIterator("sql-query");
        while (nodes.hasNext()) {
            HbmBinder.bindNamedSQLQuery((Element)nodes.next(), mappings);
        }
        nodes = hmNode.elementIterator("import");
        while (nodes.hasNext()) {
            Element n = (Element)nodes.next();
            String className = HbmBinder.getClassName(n.attribute("class"), mappings);
            Attribute renameNode = n.attribute("rename");
            String rename = renameNode == null ? StringHelper.unqualify(className) : renameNode.getValue();
            log.debug((Object)("Import: " + rename + " -> " + className));
            mappings.addImport(className, rename);
        }
    }

    private static void extractRootAttributes(Element hmNode, Mappings mappings) {
        Attribute schemaNode = hmNode.attribute("schema");
        mappings.setSchemaName(schemaNode == null ? null : schemaNode.getValue());
        Attribute catalogNode = hmNode.attribute("catalog");
        mappings.setCatalogName(catalogNode == null ? null : catalogNode.getValue());
        Attribute dcNode = hmNode.attribute("default-cascade");
        mappings.setDefaultCascade(dcNode == null ? "none" : dcNode.getValue());
        Attribute daNode = hmNode.attribute("default-access");
        mappings.setDefaultAccess(daNode == null ? "property" : daNode.getValue());
        Attribute dlNode = hmNode.attribute("default-lazy");
        mappings.setDefaultLazy(dlNode == null || dlNode.getValue().equals("true"));
        Attribute aiNode = hmNode.attribute("auto-import");
        mappings.setAutoImport(aiNode == null ? true : "true".equals(aiNode.getValue()));
        Attribute packNode = hmNode.attribute("package");
        if (packNode != null) {
            mappings.setDefaultPackage(packNode.getValue());
        }
    }

    public static void bindRootClass(Element node, RootClass rootClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindClass(node, rootClass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        HbmBinder.bindRootPersistentClassCommonValues(node, inheritedMetas, mappings, rootClass);
    }

    private static void bindRootPersistentClassCommonValues(Element node, java.util.Map inheritedMetas, Mappings mappings, RootClass entity) throws MappingException {
        Attribute polyNode;
        Attribute chNode;
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table table = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(entity, node, mappings), HbmBinder.getSubselect(node), entity.isAbstract());
        entity.setTable(table);
        log.info((Object)("Mapping class: " + entity.getEntityName() + " -> " + entity.getTable().getName()));
        Attribute mutableNode = node.attribute("mutable");
        entity.setMutable(mutableNode == null || mutableNode.getValue().equals("true"));
        Attribute whereNode = node.attribute("where");
        if (whereNode != null) {
            entity.setWhere(whereNode.getValue());
        }
        if ((chNode = node.attribute("check")) != null) {
            table.addCheckConstraint(chNode.getValue());
        }
        entity.setExplicitPolymorphism((polyNode = node.attribute("polymorphism")) != null && polyNode.getValue().equals("explicit"));
        Attribute rowidNode = node.attribute("rowid");
        if (rowidNode != null) {
            table.setRowId(rowidNode.getValue());
        }
        Iterator subnodes = node.elementIterator();
        while (subnodes.hasNext()) {
            Element subnode = (Element)subnodes.next();
            String name = subnode.getName();
            if ("id".equals(name)) {
                HbmBinder.bindSimpleId(subnode, entity, mappings, inheritedMetas);
                continue;
            }
            if ("composite-id".equals(name)) {
                HbmBinder.bindCompositeId(subnode, entity, mappings, inheritedMetas);
                continue;
            }
            if ("version".equals(name) || "timestamp".equals(name)) {
                HbmBinder.bindVersioningProperty(table, subnode, mappings, name, entity, inheritedMetas);
                continue;
            }
            if ("discriminator".equals(name)) {
                HbmBinder.bindDiscriminatorProperty(table, entity, subnode, mappings);
                continue;
            }
            if (!"cache".equals(name)) continue;
            entity.setCacheConcurrencyStrategy(subnode.attributeValue("usage"));
            entity.setCacheRegionName(subnode.attributeValue("region"));
        }
        entity.createPrimaryKey();
        HbmBinder.createClassProperties(node, entity, mappings, inheritedMetas);
    }

    private static void bindSimpleId(Element idNode, RootClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        String propertyName = idNode.attributeValue("name");
        SimpleValue id = new SimpleValue(entity.getTable());
        entity.setIdentifier(id);
        if (propertyName == null) {
            HbmBinder.bindSimpleValue(idNode, id, false, "id", mappings);
        } else {
            HbmBinder.bindSimpleValue(idNode, id, false, propertyName, mappings);
        }
        if (propertyName == null || !entity.hasPojoRepresentation()) {
            if (!id.isTypeSpecified()) {
                throw new MappingException("must specify an identifier type: " + entity.getEntityName());
            }
        } else {
            id.setTypeUsingReflection(entity.getClassName(), propertyName);
        }
        if (propertyName != null) {
            Property prop = new Property();
            prop.setValue(id);
            HbmBinder.bindProperty(idNode, prop, mappings, inheritedMetas);
            entity.setIdentifierProperty(prop);
        }
        HbmBinder.makeIdentifier(idNode, id, mappings);
    }

    private static void bindCompositeId(Element idNode, RootClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        String propertyName = idNode.attributeValue("name");
        Component id = new Component(entity);
        entity.setIdentifier(id);
        HbmBinder.bindCompositeId(idNode, id, entity, propertyName, mappings, inheritedMetas);
        if (propertyName == null) {
            entity.setEmbeddedIdentifier(id.isEmbedded());
            if (id.isEmbedded()) {
                id.setDynamic(!entity.hasPojoRepresentation());
            }
        } else {
            Property prop = new Property();
            prop.setValue(id);
            HbmBinder.bindProperty(idNode, prop, mappings, inheritedMetas);
            entity.setIdentifierProperty(prop);
        }
        HbmBinder.makeIdentifier(idNode, id, mappings);
        if (!id.isDynamic()) {
            try {
                Class idClass = id.getComponentClass();
                if (idClass != null && !ReflectHelper.overridesEquals(idClass)) {
                    throw new MappingException("composite-id class must override equals(): " + id.getComponentClass().getName());
                }
                if (!ReflectHelper.overridesHashCode(idClass)) {
                    throw new MappingException("composite-id class must override hashCode(): " + id.getComponentClass().getName());
                }
                if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = HbmBinder.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(idClass)) {
                    throw new MappingException("composite-id class must implement Serializable: " + id.getComponentClass().getName());
                }
            }
            catch (MappingException cnfe) {
                log.warn((Object)("Could not perform validation checks for component as the class " + id.getComponentClassName() + " was not found"));
            }
        }
    }

    private static void bindVersioningProperty(Table table, Element subnode, Mappings mappings, String name, RootClass entity, java.util.Map inheritedMetas) {
        String propertyName = subnode.attributeValue("name");
        SimpleValue val = new SimpleValue(table);
        HbmBinder.bindSimpleValue(subnode, val, false, propertyName, mappings);
        if (!val.isTypeSpecified()) {
            val.setTypeName("version".equals(name) ? "integer" : "timestamp");
        }
        Property prop = new Property();
        prop.setValue(val);
        HbmBinder.bindProperty(subnode, prop, mappings, inheritedMetas);
        HbmBinder.makeVersion(subnode, val);
        entity.setVersion(prop);
        entity.addProperty(prop);
    }

    private static void bindDiscriminatorProperty(Table table, RootClass entity, Element subnode, Mappings mappings) {
        SimpleValue discrim = new SimpleValue(table);
        entity.setDiscriminator(discrim);
        HbmBinder.bindSimpleValue(subnode, discrim, false, "class", mappings);
        if (!discrim.isTypeSpecified()) {
            discrim.setTypeName("string");
        }
        entity.setPolymorphic(true);
        if ("true".equals(subnode.attributeValue("force"))) {
            entity.setForceDiscriminator(true);
        }
        if ("false".equals(subnode.attributeValue("insert"))) {
            entity.setDiscriminatorInsertable(false);
        }
    }

    public static void bindClass(Element node, PersistentClass persistentClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute lazyNode = node.attribute("lazy");
        boolean lazy = lazyNode == null ? mappings.isDefaultLazy() : "true".equals(lazyNode.getValue());
        persistentClass.setLazy(lazy);
        String entityName = node.attributeValue("entity-name");
        if (entityName == null) {
            entityName = HbmBinder.getClassName(node.attribute("name"), mappings);
        }
        if (entityName == null) {
            throw new MappingException("Unable to determine entity name");
        }
        persistentClass.setEntityName(entityName);
        HbmBinder.bindPojoRepresentation(node, persistentClass, mappings, inheritedMetas);
        HbmBinder.bindDom4jRepresentation(node, persistentClass, mappings, inheritedMetas);
        HbmBinder.bindMapRepresentation(node, persistentClass, mappings, inheritedMetas);
        HbmBinder.bindPersistentClassCommonValues(node, persistentClass, mappings, inheritedMetas);
    }

    private static void bindPojoRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map metaTags) {
        String className = HbmBinder.getClassName(node.attribute("name"), mappings);
        String proxyName = HbmBinder.getClassName(node.attribute("proxy"), mappings);
        entity.setClassName(className);
        if (proxyName != null) {
            entity.setProxyInterfaceName(proxyName);
            entity.setLazy(true);
        } else if (entity.isLazy()) {
            entity.setProxyInterfaceName(className);
        }
    }

    private static void bindDom4jRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) {
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = StringHelper.unqualify(entity.getEntityName());
        }
        entity.setNodeName(nodeName);
    }

    private static void bindMapRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) {
    }

    private static void bindPersistentClassCommonValues(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute sbuNode;
        Attribute batchNode;
        Attribute discriminatorNode = node.attribute("discriminator-value");
        entity.setDiscriminatorValue(discriminatorNode == null ? entity.getEntityName() : discriminatorNode.getValue());
        Attribute dynamicNode = node.attribute("dynamic-update");
        entity.setDynamicUpdate(dynamicNode == null ? false : "true".equals(dynamicNode.getValue()));
        Attribute insertNode = node.attribute("dynamic-insert");
        entity.setDynamicInsert(insertNode == null ? false : "true".equals(insertNode.getValue()));
        mappings.addImport(entity.getEntityName(), entity.getEntityName());
        if (mappings.isAutoImport() && entity.getEntityName().indexOf(46) > 0) {
            mappings.addImport(entity.getEntityName(), StringHelper.unqualify(entity.getEntityName()));
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            entity.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((sbuNode = node.attribute("select-before-update")) != null) {
            entity.setSelectBeforeUpdate("true".equals(sbuNode.getValue()));
        }
        Attribute olNode = node.attribute("optimistic-lock");
        entity.setOptimisticLockMode(HbmBinder.getOptimisticLockMode(olNode));
        entity.setMetaAttributes(HbmBinder.getMetas(node, inheritedMetas));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                entity.setEntityPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + persisterNode.getValue());
            }
        }
        HbmBinder.handleCustomSQL(node, entity);
        Iterator tables = node.elementIterator("synchronize");
        while (tables.hasNext()) {
            entity.addSynchronizedTable(((Element)tables.next()).attributeValue("table"));
        }
        Attribute abstractNode = node.attribute("abstract");
        if (abstractNode != null) {
            entity.setAbstract("true".equals(abstractNode.getValue()));
        }
    }

    private static void handleCustomSQL(Element node, PersistentClass model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLInsert(element.getText(), callable);
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLDelete(element.getText(), callable);
        }
        if ((element = node.element("sql-update")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLUpdate(element.getText(), callable);
        }
        if ((element = node.element("loader")) != null) {
            model.setLoaderName(element.attributeValue("query-ref"));
        }
    }

    private static void handleCustomSQL(Element node, Join model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLInsert(element.getText(), callable);
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLDelete(element.getText(), callable);
        }
        if ((element = node.element("sql-update")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLUpdate(element.getText(), callable);
        }
    }

    private static void handleCustomSQL(Element node, Collection model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = false;
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLInsert(element.getText(), callable);
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLDelete(element.getText(), callable);
        }
        if ((element = node.element("sql-update")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLUpdate(element.getText(), callable);
        }
        if ((element = node.element("sql-delete-all")) != null) {
            callable = false;
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLDeleteAll(element.getText(), callable);
        }
    }

    private static boolean isCallable(Element e) throws MappingException {
        return HbmBinder.isCallable(e, true);
    }

    private static boolean isCallable(Element element, boolean supportsCallable) throws MappingException {
        Attribute attrib = element.attribute("callable");
        if (attrib != null && "true".equals(attrib.getValue())) {
            if (!supportsCallable) {
                throw new MappingException("callable attribute not supported yet!");
            }
            return true;
        }
        return false;
    }

    public static void bindUnionSubclass(Element node, UnionSubclass unionSubclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute schemaNode;
        HbmBinder.bindClass(node, unionSubclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (unionSubclass.getEntityPersisterClass() == null) {
            unionSubclass.getRootClass().setEntityPersisterClass(class$org$hibernate$persister$entity$UnionSubclassEntityPersister == null ? (class$org$hibernate$persister$entity$UnionSubclassEntityPersister = HbmBinder.class$("org.hibernate.persister.entity.UnionSubclassEntityPersister")) : class$org$hibernate$persister$entity$UnionSubclassEntityPersister);
        }
        String schema = (schemaNode = node.attribute("schema")) == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table mytable = mappings.addDenormalizedTable(schema, catalog, HbmBinder.getClassTableName(unionSubclass, node, mappings), unionSubclass.isAbstract(), HbmBinder.getSubselect(node), unionSubclass.getSuperclass().getTable());
        unionSubclass.setTable(mytable);
        log.info((Object)("Mapping union-subclass: " + unionSubclass.getEntityName() + " -> " + unionSubclass.getTable().getName()));
        HbmBinder.createClassProperties(node, unionSubclass, mappings, inheritedMetas);
    }

    public static void bindSubclass(Element node, Subclass subclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindClass(node, subclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (subclass.getEntityPersisterClass() == null) {
            subclass.getRootClass().setEntityPersisterClass(class$org$hibernate$persister$entity$SingleTableEntityPersister == null ? (class$org$hibernate$persister$entity$SingleTableEntityPersister = HbmBinder.class$("org.hibernate.persister.entity.SingleTableEntityPersister")) : class$org$hibernate$persister$entity$SingleTableEntityPersister);
        }
        log.info((Object)("Mapping subclass: " + subclass.getEntityName() + " -> " + subclass.getTable().getName()));
        HbmBinder.createClassProperties(node, subclass, mappings, inheritedMetas);
    }

    private static String getClassTableName(PersistentClass model, Element node, Mappings mappings) {
        Attribute tableNameNode = node.attribute("table");
        if (tableNameNode == null) {
            return mappings.getNamingStrategy().classToTableName(model.getEntityName());
        }
        return mappings.getNamingStrategy().tableName(tableNameNode.getValue());
    }

    public static void bindJoinedSubclass(Element node, JoinedSubclass joinedSubclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute schemaNode;
        HbmBinder.bindClass(node, joinedSubclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(class$org$hibernate$persister$entity$JoinedSubclassEntityPersister == null ? (class$org$hibernate$persister$entity$JoinedSubclassEntityPersister = HbmBinder.class$("org.hibernate.persister.entity.JoinedSubclassEntityPersister")) : class$org$hibernate$persister$entity$JoinedSubclassEntityPersister);
        }
        String schema = (schemaNode = node.attribute("schema")) == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table mytable = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(joinedSubclass, node, mappings), HbmBinder.getSubselect(node), false);
        joinedSubclass.setTable(mytable);
        log.info((Object)("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName()));
        Element keyNode = node.element("key");
        DependantValue key = new DependantValue(mytable, joinedSubclass.getIdentifier());
        joinedSubclass.setKey(key);
        key.setCascadeDeleteEnabled("cascade".equals(keyNode.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(keyNode, key, false, joinedSubclass.getEntityName(), mappings);
        joinedSubclass.createPrimaryKey();
        joinedSubclass.createForeignKey();
        Attribute chNode = node.attribute("check");
        if (chNode != null) {
            mytable.addCheckConstraint(chNode.getValue());
        }
        HbmBinder.createClassProperties(node, joinedSubclass, mappings, inheritedMetas);
    }

    private static void bindJoin(Element node, Join join, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute nullNode;
        Attribute invNode;
        PersistentClass persistentClass = join.getPersistentClass();
        String path = persistentClass.getEntityName();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table table = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(persistentClass, node, mappings), HbmBinder.getSubselect(node), false);
        join.setTable(table);
        Attribute fetchNode = node.attribute("fetch");
        if (fetchNode != null) {
            join.setSequentialSelect("select".equals(fetchNode.getValue()));
        }
        if ((invNode = node.attribute("inverse")) != null) {
            join.setInverse("true".equals(invNode.getValue()));
        }
        if ((nullNode = node.attribute("optional")) != null) {
            join.setOptional("true".equals(nullNode.getValue()));
        }
        log.info((Object)("Mapping class join: " + persistentClass.getEntityName() + " -> " + join.getTable().getName()));
        Element keyNode = node.element("key");
        DependantValue key = new DependantValue(table, persistentClass.getIdentifier());
        join.setKey(key);
        key.setCascadeDeleteEnabled("cascade".equals(keyNode.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(keyNode, key, false, persistentClass.getEntityName(), mappings);
        join.createPrimaryKey();
        join.createForeignKey();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = subnode.attributeValue("name");
            SimpleValue value = null;
            if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                HbmBinder.bindManyToOne(subnode, value, propertyName, true, mappings);
            } else if ("any".equals(name)) {
                value = new Any(table);
                HbmBinder.bindAny(subnode, (Any)value, true, mappings);
            } else if ("property".equals(name)) {
                value = new SimpleValue(table);
                HbmBinder.bindSimpleValue(subnode, value, true, propertyName, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name)) {
                String subpath = StringHelper.qualify(path, propertyName);
                value = new Component(join);
                HbmBinder.bindComponent(subnode, (Component)value, join.getPersistentClass().getClassName(), propertyName, subpath, true, false, mappings, inheritedMetas);
            }
            if (value == null) continue;
            Property prop = HbmBinder.createProperty(value, propertyName, persistentClass.getEntityName(), subnode, mappings, inheritedMetas);
            prop.setOptional(join.isOptional());
            join.addProperty(prop);
        }
        HbmBinder.handleCustomSQL(node, join);
    }

    public static void bindColumns(Element node, SimpleValue simpleValue, boolean isNullable, boolean autoColumn, String propertyPath, Mappings mappings) throws MappingException {
        Attribute columnAttribute = node.attribute("column");
        if (columnAttribute == null) {
            Iterator iter = node.elementIterator();
            int count = 0;
            Table table = simpleValue.getTable();
            while (iter.hasNext()) {
                Element columnElement = (Element)iter.next();
                if (columnElement.getName().equals("column")) {
                    Column column = new Column();
                    column.setValue(simpleValue);
                    column.setTypeIndex(count++);
                    HbmBinder.bindColumn(columnElement, column, isNullable);
                    column.setName(mappings.getNamingStrategy().columnName(columnElement.attributeValue("name")));
                    if (table != null) {
                        table.addColumn(column);
                    }
                    simpleValue.addColumn(column);
                    HbmBinder.bindIndex(columnElement.attribute("index"), table, column);
                    HbmBinder.bindIndex(node.attribute("index"), table, column);
                    HbmBinder.bindUniqueKey(columnElement.attribute("unique-key"), table, column);
                    continue;
                }
                if (!columnElement.getName().equals("formula")) continue;
                Formula formula = new Formula();
                formula.setFormula(columnElement.getText());
                simpleValue.addFormula(formula);
            }
        } else {
            if (node.elementIterator("column").hasNext()) {
                throw new MappingException("column attribute may not be used together with <column> subelement");
            }
            if (node.elementIterator("formula").hasNext()) {
                throw new MappingException("column attribute may not be used together with <formula> subelement");
            }
            Column column = new Column();
            column.setValue(simpleValue);
            HbmBinder.bindColumn(node, column, isNullable);
            column.setName(mappings.getNamingStrategy().columnName(columnAttribute.getValue()));
            Table table = simpleValue.getTable();
            if (table != null) {
                table.addColumn(column);
            }
            simpleValue.addColumn(column);
            HbmBinder.bindIndex(node.attribute("index"), table, column);
        }
        if (autoColumn && simpleValue.getColumnSpan() == 0) {
            Column col = new Column();
            col.setValue(simpleValue);
            HbmBinder.bindColumn(node, col, isNullable);
            col.setName(mappings.getNamingStrategy().propertyToColumnName(propertyPath));
            simpleValue.getTable().addColumn(col);
            simpleValue.addColumn(col);
        }
    }

    private static void bindIndex(Attribute indexAttribute, Table table, Column column) {
        if (indexAttribute != null && table != null) {
            StringTokenizer tokens = new StringTokenizer(indexAttribute.getValue(), ", ");
            while (tokens.hasMoreTokens()) {
                table.getOrCreateIndex(tokens.nextToken()).addColumn(column);
            }
        }
    }

    private static void bindUniqueKey(Attribute uniqueKeyAttribute, Table table, Column column) {
        if (uniqueKeyAttribute != null && table != null) {
            StringTokenizer tokens = new StringTokenizer(uniqueKeyAttribute.getValue(), ", ");
            while (tokens.hasMoreTokens()) {
                table.getOrCreateUniqueKey(tokens.nextToken()).addColumn(column);
            }
        }
    }

    public static void bindSimpleValue(Element node, SimpleValue simpleValue, boolean isNullable, String path, Mappings mappings) throws MappingException {
        HbmBinder.bindSimpleValueType(node, simpleValue, mappings);
        HbmBinder.bindColumnsOrFormula(node, simpleValue, path, isNullable, mappings);
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            simpleValue.setForeignKeyName(fkNode.getValue());
        }
    }

    private static void bindSimpleValueType(Element node, SimpleValue simpleValue, Mappings mappings) throws MappingException {
        TypeDef typeDef;
        String typeName = null;
        Properties parameters = new Properties();
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode != null) {
            typeName = typeNode.getValue();
        }
        Element typeChild = node.element("type");
        if (typeName == null && typeChild != null) {
            typeName = typeChild.attribute("name").getValue();
            Iterator typeParameters = typeChild.elementIterator("param");
            while (typeParameters.hasNext()) {
                Element paramElement = (Element)typeParameters.next();
                parameters.setProperty(paramElement.attributeValue("name"), paramElement.getTextTrim());
            }
        }
        if ((typeDef = mappings.getTypeDef(typeName)) != null) {
            typeName = typeDef.getTypeClass();
            Properties allParameters = new Properties();
            allParameters.putAll((java.util.Map<?, ?>)typeDef.getParameters());
            allParameters.putAll((java.util.Map<?, ?>)parameters);
            parameters = allParameters;
        }
        if (!parameters.isEmpty()) {
            simpleValue.setTypeParameters(parameters);
        }
        if (typeName != null) {
            simpleValue.setTypeName(typeName);
        }
    }

    public static void bindProperty(Element node, Property property, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        boolean isLazyable;
        String propName = node.attributeValue("name");
        property.setName(propName);
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = propName;
        }
        property.setNodeName(nodeName);
        Attribute accessNode = node.attribute("access");
        if (accessNode != null) {
            property.setPropertyAccessorName(accessNode.getValue());
        } else if (node.getName().equals("properties")) {
            property.setPropertyAccessorName("embedded");
        } else {
            property.setPropertyAccessorName(mappings.getDefaultAccess());
        }
        Attribute cascadeNode = node.attribute("cascade");
        property.setCascade(cascadeNode == null ? mappings.getDefaultCascade() : cascadeNode.getValue());
        Attribute updateNode = node.attribute("update");
        property.setUpdateable(updateNode == null || "true".equals(updateNode.getValue()));
        Attribute insertNode = node.attribute("insert");
        property.setInsertable(insertNode == null || "true".equals(insertNode.getValue()));
        Attribute lockNode = node.attribute("optimistic-lock");
        property.setOptimisticLocked(lockNode == null || "true".equals(lockNode.getValue()));
        boolean bl = isLazyable = "property".equals(node.getName()) || "component".equals(node.getName()) || "many-to-one".equals(node.getName()) || "one-to-one".equals(node.getName()) || "any".equals(node.getName());
        if (isLazyable) {
            Attribute lazyNode = node.attribute("lazy");
            property.setLazy(lazyNode != null && "true".equals(lazyNode.getValue()));
        }
        if (log.isDebugEnabled()) {
            String msg = "Mapped property: " + property.getName();
            String columns = HbmBinder.columns(property.getValue());
            if (columns.length() > 0) {
                msg = msg + " -> " + columns;
            }
            log.debug((Object)msg);
        }
        property.setMetaAttributes(HbmBinder.getMetas(node, inheritedMetas));
    }

    private static String columns(Value val) {
        StringBuffer columns = new StringBuffer();
        Iterator iter = val.getColumnIterator();
        while (iter.hasNext()) {
            columns.append(((Selectable)iter.next()).getText());
            if (!iter.hasNext()) continue;
            columns.append(", ");
        }
        return columns.toString();
    }

    public static void bindCollection(Element node, Collection collection, String className, String path, Mappings mappings) throws MappingException {
        Attribute typeNode;
        String nodeName;
        Attribute batchNode;
        Attribute whereNode;
        Attribute olNode;
        collection.setRole(StringHelper.qualify(className, path));
        Attribute inverseNode = node.attribute("inverse");
        if (inverseNode != null) {
            collection.setInverse("true".equals(inverseNode.getValue()));
        }
        collection.setOptimisticLocked((olNode = node.attribute("optimistic-lock")) == null || "true".equals(olNode.getValue()));
        Attribute orderNode = node.attribute("order-by");
        if (orderNode != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || collection instanceof Bag) {
                collection.setOrderBy(orderNode.getValue());
            } else {
                log.warn((Object)"Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        if ((whereNode = node.attribute("where")) != null) {
            collection.setWhere(whereNode.getValue());
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            collection.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((nodeName = node.attributeValue("node")) == null) {
            nodeName = node.attributeValue("name");
        }
        collection.setNodeName(nodeName);
        String embed = node.attributeValue("embed-xml");
        collection.setEmbedded(embed == null || "true".equals(embed));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                collection.setCollectionPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find collection persister class: " + persisterNode.getValue());
            }
        }
        if ((typeNode = node.attribute("collection-type")) != null) {
            collection.setTypeName(typeNode.getValue());
        }
        HbmBinder.initOuterJoinFetchSetting(node, collection);
        if ("subselect".equals(node.attributeValue("fetch"))) {
            collection.setSubselectLoadable(true);
            collection.getOwner().setSubselectLoadableCollections(true);
        }
        HbmBinder.initLaziness(node, collection, mappings, "true", mappings.isDefaultLazy());
        Element oneToManyNode = node.element("one-to-many");
        if (oneToManyNode != null) {
            OneToMany oneToMany = new OneToMany(collection.getOwner());
            collection.setElement(oneToMany);
            HbmBinder.bindOneToMany(oneToManyNode, oneToMany, mappings);
        } else {
            Attribute tableNode = node.attribute("table");
            String tableName = tableNode != null ? mappings.getNamingStrategy().tableName(tableNode.getValue()) : mappings.getNamingStrategy().propertyToTableName(className, path);
            Attribute schemaNode = node.attribute("schema");
            String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
            Attribute catalogNode = node.attribute("catalog");
            String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
            collection.setCollectionTable(mappings.addTable(schema, catalog, tableName, HbmBinder.getSubselect(node), false));
            log.info((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        Attribute sortedAtt = node.attribute("sort");
        if (sortedAtt == null || sortedAtt.getValue().equals("unsorted")) {
            collection.setSorted(false);
        } else {
            collection.setSorted(true);
            String comparatorClassName = sortedAtt.getValue();
            if (!comparatorClassName.equals("natural")) {
                try {
                    collection.setComparator((Comparator)ReflectHelper.classForName(comparatorClassName).newInstance());
                }
                catch (Exception e) {
                    throw new MappingException("Could not instantiate comparator class: " + comparatorClassName);
                }
            }
        }
        Attribute cascadeAtt = node.attribute("cascade");
        if (cascadeAtt != null && cascadeAtt.getValue().indexOf("delete-orphan") >= 0) {
            collection.setOrphanDelete(true);
        }
        HbmBinder.handleCustomSQL(node, collection);
        if (collection instanceof org.hibernate.mapping.List) {
            mappings.addSecondPass(new ListSecondPass(node, mappings, (org.hibernate.mapping.List)collection));
        } else if (collection instanceof Map) {
            mappings.addSecondPass(new MapSecondPass(node, mappings, (Map)collection));
        } else if (collection instanceof IdentifierCollection) {
            mappings.addSecondPass(new IdentifierCollectionSecondPass(node, mappings, (IdentifierCollection)collection));
        } else {
            mappings.addSecondPass(new CollectionSecondPass(node, mappings, collection));
        }
        Iterator iter = node.elementIterator("filter");
        while (iter.hasNext()) {
            Element filter = (Element)iter.next();
            HbmBinder.parseFilter(filter, collection, mappings);
        }
        Iterator tables = node.elementIterator("synchronize");
        while (tables.hasNext()) {
            collection.getSynchronizedTables().add(((Element)tables.next()).attributeValue("table"));
        }
        Element element = node.element("loader");
        if (element != null) {
            collection.setLoaderName(element.attributeValue("query-ref"));
        }
        collection.setReferencedPropertyName(node.element("key").attributeValue("property-ref"));
    }

    private static void initLaziness(Element node, Fetchable fetchable, Mappings mappings, String proxyVal, boolean defaultLazy) {
        Attribute lazyNode = node.attribute("lazy");
        boolean isLazyTrue = lazyNode == null ? defaultLazy && fetchable.isLazy() : proxyVal.equals(lazyNode.getValue());
        fetchable.setLazy(isLazyTrue);
    }

    private static void bindColumnsOrFormula(Element node, SimpleValue simpleValue, String path, boolean isNullable, Mappings mappings) {
        Attribute formulaNode = node.attribute("formula");
        if (formulaNode != null) {
            Formula f = new Formula();
            f.setFormula(formulaNode.getText());
            simpleValue.addFormula(f);
        } else {
            HbmBinder.bindColumns(node, simpleValue, isNullable, true, path, mappings);
        }
    }

    public static void bindManyToOne(Element node, ManyToOne manyToOne, String path, boolean isNullable, Mappings mappings) throws MappingException {
        HbmBinder.bindColumnsOrFormula(node, manyToOne, path, isNullable, mappings);
        HbmBinder.initOuterJoinFetchSetting(node, manyToOne);
        HbmBinder.initLaziness(node, manyToOne, mappings, "proxy", true);
        Attribute ukName = node.attribute("property-ref");
        if (ukName != null) {
            manyToOne.setReferencedPropertyName(ukName.getValue());
        }
        manyToOne.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
        String embed = node.attributeValue("embed-xml");
        manyToOne.setEmbedded(embed == null || "true".equals(embed));
        String notFound = node.attributeValue("not-found");
        manyToOne.setIgnoreNotFound("ignore".equals(notFound));
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            manyToOne.setForeignKeyName(fkNode.getValue());
        }
    }

    public static void bindAny(Element node, Any any, boolean isNullable, Mappings mappings) throws MappingException {
        any.setIdentifierType(HbmBinder.getTypeFromXML(node));
        Attribute metaAttribute = node.attribute("meta-type");
        if (metaAttribute != null) {
            any.setMetaType(metaAttribute.getValue());
            Iterator iter = node.elementIterator("meta-value");
            if (iter.hasNext()) {
                HashMap<Object, String> values = new HashMap<Object, String>();
                Type metaType = TypeFactory.heuristicType(any.getMetaType());
                while (iter.hasNext()) {
                    Element metaValue = (Element)iter.next();
                    try {
                        Object value = ((DiscriminatorType)metaType).stringToObject(metaValue.attributeValue("value"));
                        String entityName = HbmBinder.getClassName(metaValue.attribute("class"), mappings);
                        values.put(value, entityName);
                    }
                    catch (ClassCastException cce) {
                        throw new MappingException("meta-type was not a DiscriminatorType: " + metaType.getName());
                    }
                    catch (Exception e) {
                        throw new MappingException("could not interpret meta-value", e);
                    }
                }
                any.setMetaValues(values);
            }
        }
        HbmBinder.bindColumns(node, any, isNullable, false, null, mappings);
    }

    public static void bindOneToOne(Element node, OneToOne oneToOne, boolean isNullable, Mappings mappings) throws MappingException {
        Attribute ukName;
        HbmBinder.bindColumns(node, oneToOne, isNullable, false, null, mappings);
        Attribute constrNode = node.attribute("constrained");
        boolean constrained = constrNode != null && constrNode.getValue().equals("true");
        oneToOne.setConstrained(constrained);
        oneToOne.setForeignKeyType(constrained ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        HbmBinder.initOuterJoinFetchSetting(node, oneToOne);
        HbmBinder.initLaziness(node, oneToOne, mappings, "proxy", true);
        oneToOne.setEmbedded("true".equals(node.attributeValue("embed-xml")));
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            oneToOne.setForeignKeyName(fkNode.getValue());
        }
        if ((ukName = node.attribute("property-ref")) != null) {
            oneToOne.setReferencedPropertyName(ukName.getValue());
        }
        oneToOne.setPropertyName(node.attributeValue("name"));
        oneToOne.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
    }

    public static void bindOneToMany(Element node, OneToMany oneToMany, Mappings mappings) throws MappingException {
        oneToMany.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
        String embed = node.attributeValue("embed-xml");
        oneToMany.setEmbedded(embed == null || "true".equals(embed));
        String notFound = node.attributeValue("not-found");
        oneToMany.setIgnoreNotFound("ignore".equals(notFound));
    }

    public static void bindColumn(Element node, Column column, boolean isNullable) {
        Attribute nullNode;
        Attribute precNode;
        Attribute scalNode;
        Attribute lengthNode = node.attribute("length");
        if (lengthNode != null) {
            column.setLength(Integer.parseInt(lengthNode.getValue()));
        }
        if ((scalNode = node.attribute("scale")) != null) {
            column.setScale(Integer.parseInt(scalNode.getValue()));
        }
        if ((precNode = node.attribute("precision")) != null) {
            column.setPrecision(Integer.parseInt(precNode.getValue()));
        }
        column.setNullable((nullNode = node.attribute("not-null")) == null ? isNullable : nullNode.getValue().equals("false"));
        Attribute unqNode = node.attribute("unique");
        if (unqNode != null) {
            column.setUnique(unqNode.getValue().equals("true"));
        }
        column.setCheckConstraint(node.attributeValue("check"));
        Attribute typeNode = node.attribute("sql-type");
        if (typeNode != null) {
            column.setSqlType(typeNode.getValue());
        }
    }

    public static void bindArray(Element node, Array array, String prefix, String path, Mappings mappings) throws MappingException {
        HbmBinder.bindCollection(node, array, prefix, path, mappings);
        Attribute att = node.attribute("element-class");
        if (att != null) {
            array.setElementClassName(HbmBinder.getClassName(att, mappings));
        }
    }

    private static Class reflectedPropertyClass(String className, String propertyName) throws MappingException {
        if (className == null) {
            return null;
        }
        return ReflectHelper.reflectedPropertyClass(className, propertyName);
    }

    public static void bindComposite(Element node, Component component, String path, boolean isNullable, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindComponent(node, component, null, null, path, isNullable, false, mappings, inheritedMetas);
    }

    public static void bindCompositeId(Element node, Component component, PersistentClass persistentClass, String propertyName, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        component.setKey(true);
        String path = StringHelper.qualify(persistentClass.getEntityName(), propertyName == null ? "id" : propertyName);
        HbmBinder.bindComponent(node, component, persistentClass.getClassName(), propertyName, path, false, node.attribute("class") == null && propertyName == null, mappings, inheritedMetas);
    }

    public static void bindComponent(Element node, Component component, String ownerClassName, String parentProperty, String path, boolean isNullable, boolean isEmbedded, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        component.setEmbedded(isEmbedded);
        component.setMetaAttributes(HbmBinder.getMetas(node, inheritedMetas));
        Attribute classNode = node.attribute("class");
        if (classNode != null) {
            component.setComponentClassName(HbmBinder.getClassName(classNode, mappings));
        } else if ("dynamic-component".equals(node.getName())) {
            component.setDynamic(true);
        } else if (isEmbedded) {
            if (component.getOwner().hasPojoRepresentation()) {
                component.setComponentClassName(component.getOwner().getClassName());
            } else {
                component.setDynamic(true);
            }
        } else if (component.getOwner().hasPojoRepresentation()) {
            Class reflectedClass = HbmBinder.reflectedPropertyClass(ownerClassName, parentProperty);
            if (reflectedClass != null) {
                component.setComponentClassName(reflectedClass.getName());
            }
        } else {
            component.setDynamic(true);
        }
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = node.attributeValue("name");
        }
        if (nodeName == null) {
            nodeName = component.getOwner().getNodeName();
        }
        component.setNodeName(nodeName);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = HbmBinder.getPropertyName(subnode);
            String subpath = propertyName == null ? null : StringHelper.qualify(path, propertyName);
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, subpath, component.getOwner(), mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name) || "key-many-to-one".equals(name)) {
                value = new ManyToOne(component.getTable());
                HbmBinder.bindManyToOne(subnode, value, propertyName, isNullable, mappings);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(component.getTable(), component.getOwner());
                HbmBinder.bindOneToOne(subnode, (OneToOne)value, isNullable, mappings);
            } else if ("any".equals(name)) {
                value = new Any(component.getTable());
                HbmBinder.bindAny(subnode, (Any)value, isNullable, mappings);
            } else if ("property".equals(name) || "key-property".equals(name)) {
                value = new SimpleValue(component.getTable());
                HbmBinder.bindSimpleValue(subnode, value, isNullable, propertyName, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name) || "nested-composite-element".equals(name)) {
                value = new Component(component);
                HbmBinder.bindComponent(subnode, (Component)value, component.getComponentClassName(), propertyName, subpath, isNullable, isEmbedded, mappings, inheritedMetas);
            } else if ("parent".equals(name)) {
                component.setParentProperty(propertyName);
            }
            if (value == null) continue;
            component.addProperty(HbmBinder.createProperty(value, propertyName, component.getComponentClassName(), subnode, mappings, inheritedMetas));
        }
        if ("true".equals(node.attributeValue("unique"))) {
            iter = component.getColumnIterator();
            ArrayList cols = new ArrayList();
            while (iter.hasNext()) {
                cols.add(iter.next());
            }
            component.getOwner().getTable().createUniqueKey(cols);
        }
    }

    private static String getTypeFromXML(Element node) throws MappingException {
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode == null) {
            return null;
        }
        return typeNode.getValue();
    }

    private static void initOuterJoinFetchSetting(Element node, Fetchable model) {
        FetchMode fetchStyle;
        Attribute fetchNode = node.attribute("fetch");
        boolean lazy = true;
        if (fetchNode == null) {
            Attribute jfNode = node.attribute("outer-join");
            if (jfNode == null) {
                if ("many-to-many".equals(node.getName())) {
                    lazy = false;
                    fetchStyle = FetchMode.JOIN;
                } else {
                    fetchStyle = "one-to-one".equals(node.getName()) ? ((lazy = ((OneToOne)model).isConstrained()) ? FetchMode.DEFAULT : FetchMode.JOIN) : FetchMode.DEFAULT;
                }
            } else {
                boolean join;
                String eoj = jfNode.getValue();
                fetchStyle = "auto".equals(eoj) ? FetchMode.DEFAULT : ((join = "true".equals(eoj)) ? FetchMode.JOIN : FetchMode.SELECT);
            }
        } else {
            boolean join = "join".equals(fetchNode.getValue());
            fetchStyle = join ? FetchMode.JOIN : FetchMode.SELECT;
        }
        model.setFetchMode(fetchStyle);
        model.setLazy(lazy);
    }

    private static void makeIdentifier(Element node, SimpleValue model, Mappings mappings) {
        Element subnode = node.element("generator");
        if (subnode != null) {
            model.setIdentifierGeneratorStrategy(subnode.attributeValue("class"));
            Properties params = new Properties();
            if (mappings.getSchemaName() != null) {
                params.setProperty("schema", mappings.getSchemaName());
            }
            if (mappings.getCatalogName() != null) {
                params.setProperty("catalog", mappings.getCatalogName());
            }
            Iterator iter = subnode.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getText());
            }
            model.setIdentifierGeneratorProperties(params);
        }
        model.getTable().setIdentifierValue(model);
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else if ("assigned".equals(model.getIdentifierGeneratorStrategy())) {
            model.setNullValue("undefined");
        } else {
            model.setNullValue(null);
        }
    }

    private static final void makeVersion(Element node, SimpleValue model) {
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else {
            model.setNullValue("undefined");
        }
    }

    protected static void createClassProperties(Element node, PersistentClass persistentClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        String entityName = persistentClass.getEntityName();
        Table table = persistentClass.getTable();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = subnode.attributeValue("name");
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, propertyName, persistentClass, mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                HbmBinder.bindManyToOne(subnode, value, propertyName, true, mappings);
            } else if ("any".equals(name)) {
                value = new Any(table);
                HbmBinder.bindAny(subnode, (Any)value, true, mappings);
            } else if ("one-to-one".equals(name)) {
                OneToOne oneToOne = new OneToOne(table, persistentClass);
                HbmBinder.bindOneToOne(subnode, oneToOne, true, mappings);
                value = oneToOne;
            } else if ("property".equals(name)) {
                value = new SimpleValue(table);
                HbmBinder.bindSimpleValue(subnode, value, true, propertyName, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name) || "properties".equals(name)) {
                String subpath = StringHelper.qualify(entityName, propertyName);
                value = new Component(persistentClass);
                HbmBinder.bindComponent(subnode, (Component)value, persistentClass.getClassName(), propertyName, subpath, true, "properties".equals(name), mappings, inheritedMetas);
            } else if ("query-list".equals(name)) {
                value = new QueryList(table);
                ((QueryList)value).setQueryName(subnode.attributeValue("query-ref"));
            } else if ("join".equals(name)) {
                Join join = new Join();
                join.setPersistentClass(persistentClass);
                HbmBinder.bindJoin(subnode, join, mappings, inheritedMetas);
                persistentClass.addJoin(join);
            } else if ("subclass".equals(name)) {
                HbmBinder.handleSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("joined-subclass".equals(name)) {
                HbmBinder.handleJoinedSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("union-subclass".equals(name)) {
                HbmBinder.handleUnionSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("filter".equals(name)) {
                HbmBinder.parseFilter(subnode, persistentClass, mappings);
            }
            if (value == null) continue;
            persistentClass.addProperty(HbmBinder.createProperty(value, propertyName, persistentClass.getClassName(), subnode, mappings, inheritedMetas));
        }
    }

    private static Property createProperty(Value value, String propertyName, String className, Element subnode, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Collection coll;
        String propertyRef;
        value.setTypeUsingReflection(className, propertyName);
        if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            String propertyRef2 = toOne.getReferencedPropertyName();
            if (propertyRef2 != null) {
                mappings.addUniquePropertyReference(toOne.getReferencedEntityName(), propertyRef2);
            }
        } else if (value instanceof Collection && (propertyRef = (coll = (Collection)value).getReferencedPropertyName()) != null) {
            mappings.addPropertyReference(coll.getOwnerEntityName(), propertyRef);
        }
        value.createForeignKey();
        Property prop = new Property();
        prop.setValue(value);
        HbmBinder.bindProperty(subnode, prop, mappings, inheritedMetas);
        return prop;
    }

    private static void handleUnionSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        UnionSubclass subclass = new UnionSubclass(model);
        HbmBinder.bindUnionSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    private static void handleJoinedSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        JoinedSubclass subclass = new JoinedSubclass(model);
        HbmBinder.bindJoinedSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    private static void handleSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        SingleTableSubclass subclass = new SingleTableSubclass(model);
        HbmBinder.bindSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    public static void bindListSecondPass(Element node, org.hibernate.mapping.List list, java.util.Map classes, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, list, classes, mappings, inheritedMetas);
        Element subnode = node.element("list-index");
        if (subnode == null) {
            subnode = node.element("index");
        }
        SimpleValue iv = new SimpleValue(list.getCollectionTable());
        HbmBinder.bindSimpleValue(subnode, iv, list.isOneToMany(), "idx", mappings);
        iv.setTypeName("integer");
        list.setIndex(iv);
        String baseIndex = subnode.attributeValue("base");
        if (baseIndex != null) {
            list.setBaseIndex(Integer.parseInt(baseIndex));
        }
        list.setIndexNodeName(subnode.attributeValue("node"));
        if (list.isOneToMany() && !list.getKey().isNullable() && !list.isInverse()) {
            String entityName = ((OneToMany)list.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + node.attributeValue("name") + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            ib.setCollectionRole(list.getRole());
            ib.setValue(list.getIndex());
            referenced.addProperty(ib);
        }
    }

    public static void bindIdentifierCollectionSecondPass(Element node, IdentifierCollection collection, java.util.Map persistentClasses, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, collection, persistentClasses, mappings, inheritedMetas);
        Element subnode = node.element("collection-id");
        SimpleValue id = new SimpleValue(collection.getCollectionTable());
        HbmBinder.bindSimpleValue(subnode, id, false, "id", mappings);
        collection.setIdentifier(id);
        HbmBinder.makeIdentifier(subnode, id, mappings);
    }

    public static void bindMapSecondPass(Element node, Map map, java.util.Map classes, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, map, classes, mappings, inheritedMetas);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("index".equals(name) || "map-key".equals(name)) {
                SimpleValue value = new SimpleValue(map.getCollectionTable());
                HbmBinder.bindSimpleValue(subnode, value, map.isOneToMany(), "idx", mappings);
                if (!value.isTypeSpecified()) {
                    throw new MappingException("map index element must specify a type: " + map.getRole());
                }
                map.setIndex(value);
                map.setIndexNodeName(subnode.attributeValue("node"));
                continue;
            }
            if ("index-many-to-many".equals(name) || "map-key-many-to-many".equals(name)) {
                ManyToOne mto = new ManyToOne(map.getCollectionTable());
                HbmBinder.bindManyToOne(subnode, mto, "idx", map.isOneToMany(), mappings);
                map.setIndex(mto);
                continue;
            }
            if ("composite-index".equals(name) || "composite-map-key".equals(name)) {
                Component component = new Component(map);
                HbmBinder.bindComposite(subnode, component, map.getRole() + ".index", map.isOneToMany(), mappings, inheritedMetas);
                map.setIndex(component);
                continue;
            }
            if (!"index-many-to-any".equals(name)) continue;
            Any any = new Any(map.getCollectionTable());
            HbmBinder.bindAny(subnode, any, map.isOneToMany(), mappings);
            map.setIndex(any);
        }
        boolean indexIsFormula = false;
        Iterator colIter = map.getIndex().getColumnIterator();
        while (colIter.hasNext()) {
            if (!((Selectable)colIter.next()).isFormula()) continue;
            indexIsFormula = true;
        }
        if (map.isOneToMany() && !map.getKey().isNullable() && !map.isInverse() && !indexIsFormula) {
            String entityName = ((OneToMany)map.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + node.attributeValue("name") + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            ib.setCollectionRole(map.getRole());
            ib.setValue(map.getIndex());
            referenced.addProperty(ib);
        }
    }

    public static void bindCollectionSecondPass(Element node, Collection collection, java.util.Map persistentClasses, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute chNode;
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(persistentClass);
            collection.setCollectionTable(persistentClass.getTable());
            log.info((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        if ((chNode = node.attribute("check")) != null) {
            collection.getCollectionTable().addCheckConstraint(chNode.getValue());
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            String nodeName;
            SimpleValue element;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("key".equals(name)) {
                String propRef = collection.getReferencedPropertyName();
                KeyValue keyVal = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propRef).getValue();
                DependantValue key = new DependantValue(collection.getCollectionTable(), keyVal);
                key.setCascadeDeleteEnabled("cascade".equals(subnode.attributeValue("on-delete")));
                HbmBinder.bindSimpleValue(subnode, key, collection.isOneToMany(), "id", mappings);
                collection.setKey(key);
                Attribute notNull = subnode.attribute("not-null");
                key.setNullable(notNull == null || notNull.getValue().equals("false"));
                Attribute updateable = subnode.attribute("update");
                key.setUpdateable(updateable == null || updateable.getValue().equals("true"));
            } else if ("element".equals(name)) {
                SimpleValue elt = new SimpleValue(collection.getCollectionTable());
                collection.setElement(elt);
                HbmBinder.bindSimpleValue(subnode, elt, true, "elt", mappings);
            } else if ("many-to-many".equals(name)) {
                element = new ManyToOne(collection.getCollectionTable());
                collection.setElement(element);
                HbmBinder.bindManyToOne(subnode, element, "elt", false, mappings);
                HbmBinder.bindManyToManyFilters(collection, subnode, mappings);
            } else if ("composite-element".equals(name)) {
                element = new Component(collection);
                collection.setElement(element);
                HbmBinder.bindComposite(subnode, (Component)element, collection.getRole() + ".element", true, mappings, inheritedMetas);
            } else if ("many-to-any".equals(name)) {
                element = new Any(collection.getCollectionTable());
                collection.setElement(element);
                HbmBinder.bindAny(subnode, (Any)element, true, mappings);
            } else if ("cache".equals(name)) {
                collection.setCacheConcurrencyStrategy(subnode.attributeValue("usage"));
                collection.setCacheRegionName(subnode.attributeValue("region"));
            }
            if ((nodeName = subnode.attributeValue("node")) == null) continue;
            collection.setElementNodeName(nodeName);
        }
        if (collection.isOneToMany() && !collection.isInverse() && !collection.getKey().isNullable()) {
            String entityName = ((OneToMany)collection.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + node.attributeValue("name") + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collection.getRole());
            prop.setValue(collection.getKey());
            referenced.addProperty(prop);
        }
    }

    private static void bindManyToManyFilters(Collection collection, Element manyToManyNode, Mappings model) throws MappingException {
        Attribute where = manyToManyNode.attribute("where");
        String whereCondition = where == null ? null : where.getValue();
        collection.setManyToManyWhere(whereCondition);
        Iterator filters = manyToManyNode.elementIterator("filter");
        if ((filters.hasNext() || whereCondition != null) && collection.getFetchMode() == FetchMode.JOIN && collection.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("many-to-many defining filter or where without join fetching not valid within collection using join fetching [" + collection.getRole() + "]");
        }
        while (filters.hasNext()) {
            Element filterElement = (Element)filters.next();
            String name = filterElement.attributeValue("name");
            String condition = filterElement.getTextTrim();
            if (StringHelper.isEmpty(condition)) {
                condition = filterElement.attributeValue("condition");
            }
            if (StringHelper.isEmpty(condition)) {
                condition = model.getFilterDefinition(name).getDefaultFilterCondition();
            }
            if (condition == null) {
                throw new MappingException("no filter condition found for filter: " + name);
            }
            log.debug((Object)("Applying many-to-many filter [" + name + "] as [" + condition + "] to role [" + collection.getRole() + "]"));
            collection.addManyToManyFilter(name, condition);
        }
    }

    private static final LockMode getLockMode(String lockMode) {
        if (lockMode == null || "read".equals(lockMode)) {
            return LockMode.READ;
        }
        if ("none".equals(lockMode)) {
            return LockMode.NONE;
        }
        if ("upgrade".equals(lockMode)) {
            return LockMode.UPGRADE;
        }
        if ("upgrade-nowait".equals(lockMode)) {
            return LockMode.UPGRADE_NOWAIT;
        }
        if ("upgrade-nowait".equals(lockMode)) {
            return LockMode.UPGRADE_NOWAIT;
        }
        if ("write".equals(lockMode)) {
            return LockMode.WRITE;
        }
        throw new MappingException("unknown lockmode");
    }

    private static final FlushMode getFlushMode(String flushMode) {
        if (flushMode == null) {
            return null;
        }
        if ("auto".equals(flushMode)) {
            return FlushMode.AUTO;
        }
        if ("commit".equals(flushMode)) {
            return FlushMode.COMMIT;
        }
        if ("never".equals(flushMode)) {
            return FlushMode.NEVER;
        }
        if ("always".equals(flushMode)) {
            return FlushMode.ALWAYS;
        }
        throw new MappingException("unknown flushmode");
    }

    private static void bindNamedQuery(Element queryElem, Mappings mappings) {
        String qname = queryElem.attributeValue("name");
        String query = queryElem.getText();
        log.debug((Object)("Named query: " + qname + " -> " + query));
        boolean cacheable = "true".equals(queryElem.attributeValue("cacheable"));
        String region = queryElem.attributeValue("cache-region");
        Attribute tAtt = queryElem.attribute("timeout");
        Integer timeout = tAtt == null ? null : new Integer(tAtt.getValue());
        Attribute fsAtt = queryElem.attribute("fetch-size");
        Integer fetchSize = fsAtt == null ? null : new Integer(fsAtt.getValue());
        NamedQueryDefinition namedQuery = new NamedQueryDefinition(query, cacheable, region, timeout, fetchSize, HbmBinder.getFlushMode(queryElem.attributeValue("flush-mode")));
        mappings.addQuery(qname, namedQuery);
    }

    private static void bindReturn(Element returnElem, List queryReturns, Mappings mappings) {
        String alias = returnElem.attributeValue("alias");
        String entityName = HbmBinder.getEntityName(returnElem, mappings);
        if (entityName == null) {
            throw new MappingException("<return alias='" + alias + "'> must specify either a class or entity-name");
        }
        LockMode lockMode = HbmBinder.getLockMode(returnElem.attributeValue("lock-mode"));
        java.util.Map propertyResults = HbmBinder.bindPropertyResults(alias, returnElem);
        queryReturns.add(new SQLQueryRootReturn(alias, entityName, propertyResults, lockMode));
    }

    private static java.util.Map bindPropertyResults(String alias, Element returnElement) {
        HashMap<String, String[]> propertyresults = new HashMap<String, String[]>();
        Element discriminatorResult = returnElement.element("return-discriminator");
        if (discriminatorResult != null) {
            ArrayList resultColumns = HbmBinder.getResultColumns(discriminatorResult);
            propertyresults.put("class", ArrayHelper.toStringArray(resultColumns));
        }
        Iterator iterator = returnElement.elementIterator("return-property");
        while (iterator.hasNext()) {
            Element propertyresult = (Element)iterator.next();
            String name = propertyresult.attributeValue("name");
            if ("class".equals(name)) {
                throw new MappingException("class is not a valid property name to use in a <return-property>. Use <return-discriminator> instead.");
            }
            ArrayList allResultColumns = HbmBinder.getResultColumns(propertyresult);
            if (allResultColumns.isEmpty()) {
                throw new MappingException("return-property for alias " + alias + " must specify at least one column or return-column name");
            }
            String[] existing = propertyresults.put(name, ArrayHelper.toStringArray(allResultColumns));
            if (existing == null) continue;
            throw new MappingException("duplicate return-property for property " + name + " on alias " + alias);
        }
        return propertyresults.isEmpty() ? CollectionHelper.EMPTY_MAP : propertyresults;
    }

    private static ArrayList getResultColumns(Element propertyresult) {
        String column = propertyresult.attributeValue("column");
        ArrayList<String> allResultColumns = new ArrayList<String>();
        if (column != null) {
            allResultColumns.add(column);
        }
        Iterator resultColumns = propertyresult.elementIterator("return-column");
        while (resultColumns.hasNext()) {
            Element element = (Element)resultColumns.next();
            allResultColumns.add(element.attributeValue("name"));
        }
        return allResultColumns;
    }

    private static void bindReturnJoin(Element returnElem, List queryReturns, Mappings mappings) {
        String alias = returnElem.attributeValue("alias");
        String roleAttribute = returnElem.attributeValue("property");
        LockMode lockMode = HbmBinder.getLockMode(returnElem.attributeValue("lock-mode"));
        int dot = roleAttribute.lastIndexOf(46);
        if (dot == -1) {
            throw new MappingException("Role attribute for sql query return [alias=" + alias + "] not formatted correctly {owningAlias.propertyName}");
        }
        String roleOwnerAlias = roleAttribute.substring(0, dot);
        String roleProperty = roleAttribute.substring(dot + 1);
        queryReturns.add(new SQLQueryJoinReturn(alias, roleOwnerAlias, roleProperty, CollectionHelper.EMPTY_MAP, lockMode));
    }

    private static void bindLoadCollection(Element returnElem, List queryReturns, Mappings mappings) {
        String alias = returnElem.attributeValue("alias");
        String collectionAttribute = returnElem.attributeValue("role");
        LockMode lockMode = HbmBinder.getLockMode(returnElem.attributeValue("lock-mode"));
        int dot = collectionAttribute.lastIndexOf(46);
        if (dot == -1) {
            throw new MappingException("Collection attribute for sql query return [alias=" + alias + "] not formatted correctly {OwnerClassName.propertyName}");
        }
        String ownerClassName = HbmBinder.getClassName(collectionAttribute.substring(0, dot), mappings);
        String ownerPropertyName = collectionAttribute.substring(dot + 1);
        queryReturns.add(new SQLQueryCollectionReturn(alias, ownerClassName, ownerPropertyName, CollectionHelper.EMPTY_MAP, lockMode));
    }

    private static void bindNamedSQLQuery(Element queryElem, Mappings mappings) {
        String queryName = queryElem.attribute("name").getValue();
        ArrayList<SQLQueryScalarReturn> scalarQueryReturns = new ArrayList<SQLQueryScalarReturn>();
        Iterator returns = queryElem.elementIterator("return-scalar");
        while (returns.hasNext()) {
            Element returnElem = (Element)returns.next();
            String column = returnElem.attributeValue("column");
            Type type = TypeFactory.heuristicType(HbmBinder.getTypeFromXML(returnElem));
            if (type == null) {
                throw new MappingException("could not determine type " + type);
            }
            scalarQueryReturns.add(new SQLQueryScalarReturn(column, type));
        }
        ArrayList queryReturns = new ArrayList();
        returns = queryElem.elementIterator();
        while (returns.hasNext()) {
            Element returnElem = (Element)returns.next();
            String name = returnElem.getName();
            if ("return".equals(name)) {
                HbmBinder.bindReturn(returnElem, queryReturns, mappings);
                continue;
            }
            if ("return-join".equals(name)) {
                HbmBinder.bindReturnJoin(returnElem, queryReturns, mappings);
                continue;
            }
            if (!"load-collection".equals(name)) continue;
            HbmBinder.bindLoadCollection(returnElem, queryReturns, mappings);
        }
        boolean cacheable = "true".equals(queryElem.attributeValue("cacheable"));
        String region = queryElem.attributeValue("cache-region");
        Attribute tAtt = queryElem.attribute("timeout");
        Integer timeout = tAtt == null ? null : new Integer(tAtt.getValue());
        Attribute fsAtt = queryElem.attribute("fetch-size");
        Integer fetchSize = fsAtt == null ? null : new Integer(fsAtt.getValue());
        ArrayList<String> synchronizedTables = new ArrayList<String>();
        Iterator tables = queryElem.elementIterator("synchronize");
        while (tables.hasNext()) {
            synchronizedTables.add(((Element)tables.next()).attributeValue("table"));
        }
        boolean callable = "true".equals(queryElem.attributeValue("callable"));
        NamedSQLQueryDefinition namedQuery = new NamedSQLQueryDefinition(queryElem.getTextTrim(), queryReturns.toArray(new SQLQueryReturn[0]), scalarQueryReturns.toArray(new SQLQueryScalarReturn[0]), synchronizedTables, cacheable, region, timeout, fetchSize, HbmBinder.getFlushMode(queryElem.attributeValue("flush-mode")), callable);
        log.debug((Object)("Named SQL query: " + queryName + " -> " + namedQuery.getQueryString()));
        mappings.addSQLQuery(queryName, namedQuery);
    }

    private static String getPropertyName(Element node) {
        return node.attributeValue("name");
    }

    private static PersistentClass getSuperclass(Mappings mappings, Element subnode) throws MappingException {
        String superClass = HbmBinder.getClassName(subnode.attributeValue("extends"), mappings);
        PersistentClass superModel = mappings.getClass(superClass);
        if (superModel == null) {
            throw new MappingException("Cannot extend unmapped class " + superClass);
        }
        return superModel;
    }

    private static int getOptimisticLockMode(Attribute olAtt) throws MappingException {
        if (olAtt == null) {
            return 0;
        }
        String olMode = olAtt.getValue();
        if (olMode == null || "version".equals(olMode)) {
            return 0;
        }
        if ("dirty".equals(olMode)) {
            return 1;
        }
        if ("all".equals(olMode)) {
            return 2;
        }
        if ("none".equals(olMode)) {
            return -1;
        }
        throw new MappingException("Unsupported optimistic-lock style: " + olMode);
    }

    private static final java.util.Map getMetas(Element node, java.util.Map inheritedMeta) {
        return HbmBinder.getMetas(node, inheritedMeta, false);
    }

    private static final java.util.Map getMetas(Element node, java.util.Map inheritedMeta, boolean onlyInheritable) {
        HashMap<String, MetaAttribute> map = new HashMap<String, MetaAttribute>();
        map.putAll(inheritedMeta);
        Iterator iter = node.elementIterator("meta");
        while (iter.hasNext()) {
            Element metaNode = (Element)iter.next();
            boolean inheritable = Boolean.valueOf(metaNode.attributeValue("inherit"));
            if (onlyInheritable & !inheritable) continue;
            String name = metaNode.attributeValue("attribute");
            MetaAttribute meta = (MetaAttribute)map.get(name);
            if (meta == null) {
                meta = new MetaAttribute(name);
                map.put(name, meta);
            }
            meta.addValue(metaNode.getText());
        }
        return map;
    }

    private static String getEntityName(Element elem, Mappings model) {
        String entityName = elem.attributeValue("entity-name");
        return entityName == null ? HbmBinder.getClassName(elem.attribute("class"), model) : entityName;
    }

    private static String getClassName(Attribute att, Mappings model) {
        if (att == null) {
            return null;
        }
        return HbmBinder.getClassName(att.getValue(), model);
    }

    private static String getClassName(String unqualifiedName, Mappings model) {
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && model.getDefaultPackage() != null) {
            return model.getDefaultPackage() + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    private static void parseFilterDef(Element element, Mappings mappings) {
        String name = element.attributeValue("name");
        log.debug((Object)("Parsing filter-def [" + name + "]"));
        FilterDefinition def = new FilterDefinition(name);
        Iterator params = element.elementIterator("filter-param");
        while (params.hasNext()) {
            Element param = (Element)params.next();
            String paramName = param.attributeValue("name");
            String paramType = param.attributeValue("type");
            log.debug((Object)("adding filter parameter : " + paramName + " -> " + paramType));
            Type heuristicType = TypeFactory.heuristicType(paramType);
            log.debug((Object)("parameter heuristic type : " + heuristicType));
            def.addParameterType(paramName, heuristicType);
        }
        String condition = element.getTextTrim();
        if (StringHelper.isEmpty(condition)) {
            condition = element.attributeValue("condition");
        }
        def.setDefaultFilterCondition(condition);
        log.debug((Object)("Parsed filter-def [" + name + "]"));
        mappings.addFilterDefinition(def);
    }

    private static void parseFilter(Element filterElement, Filterable filterable, Mappings model) {
        String name = filterElement.attributeValue("name");
        String condition = filterElement.getTextTrim();
        if (StringHelper.isEmpty(condition)) {
            condition = filterElement.attributeValue("condition");
        }
        if (StringHelper.isEmpty(condition)) {
            condition = model.getFilterDefinition(name).getDefaultFilterCondition();
        }
        if (condition == null) {
            throw new MappingException("no filter condition found for filter: " + name);
        }
        log.debug((Object)("Applying filter [" + name + "] as [" + condition + "]"));
        filterable.addFilter(name, condition);
    }

    private static String getSubselect(Element element) {
        String subselect = element.attributeValue("subselect");
        if (subselect != null) {
            return subselect;
        }
        Element subselectElement = element.element("subselect");
        return subselectElement == null ? null : subselectElement.getText();
    }

    public static List getExtendsNeeded(Document doc, Mappings mappings) {
        ArrayList<String> extendz = new ArrayList<String>();
        Iterator[] subclasses = new Iterator[3];
        Element hmNode = doc.getRootElement();
        Attribute packNode = hmNode.attribute("package");
        if (packNode != null) {
            mappings.setDefaultPackage(packNode.getValue());
        }
        subclasses[0] = hmNode.elementIterator("subclass");
        subclasses[1] = hmNode.elementIterator("joined-subclass");
        subclasses[2] = hmNode.elementIterator("union-subclass");
        JoinedIterator iterator = new JoinedIterator(subclasses);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String superClass = HbmBinder.getClassName(element.attributeValue("extends"), mappings);
            if (mappings.getClass(superClass) != null) continue;
            extendz.add(superClass);
        }
        if (!extendz.isEmpty()) {
            ArrayList names = new ArrayList();
            HbmBinder.findClassNames(mappings, hmNode, names);
            HashSet set = new HashSet(extendz);
            set.removeAll(names);
            extendz.clear();
            extendz.addAll(set);
        }
        return extendz;
    }

    private static void findClassNames(Mappings mappings, Element startNode, List names) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            String entityName = element.attributeValue("entity-name");
            if (entityName == null) {
                entityName = HbmBinder.getClassName(element.attribute("name"), mappings);
            }
            names.add(entityName);
            HbmBinder.findClassNames(mappings, element, names);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                Map map = new Map(owner);
                HbmBinder.bindCollection(node, map, owner.getEntityName(), path, mappings);
                return map;
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                Set set = new Set(owner);
                HbmBinder.bindCollection(node, set, owner.getEntityName(), path, mappings);
                return set;
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                org.hibernate.mapping.List list = new org.hibernate.mapping.List(owner);
                HbmBinder.bindCollection(node, list, owner.getEntityName(), path, mappings);
                return list;
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                Bag bag = new Bag(owner);
                HbmBinder.bindCollection(node, bag, owner.getEntityName(), path, mappings);
                return bag;
            }
        };
        private static final CollectionType IDBAG = new CollectionType("idbag"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                IdentifierBag bag = new IdentifierBag(owner);
                HbmBinder.bindCollection(node, bag, owner.getEntityName(), path, mappings);
                return bag;
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                Array array = new Array(owner);
                HbmBinder.bindArray(node, array, owner.getEntityName(), path, mappings);
                return array;
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings) throws MappingException {
                PrimitiveArray array = new PrimitiveArray(owner);
                HbmBinder.bindArray(node, array, owner.getEntityName(), path, mappings);
                return array;
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract Collection create(Element var1, String var2, PersistentClass var3, Mappings var4) throws MappingException;

        CollectionType(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String xmlTagName) {
            return (CollectionType)INSTANCES.get(xmlTagName);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(IDBAG.toString(), IDBAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }

    static class ListSecondPass
    extends SecondPass {
        ListSecondPass(Element node, Mappings mappings, org.hibernate.mapping.List collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindListSecondPass(this.node, (org.hibernate.mapping.List)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class MapSecondPass
    extends SecondPass {
        MapSecondPass(Element node, Mappings mappings, Map collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindMapSecondPass(this.node, (Map)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class IdentifierCollectionSecondPass
    extends SecondPass {
        IdentifierCollectionSecondPass(Element node, Mappings mappings, IdentifierCollection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindIdentifierCollectionSecondPass(this.node, (IdentifierCollection)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class CollectionSecondPass
    extends SecondPass {
        CollectionSecondPass(Element node, Mappings mappings, Collection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindCollectionSecondPass(this.node, this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static abstract class SecondPass
    implements Serializable {
        Element node;
        Mappings mappings;
        Collection collection;

        SecondPass(Element node, Mappings mappings, Collection collection) {
            this.node = node;
            this.collection = collection;
            this.mappings = mappings;
        }

        void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Second pass for collection: " + this.collection.getRole()));
            }
            this.secondPass(persistentClasses, inheritedMetas);
            this.collection.createAllKeys();
            if (log.isDebugEnabled()) {
                String msg = "Mapped collection key: " + HbmBinder.columns(this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + HbmBinder.columns(((IndexedCollection)this.collection).getIndex());
                }
                msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + HbmBinder.columns(this.collection.getElement());
                log.debug((Object)msg);
            }
        }

        abstract void secondPass(java.util.Map var1, java.util.Map var2) throws MappingException;
    }
}

