/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.util;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    public static Node findNode(Node node, String name) {
        if (node.getNodeName().equals(name)) {
            return node;
        }
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node found = DOMUtils.findNode(list.item(i), name);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static String getNodeAttribute(Node node, String name) {
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.getAttribute(name);
        }
        return null;
    }

    public void displayNode(Node root) {
        DOMUtils.displayNode(root, 0);
    }

    public static void displayNode(Node node, int level) {
        Node child;
        DOMUtils.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                DOMUtils.displayNode(child, level + 1);
                child = child.getNextSibling();
            }
            DOMUtils.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }
}

