/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.image.iio;

import javax.imageio.metadata.IIOMetadata;
import org.jboss.media.format.image.iio.IIOMediaHeader;
import org.w3c.dom.Node;

public class StandardMediaHeader
extends IIOMediaHeader {
    private static final long serialVersionUID = 0L;
    private static final String STANDARD_METADATA_FORMAT_NAME = "javax_imageio_1.0";
    private static final String[] FIELD_NAMES = new String[]{"colorSpaceType", "numChannels", "gamma", "blackIsZero", "compressionTypeName", "lossless", "numProgressiveScans", "bitRate", "planarConfiguration", "sampleFormat", "bitsPerSample", "significantBitsPerSample", "sampleMSB", "pixelAspectRatio", "imageOrientation", "horizontalPixelSize", "verticalPixelSize", "horizontalPhysicalPixelSpacing", "verticalPhysicalPixelSpacing", "horizontalPosition", "verticalPosition", "horizontalPixelOffset", "verticalPixelOffset", "horizontalScreenSize", "verticalScreenSize", "formatVersion", "subimageInterpretation", "imageCreationYear"};

    public StandardMediaHeader(IIOMetadata imageMetadata) {
        super(imageMetadata, STANDARD_METADATA_FORMAT_NAME);
    }

    public String[] getFieldNames() {
        return FIELD_NAMES;
    }

    public Object getField(String fieldname) {
        Object field = null;
        if (fieldname.equals("colorSpaceType")) {
            field = this.getColorSpaceType();
        }
        if (fieldname.equals("numChannels")) {
            field = this.getNumChannels();
        }
        if (fieldname.equals("gamma")) {
            field = new Float(this.getGamma());
        }
        if (fieldname.equals("blackIsZero")) {
            field = this.getBlackIsZero();
        }
        if (fieldname.equals("compressionTypeName")) {
            field = this.getCompressionTypeName();
        }
        if (fieldname.equals("lossless")) {
            field = this.getLossless();
        }
        if (fieldname.equals("numProgressiveScans")) {
            field = new Integer(this.getNumProgressiveScans());
        }
        if (fieldname.equals("bitRate")) {
            field = new Float(this.getBitRate());
        }
        if (fieldname.equals("planarConfiguration")) {
            field = this.getPlanarConfiguration();
        }
        if (fieldname.equals("sampleFormat")) {
            field = this.getSampleFormat();
        }
        if (fieldname.equals("bitsPerSample")) {
            field = this.getBitsPerSample();
        }
        if (fieldname.equals("significantBitsPerSample")) {
            field = this.getSignificantBitsPerSample();
        }
        if (fieldname.equals("sampleMSB")) {
            field = this.getSampleMSB();
        }
        if (fieldname.equals("pixelAspectRatio")) {
            field = new Float(this.getPixelAspectRatio());
        }
        if (fieldname.equals("imageOrientation")) {
            field = this.getImageOrientation();
        }
        if (fieldname.equals("horizontalPixelSize")) {
            field = new Float(this.getHorizontalPixelSize());
        }
        if (fieldname.equals("verticalPixelSize")) {
            field = new Float(this.getVerticalPixelSize());
        }
        if (fieldname.equals("horizontalPhysicalPixelSpacing")) {
            field = new Float(this.getHorizontalPhysicalPixelSpacing());
        }
        if (fieldname.equals("verticalPhysicalPixelSpacing")) {
            field = new Float(this.getVerticalPhysicalPixelSpacing());
        }
        if (fieldname.equals("horizontalPosition")) {
            field = new Float(this.getHorizontalPosition());
        }
        if (fieldname.equals("verticalPosition")) {
            field = new Float(this.getVerticalPosition());
        }
        if (fieldname.equals("horizontalPixelOffset")) {
            field = new Integer(this.getHorizontalPixelOffset());
        }
        if (fieldname.equals("verticalPixelOffset")) {
            field = new Integer(this.getVerticalPixelOffset());
        }
        if (fieldname.equals("horizontalScreenSize")) {
            field = new Integer(this.getHorizontalScreenSize());
        }
        if (fieldname.equals("verticalScreenSize")) {
            field = new Integer(this.getVerticalScreenSize());
        }
        if (fieldname.equals("formatVersion")) {
            field = this.getFormatVersion();
        }
        if (fieldname.equals("subimageInterpretation")) {
            field = this.getSubimageInterpretation();
        }
        if (fieldname.equals("imageCreationYear")) {
            field = new Integer(this.getImageCreationYear());
        }
        return field;
    }

    public String getColorSpaceType() {
        Node chroma = this.getChromaNode();
        Node colorSpaceType = this.getNode(chroma, "ColorSpaceType");
        return this.getAttribute(colorSpaceType, "name");
    }

    public String getNumChannels() {
        Node chroma = this.getChromaNode();
        Node numChannels = this.getNode(chroma, "NumChannels");
        return this.getAttribute(numChannels, "value");
    }

    public float getGamma() {
        Node chroma = this.getChromaNode();
        Node gamma = this.getNode(chroma, "Gamma");
        String value = this.getAttribute(gamma, "value");
        return Float.parseFloat(value);
    }

    public String getBlackIsZero() {
        Node chroma = this.getChromaNode();
        Node blackIsZero = this.getNode(chroma, "BlackIsZero");
        return this.getAttribute(blackIsZero, "value");
    }

    public String getCompressionTypeName() {
        Node compression = this.getCompressionNode();
        Node compressionTypeName = this.getNode(compression, "CompressionTypeName");
        return this.getAttribute(compressionTypeName, "value");
    }

    public String getLossless() {
        Node compression = this.getCompressionNode();
        Node lossless = this.getNode(compression, "Lossless");
        return this.getAttribute(lossless, "value");
    }

    public int getNumProgressiveScans() {
        Node compression = this.getCompressionNode();
        Node numProgressiveScans = this.getNode(compression, "NumProgressiveScans");
        String value = this.getAttribute(numProgressiveScans, "value");
        return Integer.parseInt(value);
    }

    public float getBitRate() {
        Node compression = this.getCompressionNode();
        Node bitRate = this.getNode(compression, "BitRate");
        String value = this.getAttribute(bitRate, "value");
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public String getPlanarConfiguration() {
        Node data = this.getDataNode();
        Node planarConfiguration = this.getNode(data, "PlanarConfiguration");
        return this.getAttribute(planarConfiguration, "value");
    }

    public String getSampleFormat() {
        Node data = this.getDataNode();
        Node sampleFormat = this.getNode(data, "SampleFormat");
        return this.getAttribute(sampleFormat, "value");
    }

    public String getBitsPerSample() {
        Node data = this.getDataNode();
        Node bitsPerSample = this.getNode(data, "BitsPerSample");
        return this.getAttribute(bitsPerSample, "value");
    }

    public String getSignificantBitsPerSample() {
        Node data = this.getDataNode();
        Node significantBitsPerSample = this.getNode(data, "SignificantBitsPerSample");
        return this.getAttribute(significantBitsPerSample, "value");
    }

    public String getSampleMSB() {
        Node data = this.getDataNode();
        Node sampleMSB = this.getNode(data, "SampleMSB");
        return this.getAttribute(sampleMSB, "value");
    }

    public float getPixelAspectRatio() {
        Node dimension = this.getDimensionNode();
        Node pixelAspectRatio = this.getNode(dimension, "PixelAspectRatio");
        String value = this.getAttribute(pixelAspectRatio, "value");
        return Float.parseFloat(value);
    }

    public String getImageOrientation() {
        Node dimension = this.getDimensionNode();
        Node imageOrientation = this.getNode(dimension, "ImageOrientation");
        return this.getAttribute(imageOrientation, "value");
    }

    public float getHorizontalPixelSize() {
        Node dimension = this.getDimensionNode();
        Node horizontalPixelSize = this.getNode(dimension, "HorizontalPixelSize");
        String value = this.getAttribute(horizontalPixelSize, "value");
        return Float.parseFloat(value);
    }

    public float getVerticalPixelSize() {
        Node dimension = this.getDimensionNode();
        Node verticalPixelSize = this.getNode(dimension, "VerticalPixelSize");
        String value = this.getAttribute(verticalPixelSize, "value");
        return Float.parseFloat(value);
    }

    public float getHorizontalPhysicalPixelSpacing() {
        Node dimension = this.getDimensionNode();
        Node horizontalPhysicalPixelSpacing = this.getNode(dimension, "HorizontalPhysicalPixelSpacing");
        String value = this.getAttribute(horizontalPhysicalPixelSpacing, "value");
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public float getVerticalPhysicalPixelSpacing() {
        Node dimension = this.getDimensionNode();
        Node verticalPhysicalPixelSpacing = this.getNode(dimension, "VerticalPhysicalPixelSpacing");
        String value = this.getAttribute(verticalPhysicalPixelSpacing, "value");
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public float getHorizontalPosition() {
        Node dimension = this.getDimensionNode();
        Node horizontalPosition = this.getNode(dimension, "HorizontalPosition");
        String value = this.getAttribute(horizontalPosition, "value");
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public float getVerticalPosition() {
        Node dimension = this.getDimensionNode();
        Node verticalPosition = this.getNode(dimension, "VerticalPosition");
        String value = this.getAttribute(verticalPosition, "value");
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public int getHorizontalPixelOffset() {
        Node dimension = this.getDimensionNode();
        Node horizontalPixelOffset = this.getNode(dimension, "HorizontalPixelOffset");
        String value = this.getAttribute(horizontalPixelOffset, "value");
        return value == null ? 0 : Integer.parseInt(value);
    }

    public int getVerticalPixelOffset() {
        Node dimension = this.getDimensionNode();
        Node verticalPixelOffset = this.getNode(dimension, "VerticalPixelOffset");
        String value = this.getAttribute(verticalPixelOffset, "value");
        return value == null ? 0 : Integer.parseInt(value);
    }

    public int getHorizontalScreenSize() {
        Node dimension = this.getDimensionNode();
        Node horizontalScreenSize = this.getNode(dimension, "HorizontalScreenSize");
        String value = this.getAttribute(horizontalScreenSize, "value");
        return value == null ? 0 : Integer.parseInt(value);
    }

    public int getVerticalScreenSize() {
        Node dimension = this.getDimensionNode();
        Node verticalScreenSize = this.getNode(dimension, "VerticalScreenSize");
        String value = this.getAttribute(verticalScreenSize, "value");
        return value == null ? 0 : Integer.parseInt(value);
    }

    public String getFormatVersion() {
        Node document = this.getDocumentNode();
        Node formatVersion = this.getNode(document, "FormatVersion");
        return this.getAttribute(formatVersion, "value");
    }

    public String getSubimageInterpretation() {
        Node document = this.getDocumentNode();
        Node subimageInterpretation = this.getNode(document, "SubimageInterpretation");
        return this.getAttribute(subimageInterpretation, "value");
    }

    public int getImageCreationYear() {
        Node document = this.getDocumentNode();
        Node formatVersion = this.getNode(document, "ImageCreationTime");
        String value = this.getAttribute(formatVersion, "year");
        return value == null ? 0 : Integer.parseInt(value);
    }

    private Node getChromaNode() {
        return this.getNode("Chroma");
    }

    private Node getCompressionNode() {
        return this.getNode("Compression");
    }

    private Node getDataNode() {
        return this.getNode("Data");
    }

    private Node getDimensionNode() {
        return this.getNode("Dimension");
    }

    private Node getDocumentNode() {
        return this.getNode("Document");
    }
}

