/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.audio.oggvorbis;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

class VorbisInfo {
    private int channels;
    private long rate = 0L;
    private long bitrate_upper;
    private long bitrate_nominal;
    private long bitrate_lower;
    String vendor;
    int comments = 0;
    Hashtable comment;
    private long[] crc_lookup = new long[256];
    private int crc_ready = 0;
    private byte[] header;
    private byte[] packet;

    public VorbisInfo(InputStream s) throws IOException {
        for (int i = 0; i < 256; ++i) {
            this.crc_lookup[i] = this._ogg_crc_entry(i);
        }
        this.fetch_header_and_packet(s);
        this.interpret_header_packet();
        this.fetch_header_and_packet(s);
        this.interpret_header_packet();
    }

    public int getChannels() {
        return this.channels;
    }

    public long getRate() {
        return this.rate;
    }

    public long getBitrate() {
        return this.bitrate_nominal;
    }

    public Vector getComments(String field) {
        return (Vector)this.comment.get(field.toLowerCase());
    }

    public Set getFields() {
        return this.comment.keySet();
    }

    private void fetch_header_and_packet(InputStream s) throws IOException {
        byte[] head = new byte[27];
        int bytes = s.read(head);
        if (bytes < 27) {
            throw new IOException("Not enough bytes in header");
        }
        if (!"OggS".equals(new String(head, 0, 4))) {
            throw new IOException("Not a valid Ogg Vorbis file");
        }
        int headerbytes = this.touint(head[26]) + 27;
        byte[] head_rest = new byte[this.touint(head[26])];
        this.header = new byte[headerbytes];
        Arrays.fill(this.header, (byte)0);
        System.arraycopy(head, 0, this.header, 0, 27);
        System.arraycopy(head_rest, 0, this.header, 27, headerbytes - 27);
        if ((bytes += s.read(head_rest)) < headerbytes) {
            String error = "Error reading vorbis file: Not enough bytes for header + seg table";
            throw new IOException(error);
        }
        int bodybytes = 0;
        for (int i = 0; i < this.header[26]; ++i) {
            bodybytes += this.touint(this.header[27 + i]);
        }
        this.packet = new byte[bodybytes];
        Arrays.fill(this.packet, (byte)0);
        if ((bytes += s.read(this.packet)) < headerbytes + bodybytes) {
            String error = "Error reading vorbis file: Not enough bytes for header + body";
            throw new IOException(error);
        }
        byte[] oldsum = new byte[4];
        System.arraycopy(this.header, 22, oldsum, 0, 4);
        Arrays.fill(this.header, 22, 26, (byte)0);
        byte[] newsum = this.checksum();
        if (!new String(oldsum).equals(new String(newsum))) {
            System.err.println("checksum failed");
            System.err.println("old checksum: " + oldsum[0] + "|" + oldsum[1] + "|" + oldsum[2] + "|" + oldsum[3]);
            System.err.println("new checksum: " + newsum[0] + "|" + newsum[1] + "|" + newsum[2] + "|" + newsum[3]);
        }
    }

    private void interpret_header_packet() throws IOException {
        byte packet_type = this.packet[0];
        switch (packet_type) {
            case 1: {
                if (this.rate != 0L) {
                    throw new IOException("Invalid vorbis file: info already fetched");
                }
                this.fetch_info_info();
                break;
            }
            case 3: {
                if (this.rate == 0L) {
                    throw new IOException("Invalid vorbis file: header not complete");
                }
                this.fetch_comment_info();
                break;
            }
            case 5: {
                throw new IOException("Invalid vorbis file: header not complete");
            }
            default: {
                throw new IOException("Invalid vorbis file: bad packet header");
            }
        }
    }

    private void fetch_info_info() throws IOException {
        int dataptr = 1;
        String str = new String(this.packet, dataptr, 6);
        dataptr += 6;
        if (!"vorbis".equals(str)) {
            throw new IOException("Not a vorbis header");
        }
        dataptr += 4;
        this.channels = this.packet[dataptr++];
        this.rate = this.toulong(this.read32(this.packet, dataptr));
        this.bitrate_upper = this.toulong(this.read32(this.packet, dataptr += 4));
        this.bitrate_nominal = this.toulong(this.read32(this.packet, dataptr += 4));
        this.bitrate_lower = this.toulong(this.read32(this.packet, dataptr += 4));
        dataptr += 4;
        int n = ++dataptr;
        ++dataptr;
        byte eop = this.packet[n];
        if (eop != 1) {
            throw new IOException("End of packet expected but not found");
        }
    }

    private void fetch_comment_info() throws IOException {
        int dataptr = 1;
        String str = new String(this.packet, dataptr, 6);
        dataptr += 6;
        if (!"vorbis".equals(str)) {
            throw new IOException("Not a vorbis header");
        }
        this.comment = new Hashtable();
        long len = this.toulong(this.read32(this.packet, dataptr));
        this.vendor = new String(this.packet, dataptr += 4, (int)len);
        dataptr = (int)((long)dataptr + len);
        this.comments = (int)this.toulong(this.read32(this.packet, dataptr));
        dataptr += 4;
        for (int i = 0; i < this.comments; ++i) {
            Vector tmp;
            len = this.toulong(this.read32(this.packet, dataptr));
            String cmnt = new String(this.packet, dataptr += 4, (int)len);
            dataptr = (int)((long)dataptr + len);
            String name = cmnt.substring(0, cmnt.indexOf(61));
            String value = cmnt.substring(cmnt.indexOf(61) + 1);
            if (this.comment.containsKey(name)) {
                tmp = (Vector)this.comment.get(name.toLowerCase());
                tmp.add(value);
                continue;
            }
            tmp = new Vector();
            tmp.add(value);
            this.comment.put(name.toLowerCase(), tmp);
        }
    }

    private int read32(byte[] data, int ptr) {
        int val = 0;
        val = this.touint(data[ptr]) & 0xFF;
        val |= this.touint(data[ptr + 1]) << 8 & 0xFF00;
        val |= this.touint(data[ptr + 2]) << 16 & 0xFF0000;
        return val |= this.touint(data[ptr + 3]) << 24 & 0xFF000000;
    }

    private byte[] checksum() {
        int tmp;
        int i;
        long crc_reg = 0L;
        for (i = 0; i < this.header.length; ++i) {
            tmp = (int)(crc_reg >>> 24 & 0xFFL ^ (long)this.touint(this.header[i]));
            crc_reg = crc_reg << 8 ^ this.crc_lookup[tmp];
            crc_reg &= 0xFFFFFFFFFFFFFFFFL;
        }
        for (i = 0; i < this.packet.length; ++i) {
            tmp = (int)(crc_reg >>> 24 & 0xFFL ^ (long)this.touint(this.packet[i]));
            crc_reg = crc_reg << 8 ^ this.crc_lookup[tmp];
            crc_reg &= 0xFFFFFFFFFFFFFFFFL;
        }
        byte[] sum = new byte[]{(byte)(crc_reg & 0xFFL), (byte)(crc_reg >>> 8 & 0xFFL), (byte)(crc_reg >>> 16 & 0xFFL), (byte)(crc_reg >>> 24 & 0xFFL)};
        return sum;
    }

    private long _ogg_crc_entry(long index) {
        long r = index << 24;
        for (int i = 0; i < 8; ++i) {
            if ((r & 0x80000000L) != 0L) {
                r = r << 1 ^ 0x4C11DB7L;
                continue;
            }
            r <<= 1;
        }
        return r & 0xFFFFFFFFFFFFFFFFL;
    }

    private long toulong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private int touint(byte n) {
        return n & 0xFF;
    }

    public String toString() {
        String str = "";
        str = str + this.channels + " channels at " + this.rate + "Hz\n";
        str = str + this.bitrate_nominal / 1000L + "kbps (average bitrate)\n";
        Iterator fields = this.comment.keySet().iterator();
        while (fields.hasNext()) {
            String name = (String)fields.next();
            Vector values = (Vector)this.comment.get(name);
            Iterator vi = values.iterator();
            str = str + name + "=";
            boolean dumb = false;
            while (vi.hasNext()) {
                if (dumb) {
                    str = str + ", ";
                }
                str = str + vi.next();
                dumb = true;
            }
            str = str + "\n";
        }
        return str;
    }

    static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage:\tjava VorbisInfo <ogg vorbis file>");
            System.exit(1);
        }
        BufferedInputStream b = new BufferedInputStream(new FileInputStream(args[0]));
        VorbisInfo vi = new VorbisInfo(b);
        System.out.println("\n" + vi);
        b.close();
    }

    public Hashtable getComments() {
        return this.comment;
    }
}

