/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.audio.oggvorbis;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.emb.MediaException;
import javax.emb.MediaHeader;
import org.jboss.media.format.audio.oggvorbis.VorbisInfo;

public class OggVorbisHeader
implements MediaHeader {
    private static final String CHANNELS_KEY = "channels";
    private static final String RATE_KEY = "rate";
    private static final String BITRATE_KEY = "bitRate";
    private static final String COMMENTS_KEY = "comments";
    private final Map fieldMap = new HashMap(4);

    public OggVorbisHeader(InputStream content) throws MediaException {
        try {
            VorbisInfo info = new VorbisInfo(content);
            this.fieldMap.put(CHANNELS_KEY, new Integer(info.getChannels()));
            this.fieldMap.put(RATE_KEY, new Long(info.getRate()));
            this.fieldMap.put(BITRATE_KEY, new Long(info.getBitrate()));
            this.fieldMap.put(COMMENTS_KEY, info.getComments());
        }
        catch (IOException e) {
            throw new MediaException("Error creating VorbisInfo helper object", (Throwable)e);
        }
    }

    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    public Object getField(String fieldName) {
        return this.fieldMap.get(fieldName);
    }
}

