/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.net.URL;
import javax.management.MBeanRegistration;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.server.ServiceLifecycle;
import org.jboss.axis.AxisProperties;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.configuration.EngineConfigurationFactoryFinder;
import org.jboss.axis.deployment.wsdd.WSDDUndeployment;
import org.jboss.axis.server.AxisServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.metadata.MetaData;
import org.jboss.net.axis.AttacheableService;
import org.jboss.net.axis.Deployment;
import org.jboss.net.axis.XMLResourceProvider;
import org.jboss.net.axis.server.AxisServiceMBean;
import org.jboss.net.axis.server.JMXEngineConfigurationFactory;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class AxisService
extends SubDeployerSupport
implements AxisServiceMBean,
MBeanRegistration {
    protected AxisServer axisServer;
    protected XMLResourceProvider clientConfiguration;
    protected XMLResourceProvider serverConfiguration;
    protected InitialContext initialContext;
    protected DocumentBuilder documentBuilder;
    protected boolean validateDTDs;

    protected void copyChildren(Document sourceDoc, Element source, String match, Element target) {
        NodeList children = source.getChildNodes();
        for (int count = 0; count < children.getLength(); ++count) {
            Node actNode = children.item(count);
            if (!(actNode instanceof Element) || !((Element)actNode).getLocalName().equals(match)) continue;
            target.appendChild(sourceDoc.importNode(actNode, true));
        }
    }

    protected void startAxisDeployment(String deploymentName, Element root, ClassLoader deploymentLoader) throws DeploymentException {
        try {
            Document deployDoc = this.documentBuilder.newDocument();
            Document deployClientDoc = this.documentBuilder.newDocument();
            Element deploy = deployDoc.createElementNS(root.getNamespaceURI(), "deployment");
            Element deployClient = deployClientDoc.createElementNS(root.getNamespaceURI(), "deployment");
            NamedNodeMap attributes = root.getAttributes();
            for (int count = 0; count < attributes.getLength(); ++count) {
                Attr attribute = (Attr)attributes.item(count);
                deploy.setAttributeNodeNS((Attr)deployDoc.importNode(attribute, true));
                deployClient.setAttributeNodeNS((Attr)deployClientDoc.importNode(attribute, true));
            }
            NodeList children = root.getChildNodes();
            for (int count = 0; count < children.getLength(); ++count) {
                Node actNode = children.item(count);
                if (actNode instanceof Element) {
                    Element actElement = (Element)actNode;
                    if (actElement.getTagName().equals("ejb-ref")) {
                        String refName = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)((Element)actNode), (String)"ejb-ref-name"));
                        String linkName = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)((Element)actNode), (String)"ejb-link"));
                        this.log.warn((Object)("Web Service Deployment " + deploymentName + " makes use of the deprecated ejb-ref feature. " + "Please adjust any ejb-providing service tag inside your web-service.xml pointing to " + refName + " to use the absolute " + linkName + " instead."));
                        continue;
                    }
                    if (actElement.getTagName().equals("ext-service")) {
                        this.deployExternalWebService(actElement);
                        continue;
                    }
                    if (!actElement.getTagName().equals("service")) {
                        deployClient.appendChild(deployClientDoc.importNode(actNode, true));
                    }
                    deploy.appendChild(deployDoc.importNode(actNode, true));
                    continue;
                }
                deployClient.appendChild(deployClientDoc.importNode(actNode, true));
                deploy.appendChild(deployDoc.importNode(actNode, true));
            }
            deployDoc.appendChild(deploy);
            deployClientDoc.appendChild(deployClient);
            Deployment.makeSafeDeployment(deploy, deploymentLoader).deployToRegistry(((XMLResourceProvider)this.axisServer.getConfig()).getDeployment());
            Deployment.makeSafeDeployment(deployClient, deploymentLoader).deployToRegistry(this.clientConfiguration.getDeployment());
            this.axisServer.refreshGlobalOptions();
            this.axisServer.saveConfiguration();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy axis descriptor.", (Throwable)e);
        }
    }

    protected void stopAxisDeployment(Element root) throws DeploymentException {
        try {
            Element actNode;
            int count;
            Document undeployDoc = this.documentBuilder.newDocument();
            Element undeploy = undeployDoc.createElementNS(root.getNamespaceURI(), "undeployment");
            NamedNodeMap attributes = root.getAttributes();
            for (int count2 = 0; count2 < attributes.getLength(); ++count2) {
                Attr attribute = (Attr)attributes.item(count2);
                undeploy.setAttributeNodeNS((Attr)undeployDoc.importNode(attribute, true));
            }
            NodeList children = root.getElementsByTagName("ext-service");
            for (count = 0; count < children.getLength(); ++count) {
                actNode = (Element)children.item(count);
                this.undeployExternalWebService(actNode);
            }
            this.copyChildren(undeployDoc, root, "service", undeploy);
            children = root.getElementsByTagName("service");
            for (count = 0; count < children.getLength(); ++count) {
                actNode = (Element)children.item(count);
                String serviceName = actNode.getAttribute("name");
                ServiceLifecycle slc = (ServiceLifecycle)this.axisServer.getApplicationSession().get(serviceName);
                if (slc == null) continue;
                slc.destroy();
                this.axisServer.getApplicationSession().remove(serviceName);
            }
            this.copyChildren(undeployDoc, root, "handler", undeploy);
            this.copyChildren(undeployDoc, root, "typemapping", undeploy);
            this.copyChildren(undeployDoc, root, "beanmapping", undeploy);
            undeployDoc.appendChild(undeploy);
            new WSDDUndeployment(undeploy).undeployFromRegistry(((XMLResourceProvider)this.axisServer.getConfig()).getDeployment());
            new WSDDUndeployment(undeploy).undeployFromRegistry(this.clientConfiguration.getDeployment());
            this.axisServer.refreshGlobalOptions();
            this.axisServer.saveConfiguration();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy url.", (Throwable)e);
        }
    }

    protected synchronized void deployExternalWebService(Element deployElement) throws DeploymentException {
        try {
            if (this.initialContext == null) {
                this.initialContext = new InitialContext();
            }
            NamedNodeMap attributes = deployElement.getAttributes();
            String jndiName = attributes.getNamedItem("jndiName").getNodeValue();
            String serviceClassName = attributes.getNamedItem("serviceImplClass").getNodeValue();
            AttacheableService factory = new AttacheableService(serviceClassName, this.serviceName.getCanonicalName());
            this.initialContext.bind(jndiName, (Object)factory);
        }
        catch (NamingException e) {
            throw new DeploymentException("Could not deploy item " + deployElement, (Throwable)e);
        }
    }

    protected synchronized void undeployExternalWebService(Element deployElement) {
        try {
            NamedNodeMap attributes;
            String jndiName;
            if (this.initialContext == null) {
                this.initialContext = new InitialContext();
            }
            if ((jndiName = (attributes = deployElement.getAttributes()).getNamedItem("jndiName").getNodeValue()) != null) {
                this.initialContext.unbind(jndiName);
            }
        }
        catch (NamingException e) {
            this.log.warn((Object)("Could not undeploy " + deployElement), (Throwable)e);
        }
    }

    protected void startService() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(this.validateDTDs);
        this.documentBuilder = dbf.newDocumentBuilder();
        this.documentBuilder.setEntityResolver((EntityResolver)new JBossEntityResolver());
        URL resource = this.getClass().getClassLoader().getResource("server-config.wsdd");
        if (resource == null) {
            this.log.warn((Object)"Could not find: server-config.wsdd");
            throw new Exception("Could not find the axis configuration file {0}.");
        }
        this.serverConfiguration = new XMLResourceProvider(resource, this.getClass().getClassLoader());
        this.axisServer = new AxisServer((EngineConfiguration)this.serverConfiguration);
        this.serverConfiguration.getGlobalOptions().put("org.jboss.net.axis.CONFIGURATION_CONTEXT", this.serviceName.toString());
        resource = this.getClass().getClassLoader().getResource("client-config.wsdd");
        if (resource == null) {
            this.log.warn((Object)"Failed to find: server-config.wsdd");
            throw new Exception("Could not find the axis configuration file {0}.");
        }
        this.clientConfiguration = new XMLResourceProvider(resource, this.getClass().getClassLoader());
        this.clientConfiguration.buildDeployment();
        this.clientConfiguration.getGlobalOptions().put("org.jboss.net.axis.CONFIGURATION_CONTEXT", this.serviceName.toString());
        AxisProperties.getNameDiscoverer();
        Class initializeThisStaticStuff = EngineConfigurationFactoryFinder.class;
        System.setProperty("axis.EngineConfigFactory", JMXEngineConfigurationFactory.class.getName());
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.axisServer.stop();
        this.documentBuilder = null;
    }

    public boolean accepts(DeploymentInfo sdi) {
        return sdi.shortName.endsWith("-axis.xml") || sdi.localCl.getResource("META-INF/web-service.xml") != null;
    }

    public void init(DeploymentInfo sdi) throws DeploymentException {
        super.init(sdi);
        try {
            if (sdi.document == null) {
                if (sdi.documentUrl == null) {
                    sdi.documentUrl = sdi.isXML ? sdi.localUrl : sdi.localCl.getResource("META-INF/web-service.xml");
                }
                sdi.document = this.documentBuilder.parse(sdi.documentUrl.openStream());
            }
            sdi.watch = sdi.isDirectory ? new URL(sdi.url, "META-INF/web-service.xml") : sdi.url;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void create(DeploymentInfo sdi) throws DeploymentException {
        this.log.debug((Object)("create, sdi=" + sdi));
        super.create(sdi);
    }

    public void start(DeploymentInfo sdi) throws DeploymentException {
        this.log.debug((Object)("start, sdi=" + sdi));
        super.start(sdi);
        this.start(sdi.toString(), sdi.document, (ClassLoader)sdi.ucl);
    }

    public void start(String deploymentName, Document doc, ClassLoader serviceLoader) throws DeploymentException {
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equals("deployments")) {
            NodeList children = root.getChildNodes();
            for (int count = 0; count < children.getLength(); ++count) {
                this.startAxisDeployment(deploymentName, (Element)children.item(count), serviceLoader);
            }
        } else {
            this.startAxisDeployment(deploymentName, root, serviceLoader);
        }
    }

    public void stop(DeploymentInfo sdi) throws DeploymentException {
        this.log.debug((Object)("stop, sdi=" + sdi));
        super.stop(sdi);
        this.stop(sdi.document);
    }

    public void stop(Document doc) throws DeploymentException {
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equals("deployments")) {
            NodeList children = root.getChildNodes();
            for (int count = 0; count < children.getLength(); ++count) {
                this.stopAxisDeployment((Element)children.item(count));
            }
        } else {
            this.stopAxisDeployment(root);
        }
    }

    public void destroy(DeploymentInfo sdi) throws DeploymentException {
        this.log.debug((Object)("destroy, sdi=" + sdi));
        super.destroy(sdi);
    }

    public EngineConfiguration getClientEngineConfiguration() {
        return this.clientConfiguration;
    }

    public EngineConfiguration getServerEngineConfiguration() {
        return this.serverConfiguration;
    }

    public AxisServer getAxisServer() {
        return this.axisServer;
    }
}

