/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.jdt.internal.core.hierarchy.IHierarchyRequestor;

public class HierarchyResolver
implements ITypeRequestor {
    IHierarchyRequestor requestor;
    LookupEnvironment lookupEnvironment;
    private int typeIndex;
    private IGenericType[] typeModels;
    private ReferenceBinding[] typeBindings;
    private ReferenceBinding focusType;
    private CompilerOptions options;
    private boolean hasMissingSuperClass;

    public HierarchyResolver(INameEnvironment nameEnvironment, Map settings, IHierarchyRequestor requestor, IProblemFactory problemFactory) {
        this.options = settings == null ? new CompilerOptions() : new CompilerOptions(settings);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.setEnvironment(new LookupEnvironment(this, this.options, problemReporter, nameEnvironment), requestor);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, IHierarchyRequestor requestor) {
        this.setEnvironment(lookupEnvironment, requestor);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        BinaryTypeBinding typeBinding = this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
        try {
            this.remember(binaryType, typeBinding);
        }
        catch (AbortCompilation abortCompilation) {}
    }

    public void accept(ICompilationUnit sourceUnit) {
        this.lookupEnvironment.problemReporter.abortDueToInternalError(Util.bind("accept.cannot") + sourceUnit.getFileName());
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{sourceType}, false, true, false, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            try {
                this.lookupEnvironment.buildTypeBindings(unit);
                this.rememberWithMemberTypes(sourceType, unit.types[0].binding);
                this.lookupEnvironment.completeTypeBindings(unit, false);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    private IGenericType findSuperClass(IGenericType type, ReferenceBinding typeBinding) {
        ReferenceBinding superBinding = typeBinding.superclass();
        if (superBinding != null) {
            if (superBinding.id == 1 && typeBinding.isHierarchyInconsistent()) {
                int separator;
                char[] superclassName;
                if (type instanceof IBinaryType) {
                    superclassName = ((IBinaryType)type).getSuperclassName();
                    separator = 47;
                } else if (type instanceof ISourceType) {
                    superclassName = ((ISourceType)type).getSuperclassName();
                    separator = 46;
                } else if (type instanceof HierarchyType) {
                    superclassName = ((HierarchyType)type).superclassName;
                    separator = 46;
                } else {
                    return null;
                }
                if (superclassName != null) {
                    char[] simpleName;
                    int lastSeparator = CharOperation.lastIndexOf((char)separator, superclassName);
                    char[] cArray = simpleName = lastSeparator == -1 ? superclassName : CharOperation.subarray(superclassName, lastSeparator + 1, superclassName.length);
                    if (!CharOperation.equals(simpleName, TypeConstants.OBJECT)) {
                        this.hasMissingSuperClass = true;
                        return new MissingType(new String(simpleName));
                    }
                }
            }
            int t = this.typeIndex;
            while (t >= 0) {
                if (this.typeBindings[t] == superBinding) {
                    return this.typeModels[t];
                }
                --t;
            }
        }
        return null;
    }

    private IGenericType[] findSuperInterfaces(IGenericType type, ReferenceBinding typeBinding) {
        char separator;
        char[][] superInterfaceNames;
        if (type instanceof IBinaryType) {
            superInterfaceNames = ((IBinaryType)type).getInterfaceNames();
            separator = '/';
        } else if (type instanceof ISourceType) {
            superInterfaceNames = ((ISourceType)type).getInterfaceNames();
            separator = '.';
        } else if (type instanceof HierarchyType) {
            superInterfaceNames = ((HierarchyType)type).superInterfaceNames;
            separator = '.';
        } else {
            return null;
        }
        ReferenceBinding[] interfaceBindings = typeBinding.superInterfaces();
        int bindingIndex = 0;
        int bindingLength = interfaceBindings == null ? 0 : interfaceBindings.length;
        int length = superInterfaceNames == null ? 0 : superInterfaceNames.length;
        IGenericType[] superinterfaces = new IGenericType[length];
        int i = 0;
        while (i < length) {
            block11: {
                char[] simpleName;
                char[] superInterfaceName = superInterfaceNames[i];
                int lastSeparator = CharOperation.lastIndexOf(separator, superInterfaceName);
                char[] cArray = simpleName = lastSeparator == -1 ? superInterfaceName : CharOperation.subarray(superInterfaceName, lastSeparator + 1, superInterfaceName.length);
                if (bindingIndex < bindingLength) {
                    ReferenceBinding interfaceBinding = interfaceBindings[bindingIndex];
                    if (CharOperation.equals(simpleName, interfaceBinding.sourceName)) {
                        ++bindingIndex;
                        int t = this.typeIndex;
                        while (t >= 0) {
                            if (this.typeBindings[t] == interfaceBinding) {
                                superinterfaces[i] = this.typeModels[t];
                                break block11;
                            }
                            --t;
                        }
                    }
                }
                superinterfaces[i] = new MissingType(new String(simpleName));
            }
            ++i;
        }
        return superinterfaces;
    }

    private void remember(IGenericType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        if (suppliedType.isBinaryType()) {
            typeBinding.superclass();
            typeBinding.superInterfaces();
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = suppliedType;
        this.typeBindings[this.typeIndex] = typeBinding;
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDeclaration, HierarchyType enclosingType, ICompilationUnit unit) {
        if (typeDeclaration.binding == null) {
            return;
        }
        char[] superclassName = null;
        TypeReference superclass = typeDeclaration.superclass;
        if (superclass != null) {
            char[][] typeName = superclass.getTypeName();
            superclassName = typeName == null ? null : typeName[typeName.length - 1];
        }
        char[][] superInterfaceNames = null;
        TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
        if (superInterfaces != null) {
            int length = superInterfaces.length;
            superInterfaceNames = new char[length][];
            int i = 0;
            while (i < length) {
                TypeReference superInterface = superInterfaces[i];
                char[][] typeName = superInterface.getTypeName();
                superInterfaceNames[i] = typeName[typeName.length - 1];
                ++i;
            }
        }
        HierarchyType hierarchyType = new HierarchyType(enclosingType, !typeDeclaration.isInterface(), typeDeclaration.name, typeDeclaration.binding.modifiers, superclassName, superInterfaceNames, unit);
        this.remember(hierarchyType, typeDeclaration.binding);
        if (typeDeclaration.memberTypes == null) {
            return;
        }
        MemberTypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int i = 0;
        int max = memberTypes.length;
        while (i < max) {
            this.rememberWithMemberTypes(memberTypes[i], hierarchyType, unit);
            ++i;
        }
    }

    private void rememberWithMemberTypes(ISourceType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        this.remember(suppliedType, typeBinding);
        ISourceType[] memberTypes = suppliedType.getMemberTypes();
        if (memberTypes == null) {
            return;
        }
        int m = memberTypes.length;
        while (--m >= 0) {
            ISourceType memberType = memberTypes[m];
            this.rememberWithMemberTypes(memberType, typeBinding.getMemberType(memberType.getName()));
        }
    }

    private void reportHierarchy() {
        int objectIndex = -1;
        int current = this.typeIndex;
        while (current >= 0) {
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding.id == 1) {
                objectIndex = current;
            } else {
                IGenericType suppliedType = this.typeModels[current];
                if (this.subOrSuperOfFocus(typeBinding)) {
                    IGenericType superclass = typeBinding.isInterface() ? null : this.findSuperClass(suppliedType, typeBinding);
                    IGenericType[] superinterfaces = this.findSuperInterfaces(suppliedType, typeBinding);
                    this.requestor.connect(suppliedType, superclass, superinterfaces);
                }
            }
            --current;
        }
        if (!this.hasMissingSuperClass && objectIndex > -1) {
            this.requestor.connect(this.typeModels[objectIndex], null, null);
        }
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    public void resolve(IGenericType[] suppliedTypes, IProgressMonitor monitor) {
        this.resolve(suppliedTypes, null, monitor);
    }

    public void resolve(IGenericType[] suppliedTypes, ICompilationUnit[] sourceUnits, IProgressMonitor monitor) {
        try {
            try {
                CompilationUnitDeclaration parsedUnit;
                int suppliedLength = suppliedTypes == null ? 0 : suppliedTypes.length;
                int sourceLength = sourceUnits == null ? 0 : sourceUnits.length;
                CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[suppliedLength + sourceLength];
                BinaryTypeBinding[] binaryBindings = new BinaryTypeBinding[suppliedLength];
                int i = 0;
                while (i < suppliedLength) {
                    if (suppliedTypes[i].isBinaryType()) {
                        IBinaryType binaryType = (IBinaryType)suppliedTypes[i];
                        try {
                            binaryBindings[i] = this.lookupEnvironment.cacheBinaryType(binaryType, false);
                        }
                        catch (AbortCompilation abortCompilation) {}
                    }
                    ++i;
                }
                i = 0;
                while (i < suppliedLength) {
                    if (suppliedTypes[i].isBinaryType()) {
                        if (binaryBindings[i] != null) {
                            try {
                                this.remember((IBinaryType)suppliedTypes[i], binaryBindings[i]);
                            }
                            catch (AbortCompilation abortCompilation) {}
                        }
                    } else {
                        ISourceType topLevelType = (ISourceType)suppliedTypes[i];
                        while (topLevelType.getEnclosingType() != null) {
                            topLevelType = topLevelType.getEnclosingType();
                        }
                        CompilationResult result = new CompilationResult(topLevelType.getFileName(), i, suppliedLength, this.options.maxProblemsPerUnit);
                        units[i] = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{topLevelType}, false, true, false, this.lookupEnvironment.problemReporter, result);
                        if (units[i] != null) {
                            try {
                                this.lookupEnvironment.buildTypeBindings(units[i]);
                            }
                            catch (AbortCompilation abortCompilation) {}
                        }
                    }
                    this.worked(monitor, 1);
                    ++i;
                }
                Parser parser = new Parser(this.lookupEnvironment.problemReporter, true, this.options.sourceLevel);
                int i2 = 0;
                while (i2 < sourceLength) {
                    ICompilationUnit sourceUnit = sourceUnits[i2];
                    CompilationResult unitResult = new CompilationResult(sourceUnit, suppliedLength + i2, suppliedLength + sourceLength, this.options.maxProblemsPerUnit);
                    CompilationUnitDeclaration parsedUnit2 = parser.dietParse(sourceUnit, unitResult);
                    if (parsedUnit2 != null) {
                        units[suppliedLength + i2] = parsedUnit2;
                        this.lookupEnvironment.buildTypeBindings(parsedUnit2);
                    }
                    this.worked(monitor, 1);
                    ++i2;
                }
                i2 = 0;
                while (i2 < suppliedLength) {
                    if (!suppliedTypes[i2].isBinaryType() && (parsedUnit = units[i2]) != null) {
                        ISourceType topLevelType = (ISourceType)suppliedTypes[i2];
                        suppliedTypes[i2] = null;
                        while (topLevelType.getEnclosingType() != null) {
                            topLevelType = topLevelType.getEnclosingType();
                        }
                        try {
                            this.lookupEnvironment.completeTypeBindings(parsedUnit, false);
                            this.rememberWithMemberTypes(topLevelType, parsedUnit.types[0].binding);
                        }
                        catch (AbortCompilation abortCompilation) {}
                    }
                    this.worked(monitor, 1);
                    ++i2;
                }
                i2 = 0;
                while (i2 < sourceLength) {
                    parsedUnit = units[suppliedLength + i2];
                    if (parsedUnit != null) {
                        this.lookupEnvironment.completeTypeBindings(parsedUnit, false);
                        int typeCount = parsedUnit.types == null ? 0 : parsedUnit.types.length;
                        ICompilationUnit sourceUnit = sourceUnits[i2];
                        sourceUnits[i2] = null;
                        int j = 0;
                        while (j < typeCount) {
                            this.rememberWithMemberTypes(parsedUnit.types[j], null, sourceUnit);
                            ++j;
                        }
                    }
                    this.worked(monitor, 1);
                    ++i2;
                }
                this.reportHierarchy();
            }
            catch (ClassCastException classCastException) {
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.reset();
            throw throwable;
        }
        Object var14_19 = null;
        this.reset();
    }

    public void resolve(IGenericType suppliedType) {
        try {
            try {
                if (suppliedType.isBinaryType()) {
                    this.remember(suppliedType, this.lookupEnvironment.cacheBinaryType((IBinaryType)suppliedType));
                } else {
                    ISourceType topLevelType = (ISourceType)suppliedType;
                    while (topLevelType.getEnclosingType() != null) {
                        topLevelType = topLevelType.getEnclosingType();
                    }
                    CompilationResult result = new CompilationResult(topLevelType.getFileName(), 1, 1, this.options.maxProblemsPerUnit);
                    CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{topLevelType}, false, true, false, this.lookupEnvironment.problemReporter, result);
                    if (unit != null) {
                        this.lookupEnvironment.buildTypeBindings(unit);
                        this.rememberWithMemberTypes(topLevelType, unit.types[0].binding);
                        this.lookupEnvironment.completeTypeBindings(unit, false);
                    }
                }
                this.reportHierarchy();
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.reset();
            throw throwable;
        }
        Object var5_7 = null;
        this.reset();
    }

    public ReferenceBinding setFocusType(char[][] compoundName) {
        if (compoundName == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(compoundName);
        if (this.focusType == null) {
            this.focusType = this.lookupEnvironment.askForType(compoundName);
        }
        return this.focusType;
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, IHierarchyRequestor requestor) {
        this.lookupEnvironment = lookupEnvironment;
        this.requestor = requestor;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    public boolean subOrSuperOfFocus(ReferenceBinding typeBinding) {
        if (this.focusType == null) {
            return true;
        }
        if (this.subTypeOfType(this.focusType, typeBinding)) {
            return true;
        }
        return this.subTypeOfType(typeBinding, this.focusType);
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding) {
        if (typeBinding == null || subType == null) {
            return false;
        }
        if (subType == typeBinding) {
            return true;
        }
        ReferenceBinding superclass = subType.superclass();
        if (this.subTypeOfType(superclass, typeBinding)) {
            return true;
        }
        ReferenceBinding[] superInterfaces = subType.superInterfaces();
        if (superInterfaces != null) {
            int i = 0;
            int length = superInterfaces.length;
            while (i < length) {
                if (this.subTypeOfType(superInterfaces[i], typeBinding)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    public class MissingType
    implements IGenericType {
        public String simpleName;

        public MissingType(String simpleName) {
            this.simpleName = simpleName;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isBinaryType() {
            return false;
        }

        public boolean isClass() {
            return false;
        }

        public boolean isInterface() {
            return false;
        }

        public char[] getFileName() {
            return null;
        }

        public String toString() {
            return "Missing type: " + this.simpleName;
        }
    }
}

