/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.CommitWorkingCopyOperation;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.DestroyWorkingCopyOperation;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopyElementInfo;

public class WorkingCopy
extends CompilationUnit {
    protected IBufferFactory bufferFactory;
    protected IProblemRequestor problemRequestor;
    protected int useCount = 1;

    protected WorkingCopy(IPackageFragment parent, String name, IBufferFactory bufferFactory) {
        this(parent, name, bufferFactory, null);
    }

    protected WorkingCopy(IPackageFragment parent, String name, IBufferFactory bufferFactory, IProblemRequestor problemRequestor) {
        super(parent, name);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager().getDefaultBufferFactory() : bufferFactory;
        this.problemRequestor = problemRequestor;
    }

    public void commit(boolean force, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit original = (ICompilationUnit)this.getOriginalElement();
        if (original.exists()) {
            CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
            JavaElement.runOperation(op, monitor);
        } else {
            String encoding = this.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
            String contents = this.getSource();
            if (contents == null) {
                return;
            }
            try {
                byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                IFile originalRes = (IFile)original.getResource();
                if (originalRes.exists()) {
                    originalRes.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    originalRes.create((InputStream)stream, force, monitor);
                }
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new JavaModelException(e, 985);
            }
        }
    }

    protected OpenableElementInfo createElementInfo() {
        return new WorkingCopyElementInfo();
    }

    public void destroy() {
        if (--this.useCount > 0) {
            if (CompilationUnit.SHARED_WC_VERBOSE) {
                System.out.println("Decrementing use count of shared working copy " + this.toStringWithAncestors());
            }
            return;
        }
        try {
            DestroyWorkingCopyOperation op = new DestroyWorkingCopyOperation(this);
            JavaElement.runOperation(op, null);
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object getElementInfo() throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean shouldPerformProblemDetection = false;
        JavaModelManager javaModelManager = manager;
        synchronized (javaModelManager) {
            Object info = manager.getInfo(this);
            if (info == null) {
                shouldPerformProblemDetection = true;
            }
        }
        Object info = super.getElementInfo();
        if (this.problemRequestor != null && shouldPerformProblemDetection && this.problemRequestor.isActive()) {
            this.problemRequestor.beginReporting();
            CompilationUnitProblemFinder.process(this, this.problemRequestor, null);
            this.problemRequestor.endReporting();
        }
        return info;
    }

    public IJavaElement getOriginal(IJavaElement workingCopyElement) {
        int javaElementType = workingCopyElement.getElementType();
        if (javaElementType < 5 || javaElementType == 6) {
            return null;
        }
        if (workingCopyElement instanceof BinaryMember) {
            return null;
        }
        IJavaElement parent = workingCopyElement.getParent();
        ArrayList<IJavaElement> hierarchy = new ArrayList<IJavaElement>(4);
        while (parent.getElementType() > 5) {
            hierarchy.add(parent);
            parent = parent.getParent();
        }
        if (parent.getElementType() == 5) {
            hierarchy.add(((ICompilationUnit)parent).getOriginalElement());
        }
        ICompilationUnit cu = (ICompilationUnit)this.getOriginalElement();
        if (javaElementType == 5) {
            parent = workingCopyElement;
        }
        if (((ICompilationUnit)parent).isWorkingCopy() && !((ICompilationUnit)parent).getOriginalElement().equals(cu)) {
            return null;
        }
        switch (javaElementType) {
            case 11: {
                return cu.getPackageDeclaration(workingCopyElement.getElementName());
            }
            case 12: {
                return cu.getImportContainer();
            }
            case 13: {
                return cu.getImport(workingCopyElement.getElementName());
            }
            case 7: {
                if (hierarchy.size() == 1) {
                    return cu.getType(workingCopyElement.getElementName());
                }
                return this.getOriginalType(hierarchy).getType(workingCopyElement.getElementName());
            }
            case 9: {
                IType type;
                if (hierarchy.size() == 2) {
                    String typeName = ((IJavaElement)hierarchy.get(0)).getElementName();
                    type = cu.getType(typeName);
                } else {
                    type = this.getOriginalType(hierarchy);
                }
                return type.getMethod(workingCopyElement.getElementName(), ((IMethod)workingCopyElement).getParameterTypes());
            }
            case 8: {
                IType type;
                if (hierarchy.size() == 2) {
                    String typeName = ((IJavaElement)hierarchy.get(0)).getElementName();
                    type = cu.getType(typeName);
                } else {
                    type = this.getOriginalType(hierarchy);
                }
                return type.getField(workingCopyElement.getElementName());
            }
            case 10: {
                IType type;
                if (hierarchy.size() == 2) {
                    String typeName = ((IJavaElement)hierarchy.get(0)).getElementName();
                    type = cu.getType(typeName);
                } else {
                    type = this.getOriginalType(hierarchy);
                }
                return type.getInitializer(((Initializer)workingCopyElement).getOccurrenceCount());
            }
            case 5: {
                return cu;
            }
        }
        return null;
    }

    public IJavaElement getOriginalElement() {
        return new CompilationUnit((IPackageFragment)this.getParent(), this.getElementName());
    }

    protected IType getOriginalType(ArrayList hierarchy) {
        int size = hierarchy.size() - 1;
        ICompilationUnit typeCU = (ICompilationUnit)hierarchy.get(size);
        String typeName = ((IJavaElement)hierarchy.get(size - 1)).getElementName();
        IType type = typeCU.getType(typeName);
        size -= 2;
        while (size > -1) {
            typeName = ((IJavaElement)hierarchy.get(size)).getElementName();
            type = type.getType(typeName);
            --size;
        }
        return type;
    }

    public IResource getResource() {
        return null;
    }

    public IJavaElement getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws JavaModelException {
        return this;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        return null;
    }

    public IJavaElement getWorkingCopy() throws JavaModelException {
        return this;
    }

    public IJavaElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws JavaModelException {
        return this;
    }

    public boolean isBasedOn(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        try {
            return ((CompilationUnitElementInfo)this.getElementInfo()).fTimestamp == ((IFile)resource).getModificationStamp();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void makeConsistent(IProgressMonitor monitor) throws JavaModelException {
        if (!this.isConsistent()) {
            super.makeConsistent(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (this.problemRequestor != null && this.problemRequestor.isActive()) {
                this.problemRequestor.beginReporting();
                CompilationUnitProblemFinder.process(this, this.problemRequestor, monitor);
                this.problemRequestor.endReporting();
            }
        }
    }

    public void open(IProgressMonitor monitor) throws JavaModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (this.problemRequestor != null && this.problemRequestor.isActive()) {
            this.problemRequestor.beginReporting();
            CompilationUnitProblemFinder.process(this, this.problemRequestor, monitor);
            this.problemRequestor.endReporting();
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws JavaModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            ICompilationUnit original = (ICompilationUnit)this.getOriginalElement();
            if (original.isOpen()) {
                buffer.setContents(original.getSource());
            } else {
                IFile file = (IFile)original.getResource();
                if (file == null || !file.exists()) {
                    buffer.setContents(CharOperation.NO_CHAR);
                } else {
                    buffer.setContents(Util.getResourceContentsAsCharArray(file));
                }
            }
        }
        this.getBufferManager().addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    protected void openParent(IProgressMonitor pm) throws JavaModelException {
        block2: {
            try {
                super.openParent(pm);
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block2;
                throw e;
            }
        }
    }

    public IMarker[] reconcile() throws JavaModelException {
        this.reconcile(false, null);
        return null;
    }

    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws JavaModelException {
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection);
        JavaElement.runOperation(op, monitor);
    }

    public void restore() throws JavaModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        CompilationUnit original = (CompilationUnit)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new WorkingCopy((IPackageFragment)((JavaElement)this.fParent).rootedAt(project), this.fName, this.bufferFactory);
    }

    public void save(IProgressMonitor pm, boolean force) throws JavaModelException {
        if (this.isReadOnly()) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("[Working copy] ");
        super.toStringInfo(0, buffer, info);
    }

    protected void updateTimeStamp(CompilationUnit original) throws JavaModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new JavaModelException(new JavaModelStatus(995));
        }
        ((CompilationUnitElementInfo)this.getElementInfo()).fTimestamp = timeStamp;
    }
}

