/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;

    public ClassScope(Scope parent, TypeDeclaration context) {
        super(3, parent);
        this.referenceContext = context;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding enclosingType, ReferenceBinding supertype) {
        LocalTypeBinding anonymousType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (supertype.isInterface()) {
            sourceType.superclass = this.getJavaLangObject();
            sourceType.superInterfaces = new ReferenceBinding[]{supertype};
        } else {
            sourceType.superclass = supertype;
            sourceType.superInterfaces = TypeBinding.NoSuperInterfaces;
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        anonymousType.faultInTypesForFieldsAndMethods();
        sourceType.verifyMethods(this.environment().methodVerifier());
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        if (this.referenceContext.fields == null) {
            this.referenceContext.binding.fields = TypeConstants.NoFields;
            return;
        }
        FieldDeclaration[] fields = this.referenceContext.fields;
        int size = fields.length;
        int count = 0;
        int i = 0;
        while (i < size) {
            if (fields[i].isField()) {
                ++count;
            }
            ++i;
        }
        FieldBinding[] fieldBindings = new FieldBinding[count];
        HashtableOfObject knownFieldNames = new HashtableOfObject(count);
        boolean duplicate = false;
        count = 0;
        int i2 = 0;
        while (i2 < size) {
            FieldDeclaration field = fields[i2];
            if (!field.isField()) {
                if (this.referenceContext.binding.isInterface()) {
                    this.problemReporter().interfaceCannotHaveInitializers(this.referenceContext.binding, field);
                }
            } else {
                fieldBinding = new FieldBinding(field, null, this.referenceContext.binding);
                this.checkAndSetModifiersForField(fieldBinding, field);
                if (knownFieldNames.containsKey(field.name)) {
                    duplicate = true;
                    FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                    if (previousBinding != null) {
                        int f = 0;
                        while (f < i2) {
                            FieldDeclaration previousField = fields[f];
                            if (previousField.binding == previousBinding) {
                                this.problemReporter().duplicateFieldInType(this.referenceContext.binding, previousField);
                                previousField.binding = null;
                                break;
                            }
                            ++f;
                        }
                    }
                    knownFieldNames.put(field.name, null);
                    this.problemReporter().duplicateFieldInType(this.referenceContext.binding, field);
                    field.binding = null;
                } else {
                    knownFieldNames.put(field.name, fieldBinding);
                    if (fieldBinding != null) {
                        fieldBindings[count++] = fieldBinding;
                    }
                }
            }
            ++i2;
        }
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[knownFieldNames.size() - 1];
            size = count;
            count = 0;
            int i3 = 0;
            while (i3 < size) {
                fieldBinding = fieldBindings[i3];
                if (knownFieldNames.get(fieldBinding.name) != null) {
                    newFieldBindings[count++] = fieldBinding;
                }
                ++i3;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        i = 0;
        while (i < count) {
            fieldBindings[i].id = i;
            ++i;
        }
        this.referenceContext.binding.fields = fieldBindings;
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.isMemberType() && !sourceType.isLocalType()) {
            ((MemberTypeBinding)sourceType).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int i = 0;
        int length = memberTypes.length;
        while (i < length) {
            ((SourceTypeBinding)memberTypes[i]).scope.buildFieldsAndMethods();
            ++i;
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localType = new LocalTypeBinding(this, enclosingType);
        this.referenceContext.binding = localType;
        this.checkAndSetModifiers();
        ReferenceBinding[] memberTypeBindings = TypeConstants.NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            int i = 0;
            while (i < size) {
                block8: {
                    MemberTypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                    if (memberContext.isInterface()) {
                        this.problemReporter().nestedClassCannotDeclareInterface(memberContext);
                    } else {
                        ReferenceBinding type = localType;
                        do {
                            if (!CharOperation.equals(type.sourceName, memberContext.name)) continue;
                            this.problemReporter().hidingEnclosingType(memberContext);
                            break block8;
                        } while ((type = ((ReferenceBinding)type).enclosingType()) != null);
                        int j = 0;
                        while (j < i) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) {
                                this.problemReporter().duplicateNestedType(memberContext);
                                break block8;
                            }
                            ++j;
                        }
                        ClassScope memberScope = new ClassScope(this, this.referenceContext.memberTypes[i]);
                        LocalTypeBinding memberBinding = memberScope.buildLocalType(localType, packageBinding);
                        memberBinding.setAsMemberType();
                        memberTypeBindings[count++] = memberBinding;
                    }
                }
                ++i;
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        localType.memberTypes = memberTypeBindings;
        return localType;
    }

    void buildLocalTypeBinding(SourceTypeBinding enclosingType) {
        LocalTypeBinding localType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        this.connectTypeHierarchy();
        this.buildFieldsAndMethods();
        localType.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMethods() {
        if (this.referenceContext.methods == null) {
            this.referenceContext.binding.methods = TypeConstants.NoMethods;
            return;
        }
        AbstractMethodDeclaration[] methods = this.referenceContext.methods;
        int size = methods.length;
        int clinitIndex = -1;
        int i = 0;
        while (i < size) {
            if (methods[i] instanceof Clinit) {
                clinitIndex = i;
                break;
            }
            ++i;
        }
        MethodBinding[] methodBindings = new MethodBinding[clinitIndex == -1 ? size : size - 1];
        int count = 0;
        int i2 = 0;
        while (i2 < size) {
            MethodScope scope;
            MethodBinding methodBinding;
            if (i2 != clinitIndex && (methodBinding = (scope = new MethodScope(this, methods[i2], false)).createMethod(methods[i2])) != null) {
                methodBindings[count++] = methodBinding;
            }
            ++i2;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        this.referenceContext.binding.methods = methodBindings;
        this.referenceContext.binding.modifiers |= 0x2000000;
    }

    SourceTypeBinding buildType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        char[][] className;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (enclosingType == null) {
            className = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding(className, packageBinding, this);
        } else {
            className = CharOperation.deepCopy(enclosingType.compoundName);
            className[className.length - 1] = CharOperation.concat(className[className.length - 1], this.referenceContext.name, '$');
            this.referenceContext.binding = new MemberTypeBinding(className, this, enclosingType);
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        sourceType.fPackage.addType(sourceType);
        this.checkAndSetModifiers();
        ReferenceBinding[] memberTypeBindings = TypeConstants.NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            int i = 0;
            while (i < size) {
                block10: {
                    MemberTypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                    if (memberContext.isInterface() && sourceType.isNestedType() && sourceType.isClass() && !sourceType.isStatic()) {
                        this.problemReporter().nestedClassCannotDeclareInterface(memberContext);
                    } else {
                        ReferenceBinding type = sourceType;
                        do {
                            if (!CharOperation.equals(type.sourceName, memberContext.name)) continue;
                            this.problemReporter().hidingEnclosingType(memberContext);
                            break block10;
                        } while ((type = type.enclosingType()) != null);
                        int j = 0;
                        while (j < i) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) {
                                this.problemReporter().duplicateNestedType(memberContext);
                                break block10;
                            }
                            ++j;
                        }
                        ClassScope memberScope = new ClassScope(this, memberContext);
                        memberTypeBindings[count++] = memberScope.buildType(sourceType, packageBinding);
                    }
                }
                ++i;
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        sourceType.memberTypes = memberTypeBindings;
        return sourceType;
    }

    private void checkAndSetModifiers() {
        int unexpectedModifiers;
        int realModifiers;
        SourceTypeBinding sourceType = this.referenceContext.binding;
        int modifiers = sourceType.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceType);
        }
        ReferenceBinding enclosingType = sourceType.enclosingType();
        boolean isMemberType = sourceType.isMemberType();
        if (isMemberType) {
            if (enclosingType.isStrictfp()) {
                modifiers |= 0x800;
            }
            if (enclosingType.isDeprecated()) {
                modifiers |= 0x200000;
            }
            if (enclosingType.isInterface()) {
                modifiers |= 1;
            }
        } else if (sourceType.isLocalType()) {
            ReferenceContext refContext;
            if (sourceType.isAnonymousType()) {
                modifiers |= 0x10;
            }
            if ((refContext = this.methodScope().referenceContext) instanceof TypeDeclaration) {
                SourceTypeBinding type = ((TypeDeclaration)refContext).binding;
                if (type.isStrictfp()) {
                    modifiers |= 0x800;
                }
                if (type.isDeprecated()) {
                    modifiers |= 0x200000;
                }
            } else {
                MethodBinding method = ((AbstractMethodDeclaration)refContext).binding;
                if (method != null) {
                    if (method.isStrictfp()) {
                        modifiers |= 0x800;
                    }
                    if (method.isDeprecated()) {
                        modifiers |= 0x200000;
                    }
                }
            }
        }
        if (((realModifiers = modifiers & 0xFFFF) & 0x200) != 0) {
            if (isMemberType) {
                unexpectedModifiers = -3600;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForMemberInterface(sourceType);
                }
            } else {
                unexpectedModifiers = -3586;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForInterface(sourceType);
                }
            }
            modifiers |= 0x400;
        } else {
            if (isMemberType) {
                unexpectedModifiers = -3104;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceType);
                }
            } else if (sourceType.isLocalType()) {
                unexpectedModifiers = -3089;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceType);
                }
            } else {
                unexpectedModifiers = -3090;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForClass(sourceType);
                }
            }
            if ((realModifiers & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceType);
            }
        }
        if (isMemberType) {
            if (enclosingType.isInterface()) {
                if ((realModifiers & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceType);
                    if ((realModifiers & 4) != 0) {
                        modifiers ^= 4;
                    }
                    if ((realModifiers & 2) != 0) {
                        modifiers ^= 2;
                    }
                }
            } else {
                int accessorBits = realModifiers & 7;
                if ((accessorBits & accessorBits - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceType);
                    if ((accessorBits & 1) != 0) {
                        if ((accessorBits & 4) != 0) {
                            modifiers ^= 4;
                        }
                        if ((accessorBits & 2) != 0) {
                            modifiers ^= 2;
                        }
                    }
                    if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                        modifiers ^= 2;
                    }
                }
            }
            if ((realModifiers & 8) == 0) {
                if (enclosingType.isInterface()) {
                    modifiers |= 8;
                }
            } else if (!enclosingType.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceType);
            }
        }
        sourceType.modifiers = modifiers;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDecl) {
        int accessorBits;
        int modifiers = fieldBinding.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (fieldBinding.declaringClass.isInterface()) {
            int expectedValue = 25;
            if (((modifiers |= expectedValue) & 0xFFFF) != expectedValue) {
                this.problemReporter().illegalModifierForInterfaceField(fieldBinding.declaringClass, fieldDecl);
            }
            fieldBinding.modifiers = modifiers;
            return;
        }
        int realModifiers = modifiers & 0xFFFF;
        int unexpectedModifiers = -224;
        if ((realModifiers & unexpectedModifiers) != 0) {
            this.problemReporter().illegalModifierForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(fieldBinding.declaringClass, fieldDecl);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers ^= 4;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers ^= 2;
                }
            }
            if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers ^= 2;
            }
        }
        if ((realModifiers & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (fieldDecl.initialization == null && (modifiers & 0x10) != 0) {
            modifiers |= 0x4000000;
        }
        fieldBinding.modifiers = modifiers;
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceType) {
        ReferenceBinding currentType = sourceType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        while ((currentType.tagBits & 0x4000) == 0) {
            if (currentType.memberTypes() != TypeConstants.NoMemberTypes) {
                return;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) != null) continue;
        }
        boolean hasMembers = false;
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800) == 0) {
                        anInterface.tagBits |= 0x800;
                        if ((anInterface.tagBits & 0x4000) == 0) {
                            if (anInterface.memberTypes() != TypeConstants.NoMemberTypes) {
                                hasMembers = true;
                                break block1;
                            }
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    if (!hasMembers) {
                        interfaces[j].tagBits |= 0x4000;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!hasMembers) {
            currentType = sourceType;
            do {
                currentType.tagBits |= 0x4000;
            } while ((currentType = currentType.superclass()) != null);
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.memberTypes != TypeConstants.NoMemberTypes) {
            int i = 0;
            int size = sourceType.memberTypes.length;
            while (i < size) {
                ((SourceTypeBinding)sourceType.memberTypes[i]).scope.connectTypeHierarchy();
                ++i;
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (this.isJavaLangObject(sourceType)) {
            sourceType.superclass = null;
            sourceType.superInterfaces = TypeConstants.NoSuperInterfaces;
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceType);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            sourceType.superclass = this.getJavaLangObject();
            return !this.detectCycle(sourceType, sourceType.superclass, null);
        }
        ReferenceBinding superclass = this.findSupertype(this.referenceContext.superclass);
        if (superclass != null) {
            if (!superclass.isValidBinding()) {
                this.problemReporter().invalidSuperclass(sourceType, this.referenceContext.superclass, superclass);
            } else if (superclass.isInterface()) {
                this.problemReporter().superclassMustBeAClass(sourceType, this.referenceContext.superclass, superclass);
            } else if (superclass.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceType, this.referenceContext.superclass, superclass);
            } else {
                this.referenceContext.superclass.resolvedType = superclass;
                sourceType.superclass = superclass;
                return true;
            }
        }
        sourceType.tagBits |= 0x8000;
        sourceType.superclass = this.getJavaLangObject();
        if ((sourceType.superclass.tagBits & 0x100) == 0) {
            this.detectCycle(sourceType, sourceType.superclass, null);
        }
        return false;
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        sourceType.superInterfaces = TypeConstants.NoSuperInterfaces;
        if (this.referenceContext.superInterfaces == null) {
            return true;
        }
        if (this.isJavaLangObject(sourceType)) {
            return true;
        }
        boolean noProblems = true;
        int length = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] interfaceBindings = new ReferenceBinding[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            block13: {
                ReferenceBinding superInterface = this.findSupertype(this.referenceContext.superInterfaces[i]);
                if (superInterface == null) {
                    noProblems = false;
                } else if (!superInterface.isValidBinding()) {
                    this.problemReporter().invalidSuperinterface(sourceType, this.referenceContext.superInterfaces[i], superInterface);
                    sourceType.tagBits |= 0x8000;
                    noProblems = false;
                } else {
                    int k = 0;
                    while (k < count) {
                        if (interfaceBindings[k] == superInterface) {
                            this.problemReporter().duplicateSuperinterface(sourceType, this.referenceContext, superInterface);
                            break block13;
                        }
                        ++k;
                    }
                    if (superInterface.isClass()) {
                        this.problemReporter().superinterfaceMustBeAnInterface(sourceType, this.referenceContext, superInterface);
                        sourceType.tagBits |= 0x8000;
                        noProblems = false;
                    } else {
                        this.referenceContext.superInterfaces[i].resolvedType = superInterface;
                        interfaceBindings[count++] = superInterface;
                    }
                }
            }
            ++i;
        }
        if (count > 0) {
            if (count != length) {
                ReferenceBinding[] referenceBindingArray = interfaceBindings;
                interfaceBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, interfaceBindings, 0, count);
            }
            sourceType.superInterfaces = interfaceBindings;
        }
        return noProblems;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100) == 0) {
            boolean noProblems = true;
            sourceType.tagBits |= 0x100;
            if (sourceType.isClass()) {
                noProblems &= this.connectSuperclass();
            }
            sourceType.tagBits |= 0x200;
            if ((noProblems &= this.connectSuperInterfaces()) && sourceType.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceType);
            }
        }
        this.connectMemberTypes();
        this.checkForInheritedMemberTypes(sourceType);
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100) != 0) {
            return;
        }
        boolean noProblems = true;
        sourceType.tagBits |= 0x100;
        if (sourceType.isClass()) {
            noProblems &= this.connectSuperclass();
        }
        sourceType.tagBits |= 0x200;
        if ((noProblems &= this.connectSuperInterfaces()) && sourceType.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceType);
        }
    }

    private boolean detectCycle(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        if (sourceType == superType) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x8000;
            return true;
        }
        if (superType.isBinaryBinding()) {
            ReferenceBinding[] itsInterfaces;
            boolean hasCycle = false;
            if (superType.superclass() != null) {
                if (sourceType == superType.superclass()) {
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x8000;
                    superType.tagBits |= 0x8000;
                    return true;
                }
                hasCycle |= this.detectCycle(sourceType, superType.superclass(), reference);
                if ((superType.superclass().tagBits & 0x8000) != 0) {
                    sourceType.tagBits |= 0x8000;
                    superType.tagBits |= 0x8000;
                }
            }
            if ((itsInterfaces = superType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                int i = 0;
                int length = itsInterfaces.length;
                while (i < length) {
                    ReferenceBinding anInterface = itsInterfaces[i];
                    if (sourceType == anInterface) {
                        this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                        sourceType.tagBits |= 0x8000;
                        superType.tagBits |= 0x8000;
                        return true;
                    }
                    hasCycle |= this.detectCycle(sourceType, anInterface, reference);
                    if ((anInterface.tagBits & 0x8000) != 0) {
                        sourceType.tagBits |= 0x8000;
                        superType.tagBits |= 0x8000;
                    }
                    ++i;
                }
            }
            return hasCycle;
        }
        if ((superType.tagBits & 0x200) == 0 && (superType.tagBits & 0x100) != 0) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x8000;
            superType.tagBits |= 0x8000;
            return true;
        }
        if ((superType.tagBits & 0x100) == 0) {
            ((SourceTypeBinding)superType).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((superType.tagBits & 0x8000) != 0) {
            sourceType.tagBits |= 0x8000;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        ReferenceBinding superType;
        block9: {
            typeReference.aboutToResolve(this);
            char[][] compoundName = typeReference.getTypeName();
            this.compilationUnitScope().recordQualifiedReference(compoundName);
            SourceTypeBinding sourceType = this.referenceContext.binding;
            int size = compoundName.length;
            int n = 1;
            if (CharOperation.equals(compoundName[0], sourceType.sourceName)) {
                superType = sourceType;
            } else {
                Binding typeOrPackage = this.parent.getTypeOrPackage(compoundName[0], 20);
                if (typeOrPackage == null || !typeOrPackage.isValidBinding()) {
                    return new ProblemReferenceBinding(compoundName[0], typeOrPackage == null ? 1 : typeOrPackage.problemId());
                }
                boolean checkVisibility = false;
                while (n < size) {
                    if (!(typeOrPackage instanceof PackageBinding)) break;
                    PackageBinding packageBinding = (PackageBinding)typeOrPackage;
                    if ((typeOrPackage = packageBinding.getTypeOrPackage(compoundName[n])) == null || !typeOrPackage.isValidBinding()) {
                        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n + 1), typeOrPackage == null ? 1 : typeOrPackage.problemId());
                    }
                    checkVisibility = true;
                    ++n;
                }
                if (typeOrPackage instanceof PackageBinding) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), 1);
                }
                superType = (ReferenceBinding)typeOrPackage;
                this.compilationUnitScope().recordTypeReference(superType);
                if (checkVisibility && n == size && !superType.canBeSeenBy(sourceType.fPackage)) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), (Binding)superType, 2);
                }
            }
            do {
                char[] typeName;
                if (this.detectCycle(sourceType, superType, typeReference)) {
                    return null;
                }
                if (n >= size) break block9;
                if ((superType = this.findMemberType(typeName = compoundName[n++], superType)) != null) continue;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), 1);
            } while (superType.isValidBinding());
            superType.compoundName = CharOperation.subarray(compoundName, 0, n);
            return superType;
        }
        return superType;
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

