/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration {
    public Block block;
    public int lastFieldID;
    public int bodyStart;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.sourceStart = this.bodyStart = block.sourceStart;
        this.declarationSourceStart = this.bodyStart;
    }

    public FlowInfo analyseCode(MethodScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.block.analyseCode(currentScope, flowContext, flowInfo);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.block.generateCode(currentScope, codeStream);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isField() {
        return false;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration unit) {
        parser.parse(this, typeDeclaration, unit);
    }

    public void resolve(MethodScope scope) {
        int previous = scope.fieldDeclarationIndex;
        try {
            SourceTypeBinding declaringType;
            scope.fieldDeclarationIndex = this.lastFieldID;
            if (this.isStatic() && (declaringType = scope.enclosingSourceType()).isNestedType() && !declaringType.isStatic()) {
                scope.problemReporter().innerTypesCannotDeclareStaticInitializers(declaringType, this);
            }
            this.block.resolve(scope);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            scope.fieldDeclarationIndex = previous;
            throw throwable;
        }
        Object var4_6 = null;
        scope.fieldDeclarationIndex = previous;
    }

    public String toString(int tab) {
        if (this.modifiers != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(AstNode.tabString(tab));
            buffer.append(AstNode.modifiersString(this.modifiers));
            buffer.append("{\n");
            buffer.append(this.block.toStringStatements(tab));
            buffer.append(AstNode.tabString(tab));
            buffer.append("}");
            return buffer.toString();
        }
        return this.block.toString(tab);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

