/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IndexSearchAdapter;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.core.search.PathCollector;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.Util;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator2;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class SearchEngine {
    private IWorkingCopy[] workingCopies = null;
    public static boolean VERBOSE = false;

    public SearchEngine() {
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    /*
     * Unable to fully structure code
     */
    private IWorkingCopy[] filterWorkingCopies(IWorkingCopy[] workingCopies, IJavaElement focus, boolean isPolymorphicSearch) {
        if (focus != null && workingCopies != null) ** GOTO lbl4
        return workingCopies;
lbl-1000:
        // 1 sources

        {
            focus = focus.getParent();
lbl4:
            // 2 sources

            ** while (!(focus instanceof IJavaProject) && !(focus instanceof JarPackageFragmentRoot))
        }
lbl5:
        // 1 sources

        length = workingCopies.length;
        result = null;
        index = -1;
        i = 0;
        while (i < length) {
            workingCopy = workingCopies[i];
            projectOrJar = IndexSelector.getProjectOrJar((IJavaElement)workingCopy).getPath();
            if (!IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                if (result == null) {
                    result = new IWorkingCopy[length - 1];
                    System.arraycopy(workingCopies, 0, result, 0, i);
                    index = i;
                }
            } else if (result != null) {
                result[index++] = workingCopy;
            }
            ++i;
        }
        if (result != null) {
            if (result.length != index) {
                v0 = result;
                result = new IWorkingCopy[index];
                System.arraycopy(v0, 0, result, 0, index);
            }
            return result;
        }
        return workingCopies;
    }

    public static IJavaSearchScope createHierarchyScope(IType type) throws JavaModelException {
        return new HierarchyScope(type);
    }

    public static IJavaSearchScope createJavaSearchScope(IResource[] resources) {
        int length = resources.length;
        IJavaElement[] elements = new IJavaElement[length];
        int i = 0;
        while (i < length) {
            elements[i] = JavaCore.create(resources[i]);
            ++i;
        }
        return SearchEngine.createJavaSearchScope(elements);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, boolean includeReferencedProjects) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof IJavaProject) {
                        scope.add((IJavaProject)element, includeReferencedProjects, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static ISearchPattern createOrSearchPattern(ISearchPattern leftPattern, ISearchPattern rightPattern) {
        return new OrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
    }

    public static ISearchPattern createSearchPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        return SearchPattern.createPattern(stringPattern, searchFor, limitTo, matchMode, isCaseSensitive);
    }

    public static ISearchPattern createSearchPattern(IJavaElement element, int limitTo) {
        return SearchPattern.createPattern(element, limitTo);
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return new JavaWorkspaceScope();
    }

    private IResource getResource(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null) {
            if (cu.isWorkingCopy()) {
                return cu.getOriginalElement().getResource();
            }
            return cu.getResource();
        }
        return element.getResource();
    }

    private IWorkingCopy[] getWorkingCopies(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null && cu.isWorkingCopy()) {
            int length;
            int n = length = this.workingCopies == null ? 0 : this.workingCopies.length;
            if (length > 0) {
                IWorkingCopy[] newWorkingCopies = new IWorkingCopy[length + 1];
                System.arraycopy(this.workingCopies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new IWorkingCopy[]{cu};
        }
        return this.workingCopies;
    }

    public void search(IWorkspace workspace, String patternString, int searchFor, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(patternString, searchFor, limitTo, true), scope, resultCollector);
    }

    public void search(IWorkspace workspace, IJavaElement element, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(element, limitTo), scope, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        if (VERBOSE) {
            System.out.println("Searching for " + searchPattern + " in " + scope);
        }
        resultCollector.aboutToStart();
        try {
            if (searchPattern == null) {
                Object var11_5 = null;
                resultCollector.done();
                return;
            }
            IProgressMonitor progressMonitor = resultCollector.getProgressMonitor();
            if (progressMonitor != null) {
                progressMonitor.beginTask(Util.bind("engine.searching"), 100);
            }
            PathCollector pathCollector = new PathCollector();
            SearchPattern pattern = (SearchPattern)searchPattern;
            if (scope instanceof HierarchyScope) {
                ((HierarchyScope)scope).needsRefresh = false;
                pattern.needsResolve = true;
            }
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            int detailLevel = 6;
            MatchLocator2 matchLocator = new MatchLocator2(pattern, detailLevel, resultCollector, scope, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 95)));
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, pattern.focus, pattern.isPolymorphicSearch(), detailLevel, pathCollector, indexManager), 3, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 5)));
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ((MatchLocator)matchLocator).locateMatches(pathCollector.getPaths(), workspace, this.filterWorkingCopies(this.workingCopies, pattern.focus, pattern.isPolymorphicSearch()));
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            ((MatchLocator)matchLocator).locatePackageDeclarations(workspace);
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            resultCollector.done();
            throw throwable;
        }
        Object var11_7 = null;
        resultCollector.done();
    }

    public void searchAllTypeNames(IWorkspace workspace, char[] packageName, char[] typeName, int matchMode, boolean isCaseSensitive, int searchFor, IJavaSearchScope scope, final ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        block8: {
            char classOrInterface;
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            switch (searchFor) {
                case 5: {
                    classOrInterface = 'C';
                    break;
                }
                case 6: {
                    classOrInterface = 'I';
                    break;
                }
                default: {
                    classOrInterface = '\u0000';
                }
            }
            TypeDeclarationPattern pattern = new TypeDeclarationPattern(packageName, null, typeName, classOrInterface, matchMode, isCaseSensitive);
            IndexSearchAdapter searchRequestor = new IndexSearchAdapter(){

                public void acceptClassDeclaration(String resourcePath, char[] simpleTypeName, char[][] enclosingTypeNames, char[] pkgName) {
                    if (enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                        nameRequestor.acceptClass(pkgName, simpleTypeName, enclosingTypeNames, resourcePath);
                    }
                }

                public void acceptInterfaceDeclaration(String resourcePath, char[] simpleTypeName, char[][] enclosingTypeNames, char[] pkgName) {
                    if (enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                        nameRequestor.acceptInterface(pkgName, simpleTypeName, enclosingTypeNames, resourcePath);
                    }
                }
            };
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Util.bind("engine.searching"), 100);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, 3, searchRequestor, indexManager), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                throw throwable;
            }
            Object var15_17 = null;
            if (progressMonitor == null) break block8;
            progressMonitor.done();
        }
    }

    public void searchDeclarationsOfAccessedFields(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        if (resource instanceof IFile) {
            if (VERBOSE) {
                System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
            }
            MatchLocator2 locator = new MatchLocator2(pattern, 8, resultCollector, scope, resultCollector.getProgressMonitor());
            ((MatchLocator)locator).locateMatches(new String[]{resource.getFullPath().toString()}, workspace, this.getWorkingCopies(enclosingElement));
        } else {
            this.search(workspace, pattern, scope, resultCollector);
        }
    }

    public void searchDeclarationsOfReferencedTypes(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        if (resource instanceof IFile) {
            if (VERBOSE) {
                System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
            }
            MatchLocator2 locator = new MatchLocator2(pattern, 8, resultCollector, scope, resultCollector.getProgressMonitor());
            ((MatchLocator)locator).locateMatches(new String[]{resource.getFullPath().toString()}, workspace, this.getWorkingCopies(enclosingElement));
        } else {
            this.search(workspace, pattern, scope, resultCollector);
        }
    }

    public void searchDeclarationsOfSentMessages(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        if (resource instanceof IFile) {
            if (VERBOSE) {
                System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
            }
            MatchLocator2 locator = new MatchLocator2(pattern, 8, resultCollector, scope, resultCollector.getProgressMonitor());
            ((MatchLocator)locator).locateMatches(new String[]{resource.getFullPath().toString()}, workspace, this.getWorkingCopies(enclosingElement));
        } else {
            this.search(workspace, pattern, scope, resultCollector);
        }
    }
}

