/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.awt.Component;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import org.gjt.lindfors.util.Library;
import org.gjt.lindfors.util.Visualizable;

public abstract class EventGeneratorSupport
implements Serializable,
Cloneable,
Visualizable {
    private transient Vector list = null;
    private transient Vector clone = null;
    private final transient boolean[] MUTEX = new boolean[0];

    private Vector getListInstance() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.list == null) {
                this.list = new Vector();
                this.clone = (Vector)this.list.clone();
            }
        }
        return this.list;
    }

    public boolean hasListeners() {
        if (this.list == null) {
            return false;
        }
        return this.list.size() != 0;
    }

    protected Enumeration getListeners() {
        if (this.list == null) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }
        Vector vector = (Vector)this.list.clone();
        return vector.elements();
    }

    protected void addListener(EventListener eventListener) {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            Vector vector = this.getListInstance();
            if (!vector.contains(eventListener)) {
                vector.addElement(eventListener);
            }
        }
    }

    protected void removeListener(EventListener eventListener) {
        if (this.list != null) {
            this.list.removeElement(eventListener);
        }
    }

    public String toString() {
        int n = this.list == null ? 0 : this.getListInstance().size();
        return Library.getClassName(this) + "[Registered Listeners=" + n + "]";
    }

    public Component toComponent() {
        return null;
    }

    public Object clone() {
        return null;
    }
}

