/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Constructor;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseObjectNames;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.SequenceManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.Logger;

public class Database {
    int databaseID;
    private String sType;
    private String sName;
    private HsqlProperties urlProperties;
    private String sPath;
    private UserManager userManager;
    private HsqlArrayList tTable;
    DatabaseInformation dInfo;
    ClassLoader classLoader;
    private int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceSize;
    public boolean sqlEnforceStrictSize;
    public int firstIdentity;
    private HashMap hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    public SessionManager sessionManager;
    private HsqlDatabaseProperties databaseProperties;
    HsqlNameManager nameManager;
    DatabaseObjectNames triggerNameList;
    DatabaseObjectNames indexNameList;
    DatabaseObjectNames constraintNameList;
    public SequenceManager sequenceManager;
    CompiledStatementManager compiledStatementManager;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 4;
    public static final int DATABASE_CLOSING = 8;
    public static final int DATABASE_SHUTDOWN = 16;
    public static final int CLOSEMODE_IMMEDIATELY = -1;
    public static final int CLOSEMODE_NORMAL = 0;
    public static final int CLOSEMODE_COMPACT = 1;
    public static final int CLOSEMODE_SCRIPT = 2;
    private long dbSCN = 0L;
    private long ddlSCN = 0L;
    private long dmlSCN = 0L;
    private String uri;
    private FileAccess fileaccess;
    private boolean isStoredFileAccess;
    static /* synthetic */ Class class$java$lang$Object;

    Database(String string, String string2, String string3, HsqlProperties hsqlProperties) throws HsqlException {
        this.urlProperties = hsqlProperties;
        this.setState(16);
        this.sName = string3;
        this.sType = string;
        this.sPath = string2;
        if (this.sType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        try {
            this.classLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            this.classLoader = null;
        }
        String string4 = hsqlProperties.getProperty("fileaccess_class_name");
        if (string4 != null) {
            String string5 = hsqlProperties.getProperty("storage_key");
            try {
                Class<?> clazz = Class.forName(string4);
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = Database.class$("java.lang.Object")) : class$java$lang$Object);
                this.fileaccess = (FileAccess)constructor.newInstance(string5);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception exception) {
                System.out.println("Exception");
            }
        } else {
            this.fileaccess = new FileUtil();
        }
        this.logger = new Logger();
        this.compiledStatementManager = new CompiledStatementManager(this);
    }

    synchronized void open() throws HsqlException {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() throws HsqlException {
        this.setState(4);
        try {
            boolean bl;
            this.databaseProperties = new HsqlDatabaseProperties(this);
            boolean bl2 = bl = this.sType == "mem:" || !this.databaseProperties.checkFileExists();
            if (bl && this.urlProperties.isPropertyTrue("ifexists")) {
                throw Trace.error(94, this.sType + this.sPath);
            }
            this.databaseProperties.load();
            this.databaseProperties.setURLProperties(this.urlProperties);
            this.compiledStatementManager.reset();
            this.tTable = new HsqlArrayList();
            this.userManager = new UserManager();
            this.hAlias = Library.getAliasMap();
            this.nameManager = new HsqlNameManager();
            this.triggerNameList = new DatabaseObjectNames();
            this.indexNameList = new DatabaseObjectNames();
            this.constraintNameList = new DatabaseObjectNames();
            this.sequenceManager = new SequenceManager();
            this.bReferentialIntegrity = true;
            User user = this.userManager.createSysUser();
            this.sessionManager = new SessionManager(this, user);
            this.dInfo = DatabaseInformation.newDatabaseInformation(this);
            if (this.sType != "mem:") {
                this.logger.openLog(this);
            }
            if (bl) {
                this.sessionManager.getSysSession().sqlExecuteDirectNoPreChecks("CREATE USER SA PASSWORD \"\" ADMIN");
                this.logger.synchLogForce();
            }
            this.dInfo.setWithContent(true);
        }
        catch (Throwable throwable) {
            HsqlException hsqlException;
            this.logger.closeLog(-1);
            this.logger.releaseLock();
            this.setState(16);
            this.clearStructures();
            if (!(throwable instanceof HsqlException)) {
                hsqlException = Trace.error(40, throwable.toString());
            }
            throw (HsqlException)hsqlException;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.tTable != null) {
            for (int i = 0; i < this.tTable.size(); ++i) {
                Table table = (Table)this.tTable.get(i);
                table.dropTriggers();
            }
        }
        this.tTable = null;
        this.userManager = null;
        this.hAlias = null;
        this.nameManager = null;
        this.triggerNameList = null;
        this.constraintNameList = null;
        this.indexNameList = null;
        this.sequenceManager = null;
        this.sessionManager = null;
        this.dInfo = null;
    }

    public String getType() {
        return this.sType;
    }

    public String getPath() {
        return this.sPath;
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 16;
    }

    synchronized Session connect(String string, String string2) throws HsqlException {
        User user = this.userManager.getUser(string, string2);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly);
        this.logger.logConnectUser(session);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public HsqlArrayList getTables() {
        return this.tTable;
    }

    UserManager getUserManager() {
        return this.userManager;
    }

    public void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    HashMap getAliasMap() {
        return this.hAlias;
    }

    String getJavaName(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    public Table getTable(Session session, String string) throws HsqlException {
        Table table = this.findUserTable(session, string);
        if (table == null) {
            table = this.dInfo.getSystemTable(session, string);
        }
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    public Table getUserTable(Session session, String string) throws HsqlException {
        Table table = this.findUserTable(session, string);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    public Table findUserTable(String string) {
        int n = this.tTable.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)this.tTable.get(i);
            if (!table.tableName.name.equals(string)) continue;
            return table;
        }
        return null;
    }

    Table findUserTable(Session session, String string) {
        int n = this.tTable.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)this.tTable.get(i);
            if (!table.equals(session, string)) continue;
            return table;
        }
        return null;
    }

    void linkTable(Table table) {
        this.tTable.add(table);
    }

    void setIgnoreCase(boolean bl) {
        this.bIgnoreCase = bl;
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    Table findUserTableForIndex(Session session, String string) {
        HsqlNameManager.HsqlName hsqlName = this.indexNameList.getOwner(string);
        if (hsqlName == null) {
            return null;
        }
        return this.findUserTable(session, hsqlName.name);
    }

    int getTableIndex(Table table) {
        int n = this.tTable.size();
        for (int i = 0; i < n; ++i) {
            Table table2 = (Table)this.tTable.get(i);
            if (table2 != table) continue;
            return i;
        }
        return -1;
    }

    void dropIndex(Session session, String string, String string2, boolean bl) throws HsqlException {
        Table table = this.findUserTableForIndex(session, string);
        if (table == null) {
            if (bl) {
                return;
            }
            throw Trace.error(26, string);
        }
        if (string2 != null && !table.getName().name.equals(string2)) {
            throw Trace.error(26, string);
        }
        table.checkDropIndex(string, null, false);
        session.commit();
        session.setScripting(!table.isTemp());
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.dropIndex(string);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(-1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void close(int n) throws HsqlException {
        HsqlException hsqlException = null;
        this.setState(8);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        this.logger.closeLog(n);
        try {
            if (n == 1 && !this.filesReadOnly) {
                this.clearStructures();
                this.reopen();
                this.setState(8);
                this.logger.closeLog(0);
            }
        }
        catch (Throwable throwable) {
            hsqlException = throwable instanceof HsqlException ? (HsqlException)throwable : Trace.error(40, throwable.toString());
        }
        this.classLoader = null;
        this.logger.releaseLock();
        this.setState(16);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        if (hsqlException != null) {
            throw hsqlException;
        }
    }

    void dropTempTables(Session session) {
        int n = this.tTable.size();
        while (n-- > 0) {
            Table table = (Table)this.tTable.get(n);
            if (!table.isTemp() || table.getOwnerSessionId() != session.getId()) continue;
            this.tTable.remove(n);
        }
    }

    void dropTable(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        Table table = null;
        int n = -1;
        for (int i = 0; i < this.tTable.size(); ++i) {
            table = (Table)this.tTable.get(i);
            if (table.equals(session, string) && bl2 == table.isView()) {
                n = i;
                break;
            }
            table = null;
        }
        if (n == -1) {
            if (bl) {
                return;
            }
            throw Trace.error(bl2 ? 53 : 22, string);
        }
        if (!table.isTemp()) {
            session.checkDDLWrite();
        }
        if (bl2) {
            this.checkViewIsInView((View)table);
        } else {
            this.checkTableIsReferenced(table);
            this.checkTableIsInView(table.tableName.name);
        }
        this.tTable.remove(n);
        this.removeExportedKeys(table);
        this.userManager.removeDbObject(table.getName());
        this.triggerNameList.removeOwner(table.tableName);
        this.indexNameList.removeOwner(table.tableName);
        this.constraintNameList.removeOwner(table.tableName);
        table.dropTriggers();
        table.drop();
        session.setScripting(!table.isTemp());
        session.commit();
    }

    private void checkTableIsReferenced(Table table) throws HsqlException {
        Constraint[] constraintArray = table.getConstraints();
        Constraint constraint = null;
        Table table2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        for (int i = 0; i < constraintArray.length; ++i) {
            constraint = constraintArray[i];
            if (constraint.getType() != 1) continue;
            table2 = constraint.getRef();
            bl = table2 != null;
            boolean bl3 = bl2 = bl && table.equals(table2);
            if (!bl || bl2) continue;
            for (int j = 0; j < this.tTable.size(); ++j) {
                if (!table2.equals(this.tTable.get(j))) continue;
                n = j;
                break;
            }
            if (n == -1) continue;
            throw Trace.error(193, 101, new Object[]{constraint.getName().name, table2.getName().name});
        }
    }

    void checkViewIsInView(View view) throws HsqlException {
        View[] viewArray = this.getViewsWithView(view);
        if (viewArray != null) {
            throw Trace.error(194, viewArray[0].getName().name);
        }
    }

    void checkTableIsInView(String string) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(string, null);
        if (viewArray != null) {
            throw Trace.error(194, viewArray[0].getName().name);
        }
    }

    void checkSequenceIsInView(NumberSequence numberSequence) throws HsqlException {
        View[] viewArray = this.getViewsWithSequence(numberSequence);
        if (viewArray != null) {
            throw Trace.error(186, viewArray[0].getName().name);
        }
    }

    void checkColumnIsInView(String string, String string2) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(string, string2);
        if (viewArray != null) {
            throw Trace.error(197, viewArray[0].getName().name);
        }
    }

    private View[] getViewsWithView(View view) {
        HsqlArrayList hsqlArrayList = null;
        for (int i = 0; i < this.tTable.size(); ++i) {
            boolean bl;
            Table table = (Table)this.tTable.get(i);
            if (!table.isView() || !(bl = ((View)table).hasView(view))) continue;
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
            }
            hsqlArrayList.add(table);
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    private View[] getViewsWithTable(String string, String string2) {
        HsqlArrayList hsqlArrayList = null;
        for (int i = 0; i < this.tTable.size(); ++i) {
            boolean bl;
            Table table = (Table)this.tTable.get(i);
            if (!table.isView()) continue;
            boolean bl2 = bl = string2 == null ? ((View)table).hasTable(string) : ((View)table).hasColumn(string, string2);
            if (!bl) continue;
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
            }
            hsqlArrayList.add(table);
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    View[] getViewsWithSequence(NumberSequence numberSequence) {
        HsqlArrayList hsqlArrayList = null;
        for (int i = 0; i < this.tTable.size(); ++i) {
            boolean bl;
            Table table = (Table)this.tTable.get(i);
            if (!table.isView() || !(bl = ((View)table).hasSequence(numberSequence))) continue;
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
            }
            hsqlArrayList.add(table);
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    void recompileViews(String string) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(string, null);
        if (viewArray != null) {
            for (int i = 0; i < viewArray.length; ++i) {
                viewArray[i].compile();
            }
        }
    }

    void removeExportedKeys(Table table) {
        for (int i = 0; i < this.tTable.size(); ++i) {
            Table table2 = (Table)this.tTable.get(i);
            for (int j = table2.constraintList.length - 1; j >= 0; --j) {
                Table table3 = table2.constraintList[j].getRef();
                if (table != table3) continue;
                table2.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(table2.constraintList, null, j, -1);
            }
        }
    }

    void dropTrigger(Session session, String string) throws HsqlException {
        boolean bl = this.triggerNameList.containsName(string);
        Trace.check(bl, 43, string);
        HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.triggerNameList.removeName(string);
        Table table = this.findUserTable(session, hsqlName.name);
        table.dropTrigger(string);
        session.setScripting(!table.isTemp());
    }

    public void setMetaDirty(boolean bl) {
        if (this.dInfo != null) {
            this.dInfo.setDirty();
        }
        if (bl) {
            this.compiledStatementManager.resetStatements();
        }
    }

    synchronized long getSCN() {
        return this.dbSCN;
    }

    private synchronized void setSCN(long l) {
        this.dbSCN = l;
    }

    private synchronized long nextSCN() {
        ++this.dbSCN;
        return this.dbSCN;
    }

    synchronized long getDMLSCN() {
        return this.dmlSCN;
    }

    synchronized long nextDMLSCN() {
        this.dmlSCN = this.nextSCN();
        return this.dmlSCN;
    }

    private synchronized void setState(int n) {
        this.dbState = n;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int n = this.getState();
        switch (n) {
            case 8: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 4: {
                return "DATABASE_OPENING";
            }
            case 16: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String getURI() {
        return this.sName;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    public synchronized FileAccess getFileAccess() {
        return this.fileaccess;
    }

    public synchronized boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

