/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Iterator;

class Constraint {
    static final int CASCADE = 0;
    static final int SET_NULL = 2;
    static final int NO_ACTION = 3;
    static final int SET_DEFAULT = 4;
    static final int INIT_DEFERRED = 5;
    static final int INIT_IMMEDIATE = 6;
    static final int NOT_DEFERRABLE = 7;
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    static final int CHECK = 3;
    static final int PRIMARY_KEY = 4;
    ConstraintCore core;
    HsqlNameManager.HsqlName constName;
    int constType;

    Constraint(HsqlNameManager.HsqlName hsqlName, Table table, Index index) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.constType = 2;
        this.core.mainTable = table;
        this.core.mainIndex = index;
        this.core.mainColArray = ArrayUtil.arraySlice(index.getColumns(), 0, index.getVisibleColumns());
        this.core.colLen = this.core.mainColArray.length;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, Constraint constraint) {
        this.constName = hsqlName;
        this.constType = 1;
        this.core = constraint.core;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, Table table, Table table2, int[] nArray, int[] nArray2, Index index, Index index2, int n, int n2) throws HsqlException {
        this.core = new ConstraintCore();
        this.core.pkName = hsqlName;
        this.core.fkName = hsqlName2;
        this.constName = hsqlName2;
        this.constType = 0;
        this.core.mainTable = table;
        this.core.refTable = table2;
        this.core.mainColArray = nArray;
        this.core.colLen = this.core.mainColArray.length;
        this.core.refColArray = nArray2;
        this.core.mainIndex = index;
        this.core.refIndex = index2;
        this.core.deleteAction = n;
        this.core.updateAction = n2;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, int[] nArray, Table table, int[] nArray2, int n, int n2, int n3) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.constType = n;
        this.core.mainColArray = nArray;
        this.core.refTable = table;
        this.core.refColArray = nArray2;
        this.core.deleteAction = n2;
        this.core.updateAction = n3;
    }

    private Constraint() {
    }

    HsqlNameManager.HsqlName getName() {
        return this.constName;
    }

    private void setName(String string, boolean bl) throws HsqlException {
        this.constName.rename(string, bl);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.constType;
    }

    Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    int getDeleteAction() {
        return this.core.deleteAction;
    }

    int getUpdateAction() {
        return this.core.updateAction;
    }

    int[] getMainColumns() {
        return this.core.mainColArray;
    }

    int[] getRefColumns() {
        return this.core.refColArray;
    }

    boolean isIndexFK(Index index) {
        return !(this.constType != 0 && this.constType != 1 || this.core.mainIndex != index && this.core.refIndex != index);
    }

    boolean isIndexUnique(Index index) {
        return this.constType == 2 && this.core.mainIndex == index;
    }

    boolean hasColumn(Table table, String string) {
        if (this.constType != 3) {
            return false;
        }
        Expression.Collector collector = new Expression.Collector();
        collector.addAll(this.core.check, 2);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (!expression.getColumnName().equals(string) || !table.tableName.name.equals(expression.getTableName())) continue;
            return true;
        }
        return false;
    }

    boolean isEquivalent(int[] nArray, int n) {
        if (n != this.constType || this.constType != 2 || this.core.colLen != nArray.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.mainColArray, nArray, this.core.colLen);
    }

    boolean isEquivalent(Table table, int[] nArray, Table table2, int[] nArray2) {
        if (this.constType != 1 || this.constType != 0) {
            return false;
        }
        if (table != this.core.mainTable || table2 != this.core.refTable) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.mainColArray, nArray) && ArrayUtil.areEqualSets(this.core.refColArray, nArray2);
    }

    void replaceTable(Table table, Table table2, int n, int n2) throws HsqlException {
        if (table == this.core.mainTable) {
            this.core.mainTable = table2;
            if (this.core.mainIndex != null) {
                this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
                this.core.mainColArray = ArrayUtil.toAdjustedColumnArray(this.core.mainColArray, n, n2);
            }
        }
        if (table == this.core.refTable) {
            this.core.refTable = table2;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                if (this.core.refIndex != this.core.mainIndex) {
                    this.core.refColArray = ArrayUtil.toAdjustedColumnArray(this.core.refColArray, n, n2);
                }
            }
        }
    }

    void checkInsert(Session session, Object[] objectArray) throws HsqlException {
        if (this.constType == 1 || this.constType == 2) {
            return;
        }
        if (this.constType == 3) {
            this.checkCheckConstraint(session, objectArray);
            return;
        }
        if (Index.isNull(objectArray, this.core.refColArray)) {
            return;
        }
        boolean bl = this.core.mainIndex.exists(session, objectArray, this.core.refColArray);
        if (!bl) {
            if (this.core.mainTable == this.core.refTable) {
                boolean bl2 = true;
                for (int i = 0; i < this.core.colLen; ++i) {
                    if (objectArray[this.core.refColArray[i]].equals(objectArray[this.core.mainColArray[i]])) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return;
                }
            }
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.mainTable.getName().name});
        }
    }

    void checkCheckConstraint(Session session, Object[] objectArray) throws HsqlException {
        this.core.checkFilter.currentData = objectArray;
        boolean bl = Boolean.FALSE.equals(this.core.check.test(session));
        this.core.checkFilter.currentData = null;
        if (bl) {
            throw Trace.error(157, 100, new Object[]{this.constName.name, this.core.mainTable.tableName.name});
        }
    }

    RowIterator findFkRef(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        if (objectArray == null || Index.isNull(objectArray, this.core.mainColArray)) {
            return this.core.refIndex.emptyIterator();
        }
        return bl ? this.core.refIndex.findFirstRowForDelete(session, objectArray, this.core.mainColArray) : this.core.refIndex.findFirstRow(session, objectArray, this.core.mainColArray);
    }

    boolean hasMainRef(Session session, Object[] objectArray) throws HsqlException {
        if (Index.isNull(objectArray, this.core.refColArray)) {
            return false;
        }
        boolean bl = this.core.mainIndex.exists(session, objectArray, this.core.refColArray);
        if (!bl) {
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.refTable.getName().name});
        }
        return bl;
    }

    private static boolean hasReferencedRow(Object[] objectArray, int[] nArray, Index index) throws HsqlException {
        if (Index.isNull(objectArray, nArray)) {
            return true;
        }
        return index.exists(null, objectArray, nArray);
    }

    static void checkReferencedRows(Table table, int[] nArray, Index index) throws HsqlException {
        Row row;
        RowIterator rowIterator = table.rowIterator(null);
        while ((row = rowIterator.next()) != null) {
            Object[] objectArray = row.getData();
            if (Constraint.hasReferencedRow(objectArray, nArray, index)) continue;
            String string = "";
            for (int i = 0; i < nArray.length; ++i) {
                Object object = objectArray[nArray[i]];
                string = string + object;
                string = string + ",";
            }
            throw Trace.error(177, 100, new Object[]{string, table.getName().name});
        }
    }
}

