/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.AopOperationNotSupportedException;
import org.jboss.cache.aop.CachedCollectionInterceptor;
import org.jboss.cache.aop.CollectionInterceptorUtil;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

public class CachedSetInterceptor
implements Set,
CachedCollectionInterceptor {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$cache$aop$CachedSetInterceptor == null ? (class$org$jboss$cache$aop$CachedSetInterceptor = CachedSetInterceptor.class$("org.jboss.cache.aop.CachedSetInterceptor")) : class$org$jboss$cache$aop$CachedSetInterceptor));
    protected TreeCacheAop cache;
    protected Fqn fqn;
    protected Map methodMap;
    protected static Map managedMethods = CollectionInterceptorUtil.getManagedMethods(class$java$util$Set == null ? (class$java$util$Set = CachedSetInterceptor.class$("java.util.Set")) : class$java$util$Set);
    static /* synthetic */ Class class$org$jboss$cache$aop$CachedSetInterceptor;
    static /* synthetic */ Class class$java$util$Set;

    public CachedSetInterceptor(TreeCacheAop cache, Fqn fqn, Class clazz) {
        this.cache = cache;
        this.fqn = fqn;
        this.methodMap = CollectionInterceptorUtil.getMethodMap(clazz);
    }

    public String getName() {
        return "CachedSetInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        return CollectionInterceptorUtil.invoke(invocation, this, this.methodMap, managedMethods);
    }

    protected Node getNode() {
        try {
            return this.cache.get(this.fqn);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public int size() {
        Node node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public void clear() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        int ind = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            objs[ind++] = i.next();
        }
        return objs;
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int current = 0;

            public boolean hasNext() {
                return this.current < CachedSetInterceptor.this.size();
            }

            public Object next() {
                try {
                    return CachedSetInterceptor.this.cache.getObject(new Fqn(CachedSetInterceptor.this.fqn, new Integer(this.current++)));
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }

            public void remove() {
                try {
                    int size = CachedSetInterceptor.this.size();
                    if (this.current < size) {
                        Object last = CachedSetInterceptor.this.cache.removeObject(new Fqn(CachedSetInterceptor.this.fqn, new Integer(size - 1)));
                        CachedSetInterceptor.this.cache.putObject(new Fqn(CachedSetInterceptor.this.fqn, new Integer(--this.current)), last);
                    } else {
                        CachedSetInterceptor.this.cache.removeObject(new Fqn(CachedSetInterceptor.this.fqn, new Integer(--this.current)));
                    }
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }
        };
    }

    public Object[] toArray(Object[] a) {
        throw new AopOperationNotSupportedException("CachedSetInterceptor: set.toArray() operation not supported");
    }

    public boolean add(Object o) {
        if (this.contains(o)) {
            return false;
        }
        try {
            this.cache.putObject(new Fqn(this.fqn, new Integer(this.size())), o);
            return true;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public boolean contains(Object o) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object n = i.next();
            if ((o != null || n != null) && (o == null || !o.equals(n))) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object n = i.next();
            if ((o != null || n != null) && (o == null || !o.equals(n))) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedSetInterceptor: set.containsAll() operation not supported");
    }

    public boolean removeAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedSetInterceptor: set.retainAll() operation not supported");
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set list = (Set)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value != null) {
                if (this.contains(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[" + key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

