/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.AopOperationNotSupportedException;
import org.jboss.cache.aop.CachedCollectionInterceptor;
import org.jboss.cache.aop.CollectionInterceptorUtil;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

public class CachedMapInterceptor
implements CachedCollectionInterceptor,
Map {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$cache$aop$CachedMapInterceptor == null ? (class$org$jboss$cache$aop$CachedMapInterceptor = CachedMapInterceptor.class$("org.jboss.cache.aop.CachedMapInterceptor")) : class$org$jboss$cache$aop$CachedMapInterceptor));
    protected static final Map managedMethods = CollectionInterceptorUtil.getManagedMethods(class$java$util$Map == null ? (class$java$util$Map = CachedMapInterceptor.class$("java.util.Map")) : class$java$util$Map);
    protected TreeCacheAop cache;
    protected Fqn fqn;
    protected Map methodMap;
    static /* synthetic */ Class class$org$jboss$cache$aop$CachedMapInterceptor;
    static /* synthetic */ Class class$java$util$Map;

    protected CachedMapInterceptor(TreeCacheAop cache, Fqn fqn, Class clazz) {
        this.cache = cache;
        this.fqn = fqn;
        this.methodMap = CollectionInterceptorUtil.getMethodMap(clazz);
    }

    public String getName() {
        return "CachedMapInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        return CollectionInterceptorUtil.invoke(invocation, this, this.methodMap, managedMethods);
    }

    protected Node getNode() {
        try {
            return this.cache.get(this.fqn);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(Object key) {
        try {
            return this.cache.getObject(new Fqn(this.fqn, key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object put(Object key, Object value) {
        try {
            return this.cache.putObject(new Fqn(this.fqn, key), value);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        try {
            return this.cache.removeObject(new Fqn(this.fqn, key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void clear() {
        ArrayList list = new ArrayList(this.keySet());
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    public int size() {
        Node node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        Map children = this.getNode().getChildren();
        return children == null ? false : children.containsKey(object);
    }

    public boolean containsValue(Object object) {
        throw new AopOperationNotSupportedException("CachedMapInterceptor: map.containsValues() operation not supported");
    }

    public Set entrySet() {
        final CachedMapInterceptor map = this;
        return new AbstractSet(){

            public int size() {
                Map children = CachedMapInterceptor.this.getNode().getChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Map children = CachedMapInterceptor.this.getNode().getChildren();
                final Iterator<Object> i = children == null ? Collections.EMPTY_LIST.iterator() : children.keySet().iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = i.next();
                        return new Entry(this.lastKey);
                    }

                    public void remove() {
                        map.remove(this.lastKey);
                    }
                };
            }
        };
    }

    public Collection values() {
        throw new AopOperationNotSupportedException("CachedMapInterceptor: map.values() operation not supported");
    }

    public Set keySet() {
        Map children = this.getNode().getChildren();
        return children == null ? Collections.EMPTY_SET : children.keySet();
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Object value = entry.getValue();
            if (value != null) {
                if (map.get(entry.getKey()) != null && map.containsKey(entry.getKey())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set set = this.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[" + key).append(", ").append(this.get(key)).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            try {
                return CachedMapInterceptor.this.cache.getObject(new Fqn(CachedMapInterceptor.this.fqn, this.key));
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public Object setValue(Object value) {
            try {
                return CachedMapInterceptor.this.cache.putObject(new Fqn(CachedMapInterceptor.this.fqn, this.key), value);
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }
}

