/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.Range;
import org.jfree.data.ValueDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.util.ObjectUtils;

public class MeterPlot
extends Plot
implements Serializable,
Cloneable {
    public static final int NORMAL_DATA_RANGE = 0;
    public static final int WARNING_DATA_RANGE = 1;
    public static final int CRITICAL_DATA_RANGE = 2;
    public static final int FULL_DATA_RANGE = 3;
    public static final String NORMAL_TEXT = "Normal";
    public static final String WARNING_TEXT = "Warning";
    public static final String CRITICAL_TEXT = "Critical";
    static final Paint DEFAULT_NORMAL_PAINT = Color.green;
    static final Paint DEFAULT_WARNING_PAINT = Color.yellow;
    static final Paint DEFAULT_CRITICAL_PAINT = Color.red;
    static final Paint DEFAULT_DIAL_BACKGROUND_PAINT = Color.black;
    static final Paint DEFAULT_NEEDLE_PAINT = Color.green;
    static final Font DEFAULT_VALUE_FONT = new Font("SansSerif", 1, 12);
    static final Paint DEFAULT_VALUE_PAINT = Color.yellow;
    public static final int DEFAULT_METER_ANGLE = 270;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.lightGray;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private ValueDataset dataset;
    private String units = "Units";
    private Range range;
    private Range normalRange;
    private Range warningRange;
    private Range criticalRange;
    private transient Paint dialOutlinePaint;
    private transient Paint normalPaint = DEFAULT_NORMAL_PAINT;
    private transient Paint warningPaint = DEFAULT_WARNING_PAINT;
    private transient Paint criticalPaint = DEFAULT_CRITICAL_PAINT;
    private DialShape shape = DialShape.CIRCLE;
    private transient Paint dialBackgroundPaint;
    private transient Paint needlePaint;
    private Font valueFont;
    private transient Paint valuePaint;
    private int tickLabelType = 1;
    private Font tickLabelFont;
    private NumberFormat tickLabelFormat;
    private boolean drawBorder;
    private int meterCalcAngle = -1;
    private double meterRange = -1.0;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private int meterAngle = 270;
    private double minMeterValue = 0.0;
    public static final int DIALTYPE_PIE = 0;
    public static final int DIALTYPE_CIRCLE = 1;
    public static final int DIALTYPE_CHORD = 2;

    public MeterPlot() {
        this(null);
    }

    public MeterPlot(ValueDataset dataset) {
        this.range = new Range(0.0, 100.0);
        this.normalRange = new Range(0.0, 60.0);
        this.warningRange = new Range(60.0, 90.0);
        this.criticalRange = new Range(90.0, 100.0);
        this.tickLabelFont = DEFAULT_LABEL_FONT;
        this.tickLabelFormat = NumberFormat.getInstance();
        this.dialBackgroundPaint = DEFAULT_DIAL_BACKGROUND_PAINT;
        this.needlePaint = DEFAULT_NEEDLE_PAINT;
        this.valueFont = DEFAULT_VALUE_FONT;
        this.valuePaint = DEFAULT_VALUE_PAINT;
        this.setDataset(dataset);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Range getNormalRange() {
        return this.normalRange;
    }

    public void setNormalRange(Range range) {
        this.normalRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getWarningRange() {
        return this.warningRange;
    }

    public void setWarningRange(Range range) {
        this.warningRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getCriticalRange() {
        return this.criticalRange;
    }

    public void setCriticalRange(Range range) {
        this.criticalRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DialShape getDialShape() {
        return this.shape;
    }

    public void setDialShape(DialShape shape) {
        this.shape = shape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialBackgroundPaint() {
        return this.dialBackgroundPaint;
    }

    public void setDialBackgroundPaint(Paint paint) {
        this.dialBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNeedlePaint() {
        return this.needlePaint;
    }

    public void setNeedlePaint(Paint paint) {
        this.needlePaint = paint == null ? DEFAULT_NEEDLE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        this.valueFont = font == null ? DEFAULT_VALUE_FONT : font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        this.valuePaint = paint == null ? DEFAULT_VALUE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNormalPaint() {
        return this.normalPaint;
    }

    public void setNormalPaint(Paint paint) {
        this.normalPaint = paint == null ? DEFAULT_NORMAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getWarningPaint() {
        return this.warningPaint;
    }

    public void setWarningPaint(Paint paint) {
        this.warningPaint = paint == null ? DEFAULT_WARNING_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getCriticalPaint() {
        return this.criticalPaint;
    }

    public void setCriticalPaint(Paint paint) {
        this.criticalPaint = paint == null ? DEFAULT_CRITICAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getTickLabelType() {
        return this.tickLabelType;
    }

    public void setTickLabelType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.tickLabelType != type) {
            this.tickLabelType = type;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getTickLabelFormat() {
        return this.tickLabelFormat;
    }

    public void setTickLabelFormat(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.tickLabelFormat = format;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean draw) {
        this.drawBorder = draw;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int angle) {
        this.meterAngle = angle;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialOutlinePaint() {
        return this.dialOutlinePaint;
    }

    public void setDialOutlinePaint(Paint paint) {
        this.dialOutlinePaint = paint;
    }

    public ValueDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ValueDataset dataset) {
        ValueDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public List getLegendItemLabels() {
        return null;
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo info) {
        Insets insets;
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        plotArea.setRect(plotArea.getX() + 4.0, plotArea.getY() + 4.0, plotArea.getWidth() - 8.0, plotArea.getHeight() - 8.0);
        if (this.drawBorder) {
            this.drawBackground(g2, plotArea);
        }
        double gapHorizontal = 6.0;
        double gapVertical = 6.0;
        double meterX = plotArea.getX() + gapHorizontal / 2.0;
        double meterY = plotArea.getY() + gapVertical / 2.0;
        double meterW = plotArea.getWidth() - gapHorizontal;
        double meterH = plotArea.getHeight() - gapVertical + (this.meterAngle <= 180 && this.shape != DialShape.CIRCLE ? plotArea.getHeight() / 1.25 : 0.0);
        double min = Math.min(meterW, meterH) / 2.0;
        meterX = (meterX + meterX + meterW) / 2.0 - min;
        meterY = (meterY + meterY + meterH) / 2.0 - min;
        meterW = 2.0 * min;
        meterH = 2.0 * min;
        Rectangle2D.Double meterArea = new Rectangle2D.Double(meterX, meterY, meterW, meterH);
        Rectangle2D.Double originalArea = new Rectangle2D.Double(((RectangularShape)meterArea).getX() - 4.0, ((RectangularShape)meterArea).getY() - 4.0, ((RectangularShape)meterArea).getWidth() + 8.0, ((RectangularShape)meterArea).getHeight() + 8.0);
        double meterMiddleX = meterArea.getCenterX();
        double meterMiddleY = meterArea.getCenterY();
        ValueDataset data = this.getDataset();
        if (data != null) {
            double dataMin = this.range.getLowerBound();
            double dataMax = this.range.getUpperBound();
            this.minMeterValue = dataMin;
            this.meterCalcAngle = 180 + (this.meterAngle - 180) / 2;
            this.meterRange = dataMax - dataMin;
            Shape savedClip = g2.getClip();
            g2.clip(originalArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            if (this.dialBackgroundPaint != null) {
                this.drawArc(g2, originalArea, dataMin, dataMax, this.dialBackgroundPaint, 1);
            }
            this.drawTicks(g2, meterArea, dataMin, dataMax);
            this.drawArcFor(g2, meterArea, data, 3);
            if (this.normalRange != null) {
                this.drawArcFor(g2, meterArea, data, 0);
            }
            if (this.warningRange != null) {
                this.drawArcFor(g2, meterArea, data, 1);
            }
            if (this.criticalRange != null) {
                this.drawArcFor(g2, meterArea, data, 2);
            }
            if (data.getValue() != null) {
                double dataVal = data.getValue().doubleValue();
                this.drawTick(g2, meterArea, dataVal, true, this.valuePaint, true, this.getUnits());
                g2.setPaint(this.needlePaint);
                g2.setStroke(new BasicStroke(2.0f));
                double radius = ((RectangularShape)meterArea).getWidth() / 2.0 + 3.0 + 15.0;
                double valueAngle = this.calculateAngle(dataVal);
                double valueP1 = meterMiddleX + radius * Math.cos(Math.PI * (valueAngle / 180.0));
                double valueP2 = meterMiddleY - radius * Math.sin(Math.PI * (valueAngle / 180.0));
                Polygon arrow = new Polygon();
                if (valueAngle > 135.0 && valueAngle < 225.0 || valueAngle < 45.0 && valueAngle > -45.0) {
                    double valueP3 = meterMiddleY - 2.5;
                    double valueP4 = meterMiddleY + 2.5;
                    arrow.addPoint((int)meterMiddleX, (int)valueP3);
                    arrow.addPoint((int)meterMiddleX, (int)valueP4);
                } else {
                    arrow.addPoint((int)(meterMiddleX - 2.5), (int)meterMiddleY);
                    arrow.addPoint((int)(meterMiddleX + 2.5), (int)meterMiddleY);
                }
                arrow.addPoint((int)valueP1, (int)valueP2);
                Ellipse2D.Double circle = new Ellipse2D.Double(meterMiddleX - 5.0, meterMiddleY - 5.0, 10.0, 10.0);
                g2.fill(arrow);
                g2.fill(circle);
            }
            g2.clip(savedClip);
            g2.setComposite(originalComposite);
        }
        if (this.drawBorder) {
            this.drawOutline(g2, plotArea);
        }
    }

    protected void drawArcFor(Graphics2D g2, Rectangle2D meterArea, ValueDataset data, int type) {
        double minValue = 0.0;
        double maxValue = 0.0;
        Paint paint = null;
        switch (type) {
            case 0: {
                minValue = this.normalRange.getLowerBound();
                maxValue = this.normalRange.getUpperBound();
                paint = this.getNormalPaint();
                break;
            }
            case 1: {
                minValue = this.warningRange.getLowerBound();
                maxValue = this.warningRange.getUpperBound();
                paint = this.getWarningPaint();
                break;
            }
            case 2: {
                minValue = this.criticalRange.getLowerBound();
                maxValue = this.criticalRange.getUpperBound();
                paint = this.getCriticalPaint();
                break;
            }
            case 3: {
                minValue = this.range.getLowerBound();
                maxValue = this.range.getUpperBound();
                paint = DEFAULT_BACKGROUND_PAINT;
                break;
            }
            default: {
                return;
            }
        }
        this.drawArc(g2, meterArea, minValue, maxValue, paint);
        this.drawTick(g2, meterArea, minValue, true, paint);
        this.drawTick(g2, meterArea, maxValue, true, paint);
    }

    protected void drawArc(Graphics2D g2, Rectangle2D area, double minValue, double maxValue, Paint paint) {
        this.drawArc(g2, area, minValue, maxValue, paint, 0);
    }

    protected void drawArc(Graphics2D g2, Rectangle2D area, double minValue, double maxValue, Paint paint, int outlineType) {
        double startAngle = this.calculateAngle(maxValue);
        double endAngle = this.calculateAngle(minValue);
        double extent = endAngle - startAngle;
        double x = area.getX();
        double y = area.getY();
        double w = area.getWidth();
        double h = area.getHeight();
        g2.setPaint(paint);
        if (outlineType > 0) {
            g2.setStroke(new BasicStroke(10.0f));
        } else {
            g2.setStroke(new BasicStroke(3.0f));
        }
        int joinType = 0;
        if (outlineType > 0) {
            if (this.shape == DialShape.PIE) {
                joinType = 2;
            } else if (this.shape == DialShape.CHORD) {
                joinType = this.meterAngle > 180 ? 1 : 2;
            } else if (this.shape == DialShape.CIRCLE) {
                joinType = 2;
                extent = 360.0;
            } else {
                throw new IllegalStateException("MeterPlot.drawArc(...): dialType not recognised.");
            }
        }
        Arc2D.Double arc = new Arc2D.Double(x, y, w, h, startAngle, extent, joinType);
        if (outlineType > 0) {
            g2.fill(arc);
        } else {
            g2.draw(arc);
        }
    }

    double calculateAngle(double value) {
        double ret = (double)this.meterCalcAngle - (value -= this.minMeterValue) / this.meterRange * (double)this.meterAngle;
        return ret;
    }

    protected void drawTicks(Graphics2D g2, Rectangle2D meterArea, double minValue, double maxValue) {
        int numberOfTicks = 20;
        double diff = (maxValue - minValue) / (double)numberOfTicks;
        for (double i = minValue; i <= maxValue; i += diff) {
            this.drawTick(g2, meterArea, i);
        }
    }

    protected void drawTick(Graphics2D g2, Rectangle2D meterArea, double value) {
        this.drawTick(g2, meterArea, value, false, null, false, null);
    }

    protected void drawTick(Graphics2D g2, Rectangle2D meterArea, double value, boolean label, Paint color) {
        this.drawTick(g2, meterArea, value, label, color, false, null);
    }

    protected void drawTick(Graphics2D g2, Rectangle2D meterArea, double value, boolean label, Paint labelPaint, boolean curValue, String units) {
        double valueAngle = this.calculateAngle(value);
        double meterMiddleX = meterArea.getCenterX();
        double meterMiddleY = meterArea.getCenterY();
        if (labelPaint == null) {
            labelPaint = Color.white;
        }
        g2.setPaint(labelPaint);
        g2.setStroke(new BasicStroke(2.0f));
        double valueP2X = 0.0;
        double valueP2Y = 0.0;
        if (!curValue) {
            double radius = meterArea.getWidth() / 2.0 + 3.0;
            double radius1 = radius - 15.0;
            double valueP1X = meterMiddleX + radius * Math.cos(Math.PI * (valueAngle / 180.0));
            double valueP1Y = meterMiddleY - radius * Math.sin(Math.PI * (valueAngle / 180.0));
            valueP2X = meterMiddleX + radius1 * Math.cos(Math.PI * (valueAngle / 180.0));
            valueP2Y = meterMiddleY - radius1 * Math.sin(Math.PI * (valueAngle / 180.0));
            Line2D.Double line = new Line2D.Double(valueP1X, valueP1Y, valueP2X, valueP2Y);
            g2.draw(line);
        } else {
            valueP2X = meterMiddleX;
            valueP2Y = meterMiddleY;
            valueAngle = 90.0;
        }
        if (this.tickLabelType == 1 && label) {
            String tickLabel = this.tickLabelFormat.format(value);
            if (curValue && units != null) {
                tickLabel = tickLabel + " " + units;
            }
            if (curValue) {
                g2.setFont(this.getValueFont());
            } else if (this.tickLabelFont != null) {
                g2.setFont(this.tickLabelFont);
            }
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D tickLabelBounds = TextUtilities.getTextBounds((String)tickLabel, (Graphics2D)g2, (FontMetrics)fm);
            double x = valueP2X;
            double y = valueP2Y;
            if (curValue) {
                y += 10.0;
            }
            if (valueAngle == 90.0 || valueAngle == 270.0) {
                x -= tickLabelBounds.getWidth() / 2.0;
            } else if (valueAngle < 90.0 || valueAngle > 270.0) {
                x -= tickLabelBounds.getWidth();
            }
            y = valueAngle > 135.0 && valueAngle < 225.0 || valueAngle > 315.0 || valueAngle < 45.0 ? (y -= tickLabelBounds.getHeight() / 2.0) : (y += tickLabelBounds.getHeight() / 2.0);
            g2.drawString(tickLabel, (float)x, (float)y);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Meter_Plot");
    }

    public void zoom(double percent) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MeterPlot && super.equals(object)) {
            MeterPlot p = (MeterPlot)object;
            if (!ObjectUtils.equal((Object)this.units, (Object)p.units)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.range, (Object)p.range)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.normalRange, (Object)p.normalRange)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.warningRange, (Object)p.warningRange)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.criticalRange, (Object)p.criticalRange)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.dialOutlinePaint, (Object)p.dialOutlinePaint)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.normalPaint, (Object)p.normalPaint)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.warningPaint, (Object)p.warningPaint)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.criticalPaint, (Object)p.criticalPaint)) {
                return false;
            }
            if (this.shape != p.shape) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.dialBackgroundPaint, (Object)p.dialBackgroundPaint)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.needlePaint, (Object)p.needlePaint)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.valueFont, (Object)p.valueFont)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.valuePaint, (Object)p.valuePaint)) {
                return false;
            }
            if (this.tickLabelType != p.tickLabelType) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.tickLabelFont, (Object)p.tickLabelFont)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.tickLabelFormat, (Object)p.tickLabelFormat)) {
                return false;
            }
            if (this.drawBorder != p.drawBorder) {
                return false;
            }
            return this.meterAngle == p.meterAngle;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.criticalPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.dialBackgroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.needlePaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.normalPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.valuePaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.warningPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.criticalPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.dialBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.needlePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.normalPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.valuePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.warningPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
    }

    public int getDialType() {
        if (this.shape == DialShape.CIRCLE) {
            return 1;
        }
        if (this.shape == DialShape.CHORD) {
            return 2;
        }
        if (this.shape == DialShape.PIE) {
            return 0;
        }
        throw new IllegalStateException("MeterPlot.getDialType: unrecognised dial type.");
    }

    public void setDialType(int type) {
        switch (type) {
            case 1: {
                this.setDialShape(DialShape.CIRCLE);
                break;
            }
            case 2: {
                this.setDialShape(DialShape.CHORD);
                break;
            }
            case 0: {
                this.setDialShape(DialShape.PIE);
                break;
            }
            default: {
                throw new IllegalArgumentException("MeterPlot.setDialType: unrecognised type.");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlot clone = (MeterPlot)super.clone();
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        return clone;
    }
}

