/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.monitor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.monitor.Monitor;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public class MonitorFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$monitor$MonitorFactory == null ? (class$org$apache$juddi$monitor$MonitorFactory = MonitorFactory.class$("org.apache.juddi.monitor.MonitorFactory")) : class$org$apache$juddi$monitor$MonitorFactory));
    private static final String IMPL_KEY = "juddi.monitor";
    private static final String DEFAULT_IMPL = "org.apache.juddi.monitor.jdbc.JDBCMonitor";
    private static Class monitorClass = null;
    static /* synthetic */ Class class$org$apache$juddi$monitor$MonitorFactory;

    public static Monitor getMonitor() {
        Monitor monitor = null;
        String needsMonitor = Config.getStringProperty(IMPL_KEY, null);
        if (needsMonitor != null) {
            MonitorFactory.getMonitorClass();
            if (monitorClass != null) {
                try {
                    monitor = (Monitor)monitorClass.newInstance();
                }
                catch (Exception ex) {
                    log.error((Object)("Exception while attempting to instantiate subclass of Monitor: \n" + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        return monitor;
    }

    private static synchronized void getMonitorClass() {
        if (monitorClass == null) {
            String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
            log.debug((Object)className);
            try {
                monitorClass = Loader.getClassForName(className);
            }
            catch (ClassNotFoundException cnfex) {
                log.error((Object)("The specified Monitor class '" + className + "' was not found in classpath."), (Throwable)cnfex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

