/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.response.PublisherAssertions;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherAssertionsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisherAssertions";
    private HandlerMaker maker = null;

    protected PublisherAssertionsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        PublisherAssertions obj = new PublisherAssertions();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "publisherAssertion");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("publisherAssertion");
            obj.addPublisherAssertion((PublisherAssertion)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        PublisherAssertions assertions = (PublisherAssertions)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = assertions.getGeneric();
        if (generic != null && generic.trim().length() > 0) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        } else {
            element.setAttribute("generic", "2.0");
            element.setAttribute("xmlns", "urn:uddi-org:api_v2");
        }
        String operator = assertions.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        Vector vector = assertions.getPublisherAssertionVector();
        if (vector != null && vector.size() > 0) {
            handler = this.maker.lookup("publisherAssertion");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((PublisherAssertion)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        PublisherAssertion assertion = new PublisherAssertion();
        assertion.setFromKey("b2f072e7-6013-4385-93b4-9c1c2ece1c8f");
        assertion.setToKey("115be72d-0c04-4b5f-a729-79a522629c19");
        assertion.setKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        PublisherAssertions assertions = new PublisherAssertions();
        assertions.setGeneric("2.0");
        assertions.setOperator("jUDDI.org");
        assertions.addPublisherAssertion(assertion);
        assertions.addPublisherAssertion(assertion);
        System.out.println();
        RegistryObject regObject = assertions;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

